/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/JIKV
 */

//
//　カメラを使ってマトリックスっぽい事をやってみたかった。
//　それっぽくなってきたけどもうちょっと調整が必要
//
package {
    import caurina.transitions.Tweener;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.text.TextField;
	import flash.utils.Timer;

	[SWF(backgroundColor="#ffffff", frameRate=30)]
	public class CameraTest extends Sprite
	{
		private const CAMERA_WIDTH:uint = 200;
		private const CAMERA_HEIGHT:uint = 150;
		
		private var _video:Video;
		private var _imgList:Array = new Array();
		private var _idx:uint = 0;
		private var _orgBmpData:BitmapData;
		private var _timer:Timer;
		
		public function CameraTest()
		{
			var camera:Camera = Camera.getCamera();
			if (camera) {
				_video = new Video(CAMERA_WIDTH, CAMERA_HEIGHT);
				_video.attachCamera(camera);
				addChild(_video);
				
				for (var i:int=0; i<10; i++) {
					var bitmap:Bitmap = new Bitmap(new BitmapData(_video.width, _video.height, true, 0x01000000));
					bitmap.x = 0;//_video.width;
					bitmap.y = 0;
					addChild(bitmap);
					_imgList.push(bitmap);
				}
				
				_orgBmpData = new BitmapData(_video.width, _video.height, true, 0x01000000);
				
				var sprite:Sprite = new Sprite();
				sprite.graphics.beginFill(0);
				sprite.graphics.drawRoundRect(0,0,100,50,10,10);
				sprite.graphics.endFill();
				sprite.x = 0;
				sprite.y = _video.height;
				sprite.useHandCursor = true;
				sprite.buttonMode = true;
				sprite.addEventListener(MouseEvent.CLICK, onClick);
				addChild(sprite);
				
				_timer = new Timer(100);
				_timer.addEventListener(TimerEvent.TIMER, onTimer);
			}
			else {
				var textField:TextField = new TextField();
				textField.text = "No Camera";
				addChild(textField);
			}
		}
		
		/**
		 * タイマーイベント
		 */
		private function onTimer(e:TimerEvent):void {			
			var destBmp:Bitmap = Bitmap(_imgList[_idx]);
			
			var videoBmpData:BitmapData = new BitmapData(_video.width, _video.height);
			videoBmpData.draw(_video);
			destBmp.bitmapData.lock();
			for (var i:int=0; i<_video.height; i++) {
				for (var j:int=0; j<_video.width; j++) {
					if (comparePixels(_orgBmpData.getPixel(j,i), videoBmpData.getPixel(j,i), 25)) {
						destBmp.bitmapData.setPixel32(j,i,videoBmpData.getPixel32(j,i));
					}
					else {
						destBmp.bitmapData.setPixel32(j,i,0x00000000);
					}
				}
			}
			destBmp.bitmapData.unlock();
			destBmp.alpha = 1;
			this.setChildIndex(destBmp, this.numChildren-1);
			Tweener.addTween(destBmp, {alpha:0, time:3, transition:"easeInSine"});
			
			_idx++;
			if (_idx >= _imgList.length) {
				_idx = 0;
			}
		}
		
		private function comparePixels(src:int, dest:int, threshold:int):Boolean{
		    var srcRed:int = src>>16&0xFF;
		    var srcGreen:int = src>>8&0xFF;
		    var srcBlue:int = src&0xFF;
		    
		    var destRed:int = dest>>16&0xFF;
		    var destGreen:int = dest>>8&0xFF;
		    var destBlue:int = dest&0xFF;
			
			if ( Math.abs(srcRed-destRed) > threshold || 
				 Math.abs(srcGreen-destGreen) > threshold || 
				 Math.abs(srcBlue-destBlue) > threshold ||
				 Math.abs(destRed-srcRed) > threshold || 
				 Math.abs(destGreen-srcGreen) > threshold || 
				 Math.abs(destBlue-srcBlue) > threshold ) {
				return true;
			}
			else {
				return false;
			}
		}
		
		private function onClick(e:MouseEvent):void {
			e.target.removeEventListener(MouseEvent.CLICK, onClick);
			
			_orgBmpData.draw(_video);
			_timer.start();
		}
	}
}