/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/JFdb
 */

package {
    import flash.text.TextField;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.display.AVM1Movie;
    import flash.ui.Mouse;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var canvas:Sprite;
        private var cursor:Sprite;
        private var player:Sprite;
        
        private var bulletSpeed:Number = 2;    // bullet speed is bullet damage...
        private var maxBullets:Number = 5;
        private var gapBullets:Number = 500;
        private var bulletTick:Timer = new Timer(gapBullets);
        private var bullets:Array = [];
        private var enemies:Array = [];
        private var battleStyle:GlowFilter = new GlowFilter(0xffffff);
        
        private var managerEnemy:EnemyManager;
        private var message:TextField;
        public function FlashTest() {
            // write as3 code here..
            initCanvas();
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onStage);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, startShoot);
            stage.addEventListener(MouseEvent.MOUSE_UP, stopShoot);
            bulletTick.addEventListener(TimerEvent.TIMER, shoot);
            
            stage.addEventListener('enemyDead',removeDead);
            
            managerEnemy = new EnemyManager(canvas);
            enemies = managerEnemy.newWave();
            
            playGame('Start Game!');
        }
        private function playGame(reason:String):void {
            stage.addEventListener(Event.ENTER_FRAME, gameLoop);
            message.text = reason; message.alpha = 1;
        }
        private function stopGame(reason:String):void {
            stage.removeEventListener(Event.ENTER_FRAME, gameLoop);
            message.text = reason; message.alpha = 1;
        }
        
        private function onStage(e:MouseEvent):void {
            Mouse.hide();
            cursor.x = mouseX; cursor.y = mouseY;
        }
        private function removeDead(e:Event):void {
            for(var i:int=0; i<enemies.length; i++){
                if(enemies[i]==e.target){
                    enemies.splice(i,1);
                }
            }
            canvas.removeChild(e.target as Enemy); 
        }

        private function gameLoop(e:Event):void {
            cursor.rotation += 2;
            player.rotation = myMath.getRotateTo(player.x, player.y, cursor.x, cursor.y)*180/Math.PI;
            var bRotate:Number;
            for(var i:int=0; i<bullets.length; i++) {
                bRotate = bullets[i].rotation/180*Math.PI;
                if(bullets[i].x < 600 && bullets[i].x > -50 && bullets[i].y < 600 && bullets[i].y > -50){
                    bullets[i].x += Math.cos(bRotate)*bulletSpeed;
                    bullets[i].y += Math.sin(bRotate)*bulletSpeed;
                }
            }
            for(i=0; i<enemies.length; i++ ){
                (enemies[i] as Enemy).update(player);
                for(var b:int=0; b<bullets.length; b++){
                    if(myMath.getDistantion(enemies[i].x,enemies[i].y,bullets[b].x,bullets[b].y) < enemies[i].size && bullets[b].stage){
                        enemies[i].damaged(bulletSpeed);
                        canvas.removeChild(bullets[b]);
                    }
                    if(myMath.getDistantion(enemies[i].x,enemies[i].y,player.x,player.y) < enemies[i].size && enemies[i].stage ) {
                        // they got to us !!
                        stopGame('Game Over (T_T)');
                    }
                }
            }
            if(enemies.length == 0){
                stopGame('Win wave '+managerEnemy.nowWave+'\nupgrade time');
                upgradeTime();
            }
            if(message.alpha > 0.05){
                message.alpha *= 0.9;
            } else {
                message.alpha = 0;
            }
        }
        
        private function startShoot(e:MouseEvent):void {
            bulletTick.start();
            shoot();
        }
        private function stopShoot(e:MouseEvent):void {
            bulletTick.stop();
        }
        
        private function shoot(e:TimerEvent=null):void {
            var b:Sprite;
            if(bullets.length < maxBullets){
                b = getGraphics.element(2, getGraphics.BULLET_01);
            } else {
                b = bullets.splice(0,1)[0];
            }
            b.x = player.x; b.y = player.y;
            b.rotation = player.rotation;
            bullets.push(b);
            canvas.addChild(b);
        }

        private function initCanvas():void{
            this.graphics.beginFill(0);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();
            canvas = new Sprite();
            canvas.filters = [battleStyle];
            addChild(canvas);
            cursor = getGraphics.element(2,getGraphics.FORM_CURSOR);//new Sprite();
            canvas.addChild(cursor);
            player = getGraphics.element(2, getGraphics.PLAYER_01);
            player.x = stage.stageWidth/2;
            player.y = stage.stageHeight/2;
            canvas.addChild(player);
            message = new TextField();
            message.x = 50; message.y = 50;
            message.autoSize = 'left';
            message.textColor = 0xffffff;
            message.scaleX = message.scaleY = 4;
            message.text = 'message text';
            message.mouseEnabled = false;
            canvas.addChild(message);
            upgradePanel = new Sprite();    // yes, it is a bad decision, but I am too lazy
            var bul_speed:Sprite = getGraphics.element(2, getGraphics.BULLET_SPD,true);
            bul_speed.x = 120; bul_speed.y = 220;
            upgradePanel.addChild(bul_speed);
            bul_speed.addEventListener(MouseEvent.CLICK, addSpeed);
            var bul_max:Sprite = getGraphics.element(2, getGraphics.BULLET_MAX,true);
            bul_max.x = 120; bul_max.y = 270;
            upgradePanel.addChild(bul_max);
            bul_max.addEventListener(MouseEvent.CLICK, addMax);
            var bul_gap:Sprite = getGraphics.element(2, getGraphics.BULLET_GAP,true);
            bul_gap.x = 120; bul_gap.y = 320;
            upgradePanel.addChild(bul_gap);
            bul_gap.addEventListener(MouseEvent.CLICK, removeGap);
        }
        private var upgradePanel:Sprite;
        private function upgradeTime():void {
            canvas.addChild(upgradePanel);
        }
        private function addSpeed(e:MouseEvent):void {
            bulletSpeed++;
            endUpgrade();
        }
        private function addMax(e:MouseEvent):void {
            maxBullets++
            endUpgrade();
        }
        private function removeGap(e:MouseEvent):void {
            endUpgrade();
        }

        private function endUpgrade():void {
            enemies = managerEnemy.newWave();
            canvas.removeChild(upgradePanel);
            playGame('New Wave:'+managerEnemy.nowWave);
        }
        
        public function changeButtleStyle(color:uint=0xffffff):void{
            battleStyle.color = color;
            canvas.filters = [battleStyle];
        }
    }
}
import flash.events.Event;
import flash.display.Sprite;
Class {
    
    class getGraphics {
        public static const PLAYER_01:String = "cir 0 0 8,lin 0 -2 12 -2,lin 0 2 12 2";
        public static const BULLET_01:String = "lin 0 0 10 0";
        
        public static const FORM_CURSOR:String = "lin 4 0 10 0,lin 0 4 0 10,lin -4 0 -10 0,lin 0 -4 0 -10";
        public static const BULLET_SPD:String = "cir 0 0 20,lin 8 0 -6 -6,lin 8 0 -6 6";
        public static const BULLET_MAX:String = "cir 0 0 20,lin -10 0 10 0,lin 0 -10 0 10";
        public static const BULLET_GAP:String = "cir 0 0 20,lin -8 -8 -8 8,lin 0 -10 0 10,lin 8 -8 8 8";
        
        public static const ENEMY_01:String = "lin 20 0 -20 -20,lin -20 -20 -20 20,lin -20 20 20 0";
        public static const ENEMY_02:String = "lin 20 0 -20 -20,lin -20 20 20 0,lin 0 -30 0 30,cir -30 0 10,cir 30 0 10";
       
        public static function element(lineWi:Number, data:String="cir 0 0 4", fill:Boolean=false):Sprite{
            var elements:Array = data.split(',');    // Для каждого должна быть вызванна отрисовка
            var graph:Array;
            var el:Sprite = new Sprite();
            el.graphics.lineStyle(lineWi,0xffffff);
            if(fill){
                el.graphics.beginFill(0xffffff,0.3);
                el.graphics.lineStyle(lineWi,0xff0000);
            }
            for(var e:int=0; e<elements.length; e++){
                // теперь выбираем свойство отрисовки
                
                graph = elements[e].split(" ");
                if(graph[0]=="lin"){
                    el.graphics.moveTo(graph[1],graph[2]);
                    el.graphics.lineTo(graph[3],graph[4]);
                } else if(graph[0]=='cir') {
                    el.graphics.drawCircle(graph[1],graph[2],graph[3]);
                }
                el.graphics.endFill();
            }
            return el;
        }
    }
    class myMath {
        public static function getRotateTo(x1:Number=0,y1:Number=0,x2:Number=0,y2:Number=0):Number{
            var dx:Number = x2-x1;
            var dy:Number = y2-y1;
            return Math.atan2(dy,dx);
        }
        public static function getDistantion(x1:Number=0,y1:Number=0,x2:Number=0,y2:Number=0):Number{
            var dx:Number = x2-x1;
            var dy:Number = y2-y1;
            return Math.sqrt(dx*dx+dy*dy);
        }
    }
    class EnemyManager {
        public var enemyWaves:Array = [waveEnemies.SINGLE_WARIOR, waveEnemies.GANG_OF_FOUR, waveEnemies.MATHER_SHEEP];
        public var nowWave:int = 0;
        
        private var world:Sprite;
        public function EnemyManager(world:Sprite, dificulty:String='normal') {
            this.world = world;
        }
        public function newWave():Array {
            var enemies:Array = waveEnemies.enemies( enemyWaves[nowWave] ); //.SINGLE_WARIOR );
            for(var i:int=0; i<enemies.length; i++){
                world.addChild(enemies[i]);
            }
            nowWave++;
            return enemies;
        }
    }
    class waveEnemies {                        // type x y speed life
        public static const SINGLE_WARIOR:String = 'enemy_1 200 -20 1 12';
        public static const GANG_OF_FOUR:String = 'enemy_1 100 -20 2 5,enemy_1 200 -20 2 5,enemy_1 250 -20 2 5,enemy_1 300 -20 2 5';
        public static const MATHER_SHEEP:String = 'enemy_2 -20 -20 1 26';
        public static function enemies(data:String):Array {
            var enemiesArr:Array = data.split(',');
            var enemy:Array;
            var resultEnemy:Array = [];
            for(var i:int=0; i<enemiesArr.length; i++){
                enemy = enemiesArr[i].split(" ");
                var en:Enemy;
                if(enemy[0]=='enemy_1'){
                    en = new Enemy(getGraphics.element(2,getGraphics.ENEMY_01), enemy[4]);    // set graphics and life
                } else if(enemy[0]=='enemy_2'){
                    en = new Enemy(getGraphics.element(2,getGraphics.ENEMY_02), enemy[4]);
                }
                en.x = enemy[1]; en.y = enemy[2];
                en.speed = enemy[3];
                resultEnemy.push(en);
            }
            return resultEnemy;
        }
    }
    class Enemy extends Sprite {
        public var size:Number = 0;
        public var speed:Number = 2;
        public var life:Number = 5;
        public function Enemy(spr:Sprite, life:Number):void {
           // spr.x = -spr.width;
           // spr.y = -spr.height;
            this.life = life;
            this.size = spr.width*spr.height/(spr.width+spr.height);    // радиус вписанной окружности равен площади / полупериметр
            addChild(spr);
            this.graphics.lineStyle(1,0xffffff);
            this.graphics.drawCircle(0,0,size);
            this.graphics.lineStyle(1,0xff0000);
            this.graphics.drawCircle(0,0,life);
        }
        private var direct:Number;
        public function update(player:Sprite):void {
            direct = myMath.getRotateTo(this.x, this.y, player.x, player.y);
            this.rotation = direct*180/Math.PI;
            this.x += Math.cos(direct)*speed;
            this.y += Math.sin(direct)*speed;
        }
        public function damaged(d:Number):void {
            life -= d;
            this.rotation += speed;
            this.graphics.clear();
            this.graphics.lineStyle(1,0xffffff);
            this.graphics.drawCircle(0,0,size);
            this.graphics.lineStyle(1,0xff0000);
            this.graphics.drawCircle(0,0,life);
            if(life <= 0){
                dispatchEvent(new Event('enemyDead',true));
            }
        }
    }
}