/**
 * Copyright J.J ( http://wonderfl.net/user/J.J )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/IlX9
 */

package  {

    

    import flash.display.MovieClip;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import com.bit101.components.CheckBox;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.HSlider;
    import com.bit101.components.Component;
    import com.bit101.components.CheckBox;    

    public class LawOfSin extends MovieClip {        

        public var w:int;
        public var h:int;
        public var R:Number;
        public var mc:MovieClip;
        private var g:Graphics;
        private var A:MovieClip;
        private var B:MovieClip;
        private var C:MovieClip;
        private var me:MovieClip;
        private var center:Point;
        private var fixed:Boolean=false;
        private var fixedBox:CheckBox;
        private var isDown:Boolean=false;
        private var alabel:Label;
        private var blabel:Label;
        private var clabel:Label;

        public function LawOfSin() {            
            B=new MovieClip();
            center=new Point();
            w=stage.stageWidth;
            h=stage.stageHeight;
            mc=new MovieClip();
            this.graphics.beginFill(0x101010);
            this.graphics.drawRect(0,0,w,h);
            g=mc.graphics;
            A=new MovieClip();
            C=new MovieClip();
            createPoint(A,20,200,0x00f6ff);
            createPoint(B,150,180,0x00f6ff);
            createPoint(C,400,400,0x00f6ff);
            A.isPoint=true;
            B.isPoint=true;
            C.isPoint=true;

            this.addChild(mc);
            fixedBox=new CheckBox(this,10,10,"fixed radius");
            alabel=new Label(this,A.x,A.y,"A");
            blabel=new Label(this,B.x,B.y,"B");
            clabel=new Label(this,C.x,C.y,"C");
            this.addEventListener(Event.ENTER_FRAME,loop);

            stage.addEventListener(MouseEvent.MOUSE_UP,function (e:MouseEvent){

                isDown=false;
                if(me) me.stopDrag()})

        }

        public function md(e:MouseEvent):void{
            me=e.target as MovieClip;
            isDown=true;
            if(!fixedBox.selected && me.isPoint) me.startDrag()

        }

        public function loop(e:Event):void{
            g.clear();
            draw();

        }

        public function draw():void{

            alabel.x=A.x;
            alabel.y=A.y;
            blabel.x=B.x;
            blabel.y=B.y;
            clabel.x=C.x;
            clabel.y=C.y;
            var AB:Point=new Point(B.x-A.x,B.y-A.y);
            var ab:Number=Math.sqrt(AB.x*AB.x+AB.y*AB.y);
            var AC:Point=new Point(C.x-A.x,C.y-A.y);
            var ac:Number=Math.sqrt(AC.x*AC.x+AC.y*AC.y);
            var BC:Point=new Point(C.x-B.x,C.y-B.y);
            var BCp:Point=new Point(BC.y,-BC.x);
            var bcp:Number=Math.sqrt(BCp.x*BCp.x+BCp.y*BCp.y);
            var bc:Number=Math.sqrt(BC.x*BC.x+BC.y*BC.y);
            var cross:Number=AB.x*AC.y-AB.y*AC.x;
            var sint:Number=-cross/(ab*ac);
            var Aangle:Number=getAngle(AB,AC);
            AB.x*=-1;
            AB.y*=-1;

            var Bangle:Number=getAngle(BC,AB);
            AB.x*=-1;
            AB.y*=-1;
            var Cangle:Number=getAngle(BC,AC);
            alabel.text="A: "+((Aangle/Math.PI)*180).toFixed(1)+"°";
            blabel.text="B: "+((Bangle/Math.PI)*180).toFixed(1)+"°";
            clabel.text="C: "+((Cangle/Math.PI)*180).toFixed(1)+"°";
            var BCPN:Point=new Point(BCp.x/bcp*R,BCp.y*R/bcp);
            var W:Point=new Point(BC.x/2+B.x,BC.y/2+B.y);
            var NW:Point=new Point(-BC.y/bc,BC.x/bc);
            var P:Point=new Point(AB.x/2+A.x,AB.y/2+A.y);
            var NP:Point=new Point(-AB.y/ab,AB.x/ab);
            var Q:Point=new Point(AC.x/2+A.x,AC.y/2+A.y);
            var NQ:Point=new Point(-AC.y/ac,AC.x/ac)
            var dx:Number = Q.x - P.x
            var dy:Number = Q.y - P.y
            var det:Number = NQ.x * NP.y - NQ.y * NP.x
            var u:Number= (dy * NQ.x - dx * NQ.y) / det
            var v:Number= (dy * NP.x - dx * NP.y) / det
            g.lineStyle(1,0x808080,.3);
            var r:int=1000;
            g.moveTo(Q.x+NQ.x*r,Q.y+NQ.y*r);
            g.lineTo(Q.x-NQ.x*r,Q.y-NQ.y*r);
            g.moveTo(P.x+NP.x*r,P.y+NP.y*r);
            g.lineTo(P.x-NP.x*r,P.y-NP.y*r);
            g.moveTo(W.x+NW.x*r,W.y+NW.y*r);
            g.lineTo(W.x-NW.x*r,W.y-NW.y*r);
            g.lineStyle(1,0xffffff);

            if(fixedBox.selected==false){
                R=bc/sint;
            center.x=Q.x+NQ.x*v;
            center.y=Q.y+NQ.y*v;

        }
            g.beginFill(0x7F9DB9,.1);
            g.drawCircle(center.x,center.y,R/2);
            g.drawCircle(center.x,center.y,5);
            if(fixedBox.selected && isDown){
                var pn:Point=new Point(stage.mouseX-center.x,stage.mouseY-center.y);
                R=Math.abs(R);
                var pnl=Math.sqrt((pn.x*pn.x+pn.y*pn.y));
                pn.x*=(R/2)/pnl;
                pn.y*=(R/2)/pnl;
                if(me.isPoint) {me.y=(pn.y+center.y); me.x=(pn.x+center.x)}
                }
                g.beginFill(0x11aaff,.2);
                g.moveTo(A.x,A.y);g.lineTo(B.x,B.y);g.lineTo(C.x,C.y);

        }

        public function getAngle(A:Point,B:Point){

            //a.b=|A||B|cos(t);
            var ab:Number=A.x*B.x+A.y*B.y;
            var Amag:Number=Math.sqrt(A.x*A.x+A.y*A.y);
            var Bmag:Number=Math.sqrt(B.x*B.x+B.y*B.y);
            var cost:Number=ab/(Amag*Bmag);
            return Math.abs(Math.acos(cost));
            
            }

        public function createPoint(mo:MovieClip,_x:Number,_y:Number,colr:uint){
            mo.x=_x;
            mo.y=_y;
            mo.graphics.lineStyle(1,0xffffff);
            mo.graphics.beginFill(0,0);
            mo.graphics.drawCircle(0,0,4)
            //mo.graphics.drawRect(-7/2,-7/2,7,7);
            mc.addEventListener(MouseEvent.MOUSE_DOWN,md);
            mc.addChild(mo);
            }
    }

}

