/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/IeWi
 */

// forked from tepe's forked from: Neural Network - Wine Classification
// forked from greentec's Neural Network - Wine Classification

package {
    
    import com.bit101.charts.LineChart;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.TextArea;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    //パーセプトロン
    public class FlashTest extends Sprite {
        
        public var iter:int = 0;        
        
        //各レイヤーのニューロン数
        public var inputNeuronNum:int = 13;
        public var hiddenNeuronNum:int = 5;
        public var outputNeuronNum:int = 3;
        
        //レイヤー
        public var inputLayer:Layer;
        public var hiddenLayer:Layer;
        public var outputLayer:Layer;
        
        //画面構成
        public var errorChart:LineChart;//チャート画面
        public var proceedNumLabel:Label;//プロセス数
        public var debugLabel:Label;//デバッグ表示
        public var testButton:PushButton;//testボタン
        public var testTextArea:TextField;//テキストエリア
        public var resetButton:PushButton;//リセットボタン
        
        //パラメータ
        public var learnRate:Number = 0.25;
        public var _alpha:Number = 0.9; // for momentum
        public var beta:Number;
        
        public var wineTxt:String = "0.787,0.186,0.455,0.278,0.283,0.576,0.42,0.245,0.495,0.292,0.455,0.85,0.54,1,0,0\n0.439,0.555,0.535,0.562,0.391,0.248,0.181,0.075,0.136,0.317,0.244,0.007,0.23,0,0,1\n0.65,0.47,0.674,0.691,0.576,0.145,0.259,0.17,0.265,0.625,0.089,0.011,0.158,0,0,1\n0.532,1,0.412,0.562,0.174,0.566,0.487,0.321,0.505,0.113,0.203,0.67,0.073,0,1,0\n0.479,0.17,0.62,0.371,0.272,0.517,0.428,0.245,0.331,0.226,0.496,0.864,0.526,1,0,0\n0.879,0.239,0.61,0.32,0.467,0.99,0.665,0.208,0.558,0.556,0.309,0.799,0.857,1,0,0\n0.687,0.466,0.642,0.237,0.5,0.593,0.568,0.075,0.394,0.326,0.39,0.766,0.404,1,0,0\n0.445,0.2,0.492,0.613,0.152,0.138,0.3,0.66,0.385,0.172,0.325,0.421,0.15,0,1,0\n0.721,0.229,0.706,0.335,0.489,0.697,0.517,0.491,0.401,0.428,0.528,0.608,0.782,1,0,0\n0.582,0.366,0.807,0.536,0.522,0.628,0.496,0.491,0.445,0.259,0.455,0.608,0.326,1,0,0\n0.221,0.706,0.551,0.536,0.13,0.648,0.568,0.151,0.789,0.13,0.22,0.868,0.073,0,1,0\n0.739,0.668,0.545,0.459,0.207,0.283,0.103,0.66,0.363,0.66,0.073,0.136,0.144,0,0,1\n0.395,0.943,0.684,0.742,0.283,0.279,0.055,0.943,0.218,0.317,0.276,0.154,0.169,0,0,1\n0.276,0.077,0.615,0.691,0.087,0.352,0.262,0.509,0.312,0.078,0.675,0.531,0.251,0,1,0\n0.837,0.652,0.578,0.428,0.446,0.645,0.487,0.321,0.265,0.338,0.317,0.755,0.572,1,0,0\n0.439,0.619,0.556,0.639,0.337,0.638,0.466,0.566,0.486,0.11,0.577,0.681,0.132,0,1,0\n0.75,0.227,0.658,0.227,0.337,0.783,0.679,0.075,0.407,0.354,0.325,0.839,0.583,1,0,0\n0.832,0.168,0.599,0.304,0.413,0.8,0.757,0.358,0.457,0.633,0.61,0.568,1,1,0,0\n0.321,0.621,0.449,0.407,0.457,0.138,0.093,0.302,0.23,0.591,0.138,0.267,0.412,0,0,1\n0.508,0.536,0.529,0.407,0.391,0.141,0.076,0.509,0.167,0.341,0.163,0.176,0.283,0,0,1\n0.1,0,0.61,0.536,0.196,0.517,0.352,0.547,0.325,0.154,0.504,0.381,0.111,0,1,0\n0.871,0.186,0.717,0.742,0.304,0.628,0.205,0.755,0.722,1,0.073,0.253,0.272,0,0,1\n0.321,0.196,0.406,0.433,0.109,0.231,0.357,0.453,0.385,0.181,0.423,0.696,0.165,0,1,0\n0.592,0.178,0.791,0.253,0.435,0.559,0.494,0.396,0.3,0.283,0.496,0.553,0.429,1,0,0\n0.297,0.172,0.508,0.629,0.217,0.276,0.285,0.566,0.363,0.1,0.691,0.363,0.155,0,1,0\n0.613,0.36,0.529,0.485,0.207,0.145,0.034,0.453,0.073,0.369,0.179,0.44,0.358,0,0,1\n0.213,0.03,0.652,0.381,0.261,0.421,0.395,0.17,0.612,0.151,0.252,0.663,0.173,0,1,0\n0.432,0.047,0.471,0.381,0.315,0.421,0.338,0.321,0.331,0.114,0.61,0.692,0.123,0,1,0\n0.332,0.172,0.455,0.505,0.359,0.041,0.143,0.453,0.331,0.151,0.346,0.201,0.422,0,1,0\n0.332,0.48,0.455,0.381,0.196,0.645,0.559,0.604,0.757,0.087,0.764,0.571,0.091,0,1,0\n1,0.178,0.433,0.175,0.293,0.628,0.557,0.302,0.495,0.334,0.488,0.579,0.547,1,0,0\n0.342,0.049,0.316,0.216,0.717,0.317,0.319,0.415,0.741,0.181,0.472,0.381,0.337,0,1,0\n0.75,0.85,0.465,0.485,0.109,0,0,0.509,0.085,0.309,0.081,0.022,0.098,0,0,1\n0.342,0.071,0.492,0.278,0.337,0.369,0.158,0.943,0,0.17,0.626,0.147,0.287,0,1,0\n0.353,0.093,0.642,0.387,0.304,0.497,0.487,0.453,0.527,0.283,0.577,0.377,0.285,0,1,0\n0.745,0.152,0.701,0.742,0.174,0.679,0.532,0.151,0.461,0.179,0.715,0.692,0.094,0,1,0\n0.308,0.453,0.513,0.433,0.283,0.093,0.032,0.509,0.101,0.36,0.146,0.205,0.165,0,0,1\n0.321,0.787,0.631,0.536,0.207,0.138,0.027,0.755,0.123,0.219,0.22,0,0.315,0,0,1\n0.353,0.04,0,0,0.196,0.345,0.049,0.283,0.003,0.057,0.463,0.201,0.173,0,1,0\n0.666,0.196,0.588,0.51,0.5,0.683,0.515,0.132,0.644,0.424,0.407,0.645,0.601,1,0,0\n0.711,0.15,0.717,0.613,0.337,0.697,0.614,0.302,0.621,0.377,0.577,0.527,0.718,1,0,0\n0.808,0.253,0.556,0.423,0.359,0.61,0.544,0.358,0.621,0.42,0.48,0.542,0.558,1,0,0\n0.671,0.364,0.711,0.716,0.38,0.197,0.105,0.491,0.356,0.63,0.211,0.194,0.337,0,0,1\n0.708,0.136,0.61,0.314,0.413,0.834,0.703,0.113,0.514,0.471,0.333,0.586,0.718,1,0,0\n0.595,0.243,0.706,0.32,0.348,0.697,0.61,0.34,0.394,0.403,0.48,0.575,0.708,1,0,0\n0.366,0.172,0.444,0.613,0.413,0.352,0.369,0.396,0.379,0.067,0.472,0.619,0.048,0,1,0\n0.603,0.494,0.545,0.562,0.239,0.328,0.089,0.604,0.265,0.609,0.057,0.128,0.265,0,0,1\n0.766,0.196,0.487,0.351,0.413,0.655,0.675,0.358,0.527,0.65,0.52,0.67,0.7,1,0,0\n0.626,0.613,0.406,0.423,0.217,0.507,0.494,0.264,0.338,0.256,0.35,0.634,0.54,1,0,0\n0.655,0.48,0.727,0.665,0.293,0.197,0.038,0.698,0.044,0.262,0.333,0.289,0.173,0,0,1\n0.276,0.265,0.182,0.356,0.293,0.431,0.386,0.245,0.312,0.172,0.642,0.619,0.308,0,1,0\n0.208,0.194,0.278,0.459,0.174,0.524,0.274,0.453,0.319,0.067,0.374,0.429,0.098,0,1,0\n0.5,0.605,0.69,0.412,0.348,0.493,0.437,0.226,0.495,0.275,0.447,0.824,0.351,1,0,0\n0.276,0.128,0.61,0.613,0.152,0.545,0.411,0.566,0.199,0.138,0.366,0.703,0.076,0,1,0\n0.705,0.97,0.583,0.51,0.272,0.241,0.057,0.736,0.205,0.548,0.13,0.172,0.33,0,0,1\n0.716,0.196,0.561,0.278,0.207,0.559,0.511,0.302,0.442,0.369,0.545,0.597,0.743,1,0,0\n0,0.152,0.449,0.562,0.163,0.51,0.386,0.736,0.505,0.053,1,0.586,0.092,0,1,0\n0.608,0.04,0.535,0.33,0.435,0.534,0.203,0.792,0.003,0.161,0.439,0.242,0.337,0,1,0\n0.255,0.152,0.567,0.588,0.174,0.162,0.192,0.698,0.385,0.198,0.463,0.505,0.123,0,1,0\n0.276,0.215,0.513,0.407,0.12,0.214,0.245,0.736,0.388,0.096,0.488,0.366,0.144,0,1,0\n0.813,0.146,0.513,0.32,0.272,0.421,0.441,0.245,0.366,0.317,0.561,0.568,0.715,1,0,0\n0.192,0.383,0.834,0.485,0.359,0.266,0.357,0.887,0.202,0.215,0.61,0.451,0.235,0,1,0\n0.516,0.184,0.663,1,0.75,0.8,0.538,0.151,0.489,0.177,0.675,0.817,0.504,0,1,0\n0.65,0.211,0.668,0.485,0.283,0.534,0.479,0.283,0.394,0.191,0.52,0.934,0.404,1,0,0\n0.745,0.121,0.487,0.278,0.304,0.69,0.593,0.17,0.454,0.507,0.431,0.835,0.547,1,0,0\n0.266,0.704,0.545,0.588,0.109,0.386,0.297,0.547,0.297,0.113,0.252,0.476,0.215,0,1,0\n0.353,0.065,0.396,0.407,0.196,0.876,0.719,0.208,0.486,0.275,0.455,0.549,0.272,0,1,0\n0.276,0.117,0.503,0.67,0,0.421,0.264,0.547,0.306,0.039,0.48,0.711,0.248,0,1,0\n0.684,0.211,0.717,0.34,0.457,0.645,0.542,0.321,0.331,0.514,0.65,0.59,0.736,1,0,0\n0.624,0.763,0.802,0.742,0.457,0.345,0.131,0.264,0.221,0.616,0.154,0.238,0.251,0,0,1\n0.139,0.259,1,0.923,0.533,0.759,1,0.642,0.461,0.403,0.366,0.886,0.133,0,1,0\n0.374,0.453,0.684,0.845,0.293,0.317,0.051,0.943,0.23,0.531,0.154,0.168,0.429,0,0,1\n0.161,0.261,0.588,0.567,0.152,0.334,0.285,0.66,0.297,0.13,0.423,0.542,0.287,0,1,0\n0.532,0.617,0.513,0.613,0.163,0.231,0.264,0.906,0.382,0.3,0.293,0.271,0.169,0,1,0\n0.345,0.338,0.588,0.536,0.304,0.545,0.373,0.396,0.284,0.13,0.26,0.773,0.114,0,1,0\n0.532,0.196,0.364,0.093,0.239,0.6,0.618,0.075,0.789,0.505,0.52,0.601,0.622,1,0,0\n0.808,0.281,0.503,0.381,0.38,0.679,0.629,0.17,0.621,0.381,0.626,0.696,0.879,1,0,0\n0.621,0.204,0.674,0.284,0.25,0.645,0.549,0.396,0.328,0.3,0.358,0.714,0.654,1,0,0\n0.563,0.366,0.54,0.485,0.543,0.231,0.072,0.755,0.331,0.684,0.098,0.128,0.401,0,0,1\n0.311,0.089,0.209,0.32,0.88,0.3,0.198,0.019,0.659,0.134,0.65,0.659,0.314,0,1,0\n0.458,0.532,0.332,0.278,0.109,0.224,0.192,0.566,0.132,0.181,0.179,0.311,0.067,0,1,0\n0.797,0.176,0.492,0.278,0.609,0.697,0.597,0.208,0.533,0.373,0.496,0.894,0.358,1,0,0\n0.458,0.326,0.492,0.459,0.174,0.141,0.036,0.66,0.073,0.735,0.073,0.132,0.137,0,0,1\n0.389,0.099,0.476,0.356,0.163,0.352,0.051,0.887,0.265,0.356,0.22,0.088,0.265,0,0,1\n0.155,0.247,0.492,0.381,0.304,0.703,0.405,0.075,0.297,0.168,0.553,0.619,0.048,0,1,0\n0.884,0.223,0.583,0.206,0.283,0.524,0.46,0.321,0.495,0.339,0.439,0.846,0.722,1,0,0\n0.666,0.192,0.508,0.289,0.511,0.748,0.622,0.396,0.609,0.414,0.382,0.773,0.369,1,0,0\n0.5,0.409,0.717,0.536,0.283,0.193,0.034,0.755,0.107,0.283,0.236,0.381,0.23,0,0,1\n0.839,0.642,0.615,0.134,0.63,0.697,0.57,0.132,0.527,0.326,0.333,0.828,0.344,1,0,0\n0.471,0.52,0.503,0.459,0.196,0.172,0.068,0.509,0.177,0.766,0.195,0.176,0.29,0,0,1\n0.484,0.765,0.599,0.562,0.174,0.248,0.065,0.642,0.142,0.544,0.049,0.216,0.248,0,0,1\n0.671,0.182,0.535,0.438,0.391,0.648,0.601,0.17,0.486,0.48,0.496,0.59,0.882,1,0,0\n0.624,0.626,0.599,0.639,0.348,0.283,0.086,0.566,0.315,0.514,0.179,0.106,0.337,0,0,1\n0.682,0.832,0.529,0.485,0.239,0.352,0.097,0.642,0.192,0.266,0.35,0.286,0.194,0,0,1\n0.589,0.7,0.481,0.485,0.543,0.21,0.074,0.566,0.297,0.761,0.089,0.106,0.397,0,0,1\n0.547,0.229,0.743,0.768,0.5,0.421,0.198,0.245,0.363,0.497,0.106,0.022,0.105,0,0,1\n0.113,0.593,0.246,0.459,0.402,0.759,0.473,0.208,1,0.138,0.22,0.564,0.203,0,1,0\n0.579,0.506,0.492,0.407,0.304,0.283,0.103,0.906,0.461,0.788,0.065,0.088,0.283,0,0,1\n0.255,0.036,0.342,0.433,0.174,0.497,0.405,0.321,0.322,0.104,0.732,0.678,0,0,1,0\n0.153,0.121,0.717,0.485,0.261,0.607,0.544,0.302,0.656,0.117,0.39,0.729,0.287,0,1,0\n0.379,0.154,0.449,0.433,1,0.524,0.407,0.358,0.905,0.113,0.553,0.498,0.47,0,1,0\n0.537,0.15,0.396,0.253,0.304,0.49,0.485,0.283,0.303,0.206,0.569,0.52,0.529,1,0,0\n0.647,0.182,0.471,0.691,0.185,0.31,0.316,0.264,0.196,0.21,0.407,0.553,0.138,0,1,0\n0.834,0.202,0.583,0.237,0.457,0.79,0.643,0.396,0.492,0.467,0.463,0.579,0.836,1,0,0\n0.734,0.2,0.567,0.175,0.446,1,0.717,0.358,0.461,0.492,0.431,0.729,0.65,1,0,0\n0.463,0.381,0.599,0.588,0.457,0.172,0.215,0.208,0.268,0.812,0,0.073,0.144,0,0,1\n0.571,0.206,0.417,0.031,0.326,0.576,0.511,0.245,0.274,0.265,0.463,0.78,0.551,1,0,0\n0.166,0.225,0.299,0.278,0.293,0.217,0.259,0.396,0.233,0.215,0.61,0.319,0.107,0,1,0\n0.353,0.176,0.503,0.716,0.196,0.428,0.445,0.509,0.47,0.072,0.333,0.553,0.046,0,1,0\n0.563,0.879,0.513,0.588,0.25,0.262,0.061,0.906,0.36,0.565,0.098,0.077,0.319,0,0,1\n0.724,0.399,0.503,0.588,0.217,0.128,0.072,0.528,0.196,0.708,0.179,0.15,0.24,0,0,1\n0.313,0.109,0.31,0.433,0.239,0.476,0.359,0.491,0.527,0.121,0.309,0.641,0.024,0,1,0\n0.482,0.121,0.513,0.381,0.565,0.183,0.192,0.151,0.167,0.241,0.228,0.007,0.251,0,0,1\n0.332,0.132,0.332,0.278,0.163,0.541,0.456,0.302,0.429,0.138,0.61,0.538,0.107,0,1,0\n0.163,0.184,0.674,0.794,0.196,0.324,0.268,0.509,0.293,0.113,0.715,0.711,0.203,0,1,0\n0.476,0.439,0.668,0.691,0.337,0.462,0.055,0.755,0.126,0.311,0.333,0.322,0.223,0,0,1\n0.332,0.413,0.46,0.381,0.196,0.507,0.403,0.226,0.498,0.074,0.545,0.744,0.009,0,1,0\n0.842,0.192,0.572,0.258,0.62,0.628,0.574,0.283,0.593,0.372,0.455,0.971,0.561,1,0,0\n0.697,0.215,0.535,0.34,0.37,0.497,0.496,0.547,0.492,0.218,0.61,0.586,0.508,1,0,0\n0.705,0.221,0.535,0.309,0.337,0.562,0.536,0.264,0.404,0.215,0.512,1,0.54,1,0,0\n0.3,0.14,0.626,0.433,0.37,0.314,0.297,0.604,0.196,0.142,0.789,0.352,0.055,0,1,0\n0.487,0.445,0.556,0.485,0.37,0.11,0.186,0.208,0.132,0.352,0.211,0.055,0.18,0,0,1\n0.424,0.123,0.353,0.32,0.326,0.359,0.226,0.755,0.066,0.381,0.407,0.117,0.123,0,1,0\n0.882,0.563,0.492,0.278,0.348,0.783,0.597,0.264,0.562,0.309,0.455,0.795,0.561,1,0,0\n0.839,0.19,0.503,0.294,0.522,0.766,0.561,0.245,0.511,0.435,0.374,0.747,0.494,1,0,0\n0.797,0.279,0.668,0.361,0.554,0.559,0.458,0.34,0.265,0.322,0.472,0.846,0.725,1,0,0\n0.35,0.611,0.545,0.536,0.196,0.455,0.122,0.698,0.199,0.544,0.065,0.114,0.173,0,0,1\n0.824,0.35,0.599,0.485,0.228,0.241,0.076,0.585,0.262,0.718,0.114,0.161,0.272,0,0,1\n0.755,0.186,0.406,0.278,0.337,0.731,0.643,0.151,0.546,0.411,0.35,0.755,0.504,1,0,0\n0.111,0.328,0.567,0.485,0.283,0.662,0.517,0.358,0.448,0.168,0.26,0.777,0.248,0,1,0\n0.582,0.64,0.497,0.356,0.359,0.572,0.483,0.358,0.394,0.263,0.276,0.634,0.287,1,0,0\n0.2,0.275,0.759,0.923,0.239,0.397,0.401,0.849,0.426,0.147,0.398,0.429,0.134,0,1,0\n0.468,0.31,0.556,0.691,0.304,0.059,0.158,0.264,0.132,0.377,0.146,0.033,0.201,0,0,1\n0.597,0.194,0.417,0.33,0.261,0.49,0.39,0.264,0.297,0.228,0.439,0.549,0.718,1,0,0\n0.366,0.358,0.487,0.588,0.217,0.241,0.316,1,0.319,0.121,0.309,0.744,0.026,0,1,0\n0.245,0.069,0.503,0.536,0.337,0.828,0.38,0,0.391,0.165,0.415,0.681,0.434,0,1,0\n0.413,0.34,0.449,0.407,0.261,0.221,0.068,0.943,0.167,0.497,0.203,0.114,0.297,0,0,1\n0.645,0.211,0.561,0.51,0.326,0.593,0.557,0.245,0.457,0.326,0.455,0.806,0.458,1,0,0\n0.526,0.032,0.187,0.278,0.174,0.334,0.357,0.208,0.331,0.283,0.577,0.443,0.081,0,1,0\n0.408,0.109,0.396,0.485,0.359,0.172,0.051,0.755,0.312,0.539,0.081,0.103,0.258,0,0,1\n0.389,0.196,0.332,0.51,0.163,0.421,0.333,0.358,0.338,0.142,0.455,0.842,0.281,0,1,0\n0.737,0.164,0.674,0.485,0.489,0.679,0.646,0.509,0.413,0.454,0.528,0.476,0.608,1,0,0\n0.532,0.204,0.396,0.33,0.402,0.697,0.561,0.283,0.511,0.321,0.325,0.762,0.433,1,0,0\n0.882,0.223,0.545,0.072,0.348,0.8,0.696,0.302,0.804,0.531,0.585,0.634,0.905,1,0,0\n0.653,0.209,0.69,0.433,0.435,0.472,0.462,0.302,0.356,0.249,0.504,0.586,0.583,1,0,0\n0.816,0.664,0.738,0.716,0.283,0.369,0.089,0.811,0.297,0.676,0.106,0.121,0.201,0,0,1\n0.637,0.585,0.663,0.639,0.446,0.248,0.122,0.566,0.331,0.802,0.301,0.106,0.297,0,0,1\n0.445,0.211,0.449,0.423,0.174,0.421,0.462,0.245,0.429,0.224,0.553,0.685,0.311,0,1,0\n0.368,0.156,0.497,0.562,0.174,0.607,0.593,0.491,0.429,0.227,0.171,0.575,0.053,0,1,0\n0.532,0.18,0.636,0.381,0.304,0.507,0.441,0.302,0.325,0.253,0.52,0.454,0.59,1,0,0\n0.561,0.559,0.422,0.536,0.348,0.179,0.044,0.566,0.281,0.232,0.098,0.15,0.394,0,0,1\n0.213,0.425,0.465,0.381,0.457,0.255,0.207,0.566,0.17,0.117,0.39,0.458,0.158,0,1,0\n0.353,0.085,0.299,0.464,0.087,0.39,0.35,0.264,0.199,0.29,0.52,0.81,0.165,0,1,0\n0.747,0.229,0.77,0.454,0.402,0.679,0.555,0.453,0.426,0.275,0.626,0.78,0.454,1,0,0\n0.274,0.281,0.433,0.536,0.163,0.559,0.487,0.453,0.297,0.126,0.309,0.736,0.071,0,1,0\n0.713,0.184,0.476,0.299,0.522,0.559,0.54,0.151,0.382,0.39,0.358,0.707,0.558,1,0,0\n0.861,0.233,0.727,0.485,0.543,0.628,0.591,0.377,0.492,0.42,0.48,0.505,0.715,1,0,0\n0.353,0.077,0.428,0.433,0.185,0.869,0.582,0.113,0.461,0.27,0.602,0.586,0.101,0,1,0\n0.647,0.563,0.444,0.459,0.196,0.221,0.03,0.849,0.148,0.377,0.268,0.201,0.215,0,0,1\n0.392,0.334,0.433,0.536,0.196,0.541,0.407,0.245,0.256,0.061,0.341,0.553,0.034,0,1,0\n0.437,0.156,0.481,0.521,0.109,0.138,0.236,0.849,0.382,0.151,0.39,0.289,0.155,0,1,0\n0.645,0.184,0.684,0.613,0.207,0.559,0.16,0.736,0.593,0.893,0.073,0.187,0.244,0,0,1\n0.561,0.32,0.701,0.412,0.337,0.628,0.612,0.321,0.757,0.375,0.447,0.696,0.647,1,0,0\n0.979,0.196,0.551,0.041,0.228,0.731,0.707,0.566,0.757,0.352,0.626,0.535,0.622,1,0,0\n0.718,0.156,0.717,0.459,0.674,0.679,0.506,0.698,0.297,0.352,0.626,0.634,0.683,1,0,0\n0.737,0.18,0.663,0.34,0.261,0.507,0.559,0.17,0.593,0.369,0.618,0.769,0.704,1,0,0\n0.208,0.144,0.337,0.526,0.174,0.345,0.266,0.321,0.353,0.057,0.382,0.755,0.155,0,1,0\n0.532,0.259,0.995,0.742,0.587,0.569,0.494,0.642,0.476,0.196,0.528,0.707,0.394,1,0,0\n0.413,0.119,0.289,0.407,0.196,0.162,0.215,0.302,0.297,0.1,0.455,0.549,0.203,0,1,0\n0.711,0.715,0.481,0.613,0.196,0.103,0.027,0.736,0.233,0.456,0.244,0.176,0.173,0,0,1\n0.7,0.498,0.631,0.485,0.402,0.293,0.046,0.698,0.123,0.392,0.39,0.201,0.287,0,0,1\n0.205,0.273,0.738,0.562,0.696,0.214,0.137,0.019,0.363,0.104,0.382,0.363,0.248,0,1,0\n0.255,0.532,0.342,0.433,0.185,0.352,0.274,0.453,0.461,0,0.366,0.652,0.204,0,1,0\n0.539,0.625,0.535,0.562,0.467,0.148,0.222,0.396,0.23,0.693,0.073,0.022,0.194,0,0,1\n0.547,0.053,0.182,0.227,0.087,0.69,0.599,0.245,0.59,0.343,0.52,0.7,0.16,0,1,0\n0.695,0.101,0.299,0.381,0.261,0.386,0.306,0.358,0.101,0.215,0.61,0.436,0.251,0,1,0\n0.479,0.5,0.652,0.588,0.391,0.231,0.055,0.887,0.174,0.367,0.317,0.308,0.208,0,0,1\n0.366,0.729,0.733,0.82,0.348,0.421,0.378,0.566,0.41,0.068,0.358,0.678,0.062,0,1,0";
        public var list:Array;
        public var lineShape:Shape;
        
//エントリ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
        public function FlashTest() {
            // write as3 code here..
            
            this.graphics.beginFill(0xdddddd);
            this.graphics.drawRect(0,0,465,465);
            this.graphics.endFill();
            
            stage.scaleMode = "noScale";
            
            lineShape = new Shape();
            addChild(lineShape);//シナプスライン
            var wineTxtLines:Array;
            var wineTxtArray:Array;
            var line:Array;
            var i:int;
            wineTxtLines = wineTxt.split("\n");
            wineTxtArray = [];
            list = new Array();
            for (i = 0; i < wineTxtLines.length; i++){
                line = wineTxtLines[i].split(",");
                wineTxtArray.push(line);
                var line2:Array=new Array();
                for(var j:int=0;j<line.length;j++){
                    line2.push(parseFloat(line[j]));
                }
                list.push(line2);

                
                
            }
            
            /*
            list = new Array();
            for(i=0;i<100;i++){
                list.push(createPtn());
            }            
            */
            
            var neuron:Neuron;
            
            
            inputLayer = new Layer();
            for (i = 0; i < inputNeuronNum; i++){
                neuron = new Neuron(hiddenNeuronNum);
                inputLayer.neurons.push(neuron);
                
                neuron.x = 465 * 3 / 4 + (-(inputNeuronNum + 1) / 2 + i) * 16; //graphic
                neuron.y = 40;
                addChild(neuron);
            }
            
            neuron = new Neuron(hiddenNeuronNum); 
            neuron.biased = true; //biased One
            neuron.x = 465 * 3 / 4 + (-(inputNeuronNum + 1) / 2 + i) * 16;
            neuron.y = 40;
            addChild(neuron);
            inputLayer.neurons.push(neuron);
            
            
            hiddenLayer = new Layer();
            for (i = 0; i < hiddenNeuronNum; i++){
                neuron = new Neuron(outputNeuronNum);
                hiddenLayer.neurons.push(neuron);
                
                neuron.x = 465 * 3 / 4 + (-(hiddenNeuronNum + 1) / 2 + i) * 16;
                neuron.y = 95;
                addChild(neuron);
            }
            
            neuron = new Neuron(outputNeuronNum);
            neuron.biased = true; //biased One
            neuron.x = 465 * 3 / 4 + (-(hiddenNeuronNum + 1) / 2 + i) * 16;
            neuron.y = 95;
            addChild(neuron);
            hiddenLayer.neurons.push(neuron);
            
            
            outputLayer = new Layer();
            for (i = 0; i < outputNeuronNum; i++){
                neuron = new Neuron(0);
                outputLayer.neurons.push(neuron);
                
                neuron.x = 465 * 3 / 4 + (-outputNeuronNum / 2 + i) * 16;
                neuron.y = 150;
                addChild(neuron);
            }
            
            beta = 0.7 * Math.pow(hiddenNeuronNum, (1 / inputNeuronNum) );
            
            weightInit();
            
            
            
            
            
            proceedNumLabel = new Label(this, 10, 10, "Proceed #0");
            errorChart = new LineChart(this, 10, proceedNumLabel.y + proceedNumLabel.height + 5);
            errorChart.data = [];
            
            
            debugLabel = new Label(this, 10, errorChart.y + errorChart.height + 5, "");
            
            testButton = new PushButton(this, 10, debugLabel.y + debugLabel.height + 20, "Test", onTest);
            //testTextArea = new TextArea(this, 10, testButton.y + testButton.height + 5, "");
            testTextArea = new TextField();
            addChild(testTextArea);
            with(testTextArea){
                border=true;
                text = "test";
                y = 200;
            }

            testTextArea.width = 465 - 20;
            testTextArea.height = 465 - 10 - testTextArea.y;
            
            resetButton = new PushButton(this, testButton.x + testButton.width + 10, testButton.y, "Reset", onReset);
            
            addEventListener(Event.ENTER_FRAME, onLoop);
            //testTextArea.text += wineTxt+"\n";
        }
        
        public function createPtn(p:int=13,a:int=3):Array{
            var res:Array = new Array();
            for(var i:int=0;i<p;i++){
                res.push(Math.random());
            }
            for(var j:int=0;j<a;j++){
                res.push(Math.round(Math.random()));
            }


            return res;
        }

//初期化        
        public function weightInit():void{
            // Nguyen-Widrow Initialization - for all Input to Hidden w
            var normHidden:Number;
            var j:int;
            var i:int;
            
            normHidden = 0;
            for (i = 0; i < hiddenNeuronNum; i++){
                for (j = 0; j < inputNeuronNum + 1; j++){
                    normHidden += inputLayer.neurons[j].w[i] * inputLayer.neurons[j].w[i];
                }
                
                normHidden = Math.sqrt(normHidden);
                
                for (j = 0; j < inputNeuronNum + 1; j++){
                    inputLayer.neurons[j].w[i] *= beta / normHidden;
                }
            }
        }
        
        //リセット
        public function onReset(e:Event):void{
            if (hasEventListener(Event.ENTER_FRAME)){
                removeEventListener(Event.ENTER_FRAME, onLoop);
            }
            
            var i:int;
            for (i = 0; i < inputNeuronNum + 1; i++){
                inputLayer.neurons[i].resetW(hiddenNeuronNum);
            }
            for (i = 0; i < hiddenNeuronNum + 1; i++){
                hiddenLayer.neurons[i].resetW(outputNeuronNum);
            }
            
            weightInit();
            iter = 0;
            errorChart.data = [];
            addEventListener(Event.ENTER_FRAME, onLoop);
        }
        
        
        
        public function res(a:int):void{
            var i:int,j:int;
            for (i = 0; i < inputNeuronNum; i++){
                    var n:Number;
                    if(i<list.length)n =list[a][i];
                    else n = 1;//Math.random();
                    inputLayer.neurons[i].output = sigmoid(n);//入力
            }
            inputLayer.neurons[inputNeuronNum].output = 1; // biased
                
            for (i = 0; i < hiddenNeuronNum; i++){
                    hiddenLayer.neurons[i].input = 0;//値リセット
                    
                    for (j = 0; j < inputNeuronNum + 1; j++){
                        hiddenLayer.neurons[i].input += inputLayer.neurons[j].output * inputLayer.neurons[j].w[i];
                    }
                    
                    hiddenLayer.neurons[i].output = Math.round(sigmoid(hiddenLayer.neurons[i].input));
            }
            hiddenLayer.neurons[hiddenNeuronNum].output = 1; // biased
                
            for (i = 0; i < outputNeuronNum; i++){
                    outputLayer.neurons[i].input = 0;
                    for (j = 0; j < hiddenNeuronNum + 1; j++){
                        outputLayer.neurons[i].input += hiddenLayer.neurons[j].output * hiddenLayer.neurons[j].w[i];
                    }
                    
                    outputLayer.neurons[i].output = Math.round(sigmoid(outputLayer.neurons[i].input));
            }
        }

        
        //テスト
        public function onTest(e:Event=null):void{
            var a:int = Math.floor(list.length * Math.random());
            
            res(a);
            
                
            //テキスト出力
            var str:String = "Sample #" + String(a) + "\n";
            str += "出力値 : " + String(Math.round(outputLayer.neurons[0].output)) + ", "; 
            str += String(Math.round(outputLayer.neurons[1].output)) + ", ";
            str += String(Math.round(outputLayer.neurons[2].output)) + "\n正解値 : " + list[a][13] + ", ";
            str += list[a][14] + ", " + list[a][15] + "\n"; 


            testTextArea.appendText(str+"\n");
            testTextArea.scrollV = testTextArea.maxScrollV;
            draw();
        }
        
        //学習
        public function learn():Number{
            var sumError:Number = 0;
            var i:int;
            var j:int;
            sumError = 0;//エラーカウンタ
            for (var s:int = 0; s < list.length; s++){
                //入力層
                for (i = 0; i < inputNeuronNum; i++){
                            
                    var n:Number;
                    if(i<list.length)n = list[s][i];
                    else n = 1;//Math.random();
                    inputLayer.neurons[i].output = sigmoid(n);//入力
                }
                inputLayer.neurons[inputNeuronNum].output = 1; // biased
                //中間層
                for (i = 0; i < hiddenNeuronNum; i++){
                    hiddenLayer.neurons[i].input = 0;
                    for (j = 0; j < inputNeuronNum + 1; j++){
                        //input += 入力値 * 重み
                        hiddenLayer.neurons[i].input += inputLayer.neurons[j].output * inputLayer.neurons[j].w[i];
                    }
                    //output
                    hiddenLayer.neurons[i].output = sigmoid(hiddenLayer.neurons[i].input);//出力値の決定
                }
                hiddenLayer.neurons[hiddenNeuronNum].output = 1; // biased
                //出力層
                for (i = 0; i < outputNeuronNum; i++){
                    outputLayer.neurons[i].input = 0;
                            
                    for (j = 0; j < hiddenNeuronNum + 1; j++){
                        outputLayer.neurons[i].input += hiddenLayer.neurons[j].output * hiddenLayer.neurons[j].w[i];
                    }
                    outputLayer.neurons[i].output = sigmoid(outputLayer.neurons[i].input); 
                }
                
                //評価
                for(i=0;i<outputNeuronNum;i++){
                    //出力値と正解の差
                    var err:Number = list[s][inputNeuronNum+i] - outputLayer.neurons[i].output;
                    var out:Number = outputLayer.neurons[i].output;
                    outputLayer.neurons[i].error = err;
                    outputLayer.neurons[i].nodeDelta = err * out * (1-out);
                }

                        
                //バックプロパゲーション
                for (i = 0; i < hiddenNeuronNum + 1; i++){ //中間層
                    hiddenLayer.neurons[i].nodeDelta = 0;//リセット
                            
                    for (j = 0; j < outputNeuronNum; j++){//出力層
                        //deltaW更新
                        hiddenLayer.neurons[i].deltaW[j] = 
                                learnRate * hiddenLayer.neurons[i].output * outputLayer.neurons[j].nodeDelta + 
                               _alpha * hiddenLayer.neurons[i].deltaW[j];
                        //w更新
                        hiddenLayer.neurons[i].w[j] += hiddenLayer.neurons[i].deltaW[j]; //重み付け更新
                        //nodeDelta
                        hiddenLayer.neurons[i].nodeDelta += 
                                outputLayer.neurons[j].nodeDelta * hiddenLayer.neurons[i].w[j]; //get hidden neuron's nodeDelta
                    }
                    //nodeDelta
                    hiddenLayer.neurons[i].nodeDelta *= 
                            hiddenLayer.neurons[i].output * (1 - hiddenLayer.neurons[i].output);
                            
                }
                
                for (i = 0; i < inputNeuronNum + 1; i++){//入力層
                    for (j = 0; j < hiddenNeuronNum; j++){//中間層
                        //deltaW
                        inputLayer.neurons[i].deltaW[j] = 
                                learnRate * inputLayer.neurons[i].output * hiddenLayer.neurons[j].nodeDelta + 
                               _alpha * inputLayer.neurons[i].deltaW[j]; 
                        //w
                        inputLayer.neurons[i].w[j] += inputLayer.neurons[i].deltaW[j]; //weight update
                    }
                }
                
                
                
                for(i=0;i<outputNeuronNum;i++){
                    var err2:Number = outputLayer.neurons[i].error;
                    sumError += err2 * err2;
                }
                
            }
            
            

            
            return sumError;
        }
        
        public function onLoop(e:Event=null):void{
            var err:Number
            err = learn();
            if(err<10)removeEventListener(Event.ENTER_FRAME, onLoop);
            iter++;
            proceedNumLabel.text = "Proceed #" + String(iter);
            errorChart.data.push(err);//チャートにデータ追加
            errorChart.draw();//チャート画面更新
            debugLabel.text = "Sum of Error : " + String(err);
            draw();
                

        };
                
        //描画
        private function draw():void{
            var lineThick:Number;
            var lineColor:uint;
            const c1:uint = 0x2a80b9;
            const c2:uint = 0xa31605;
            var i:int;
            var j:int;
            lineShape.graphics.clear();
            
            
            for(i=0;i<inputNeuronNum;i++){
                if(0.65<inputLayer.neurons[i].output)inputLayer.neurons[i].draw(0xff0000);
                else inputLayer.neurons[i].draw(0xffffff);
            }
            for(i=0;i<hiddenNeuronNum+1;i++){
                if(1<hiddenLayer.neurons[i].input)hiddenLayer.neurons[i].draw(0xff0000);
                else hiddenLayer.neurons[i].draw(0xffffff);
            }
            for(i=0;i<outputNeuronNum;i++){
                if(1<outputLayer.neurons[i].input)outputLayer.neurons[i].draw(0xff0000);
                else outputLayer.neurons[i].draw(0xffffff);
            }
            

            //入力層-中間層
            for (i = 0; i < inputNeuronNum+1; i++){//入力層
                for (j = 0; j < hiddenNeuronNum; j++){//中間層
                    //wが0以上なら赤  マイナスなら青
                    lineColor = inputLayer.neurons[i].w[j] >= 0 ? c1 : c2;//色
                    //wの値が０から離れているほど太く描画する
                    lineThick = Math.abs(inputLayer.neurons[i].w[j]);
                    lineThick = lineThick/10 > 3 ? 3 : ( lineThick < 0.1 ? 0.1 : lineThick/10 );//太さ
                    
                    lineShape.graphics.lineStyle(lineThick, lineColor,0.8);
                    lineShape.graphics.moveTo(inputLayer.neurons[i].x, inputLayer.neurons[i].y);
                    lineShape.graphics.lineTo(hiddenLayer.neurons[j].x, hiddenLayer.neurons[j].y);
                }
                
                //if(0.0==inputLayer.neurons[i].w)inputLayer.neurons[i].draw(0xff0000);
                //else inputLayer.neurons[i].draw(0xffaaff);
            }
            //中間層-出力層
            for (i = 0; i < hiddenNeuronNum + 1; i++){//中間層
                for (j = 0; j < outputNeuronNum; j++){//出力層
                    
                    lineColor = hiddenLayer.neurons[i].w[j] >= 0 ? c1 : c2;
                    lineThick = Math.abs(hiddenLayer.neurons[i].w[j]);
                    lineThick = lineThick/10 > 3 ? 3 : ( lineThick < 0.1 ? 0.1 : lineThick/10 );
                    
                    lineShape.graphics.lineStyle(lineThick, lineColor);
                    lineShape.graphics.moveTo(hiddenLayer.neurons[i].x, hiddenLayer.neurons[i].y);
                    lineShape.graphics.lineTo(outputLayer.neurons[j].x, outputLayer.neurons[j].y);
                }
            }
        }

//^^^ シグモイド関数 ^^^^        
        public function sigmoid(n:Number):Number{
            return 1 / (1 + 1 / Math.exp(n));
        }
    }
    
}



//^^^^^ ニューロンクラス ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
    import flash.display.Shape;
    class Neuron extends Shape{
        public var w:Object;
        public var deltaW:Object;
        public var updateValue:Object;
        public var prevGradient:Object;
        public var input:Number;
        public var output:Number;
        public var error:Number;
        public var nodeDelta:Number;
        public var gradient:Object;
        public var gradientChanged:Object;
        public var biased:Boolean = false;
        
        //インスタンス
        public function Neuron(n:int){
            
            draw();
            
            this.w = new Object();
            this.deltaW = new Object();
            this.updateValue = new Object();
            this.prevGradient = new Object();
            this.gradient = new Object();
            this.gradientChanged = new Object();
            
            if(n > 0){
                for(var i:int = 0; i < n; i++){
                    this.w[i] = Math.random() * 2 - 1;
                    this.deltaW[i] = 0;
                    this.updateValue[i] = 0.01;
                    
                    this.gradient[i] = 0;
                    this.prevGradient[i] = 0;
                    this.gradientChanged[i] = 0;
                }
            }
        }
        
        //リセット
        public function resetW(n:int):void{
            for(var i:int=0; i<n; i++){
                this.w[i] = Math.random() * 2 - 1;
                this.deltaW[i] = 0;
                this.updateValue[i] = 0.01;
                
                this.gradient[i] = 0;
                this.prevGradient[i] = 0;
                this.gradientChanged[i] = 0;
                
                this.error = 0;
                this.nodeDelta = 0;
            }
        }
        
        public function draw(col:uint=0xffffff):void{
            //描画
            this.graphics.clear();
            this.graphics.lineStyle(2, 0);
            this.graphics.beginFill(col);
            this.graphics.drawCircle(0, 0, 6);
            this.graphics.endFill();
        }

        
    }

//^^^^ レイヤークラス ^^^^^^^^^^^^^^^^^^^^^^^^^^^^
    //階層
    class Layer{
        public var neurons:Array;//ニューロンのリスト
        public function Layer(){
            this.neurons = [];
        }
    }

