/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/IVD5
 */

// forked from greentec's Simple Random Texture - Move
// forked from greentec's Simple Random Texture
package 
{
    import com.bit101.components.CheckBox;
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import com.bit101.components.VSlider;
    import com.bit101.components.Window;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.getTimer;
    
    /**
     * ...
     * @author ypc
     */
    [SWF(width = 465, height = 465, backgroundColor = "#292929")]
    public class Main extends Sprite 
    {
        public var perlinBitmapData:BitmapData;
        public var randomSeed:int = Math.random() * int.MAX_VALUE;
        public var numOctaves:int = 6;
        public var offsets:Array;
        public var speeds:Array;
        public var _scale:int;
        public var _threshold:int;
        public var _sineOffset:int;
        
        public var screen:Bitmap;
        public var screenBitmapData:BitmapData;
        
        
        public var colT:ColorTransform;
        public var startTime:uint;
        
        public var _width:int = 465;
        public var _height:int = 465;
        public var checkbox:CheckBox;
        public var resetButton:PushButton;
        
        public var window:Window;
        public var scaleLabel:Label;
        public var scaleSlider:HSlider;
        public var sineLabel:Label;
        public var sineSlider:HSlider;
        public var thresholdLabel:Label;
        public var thresholdSlider:HSlider;
        
        public var colTPropertyShortNameArray:Array = ["RM", "GM", "BM", "RO", "GO", "BO"];
        public var colTPropertyArray:Array = ["redMultiplier", "greenMultiplier", "blueMultiplier", "redOffset", "greenOffset", "blueOffset"];
        public var colTPropertyLabelArray:Array;
        public var colTPropertySliderArray:Array;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = "noScale";
            stage.frameRate = 30;
            
            Style.BACKGROUND = 0x444444;
            Style.BUTTON_FACE = 0x666666;
            Style.INPUT_TEXT = 0xBBBBBB;
            Style.LABEL_TEXT = 0xCCCCCC;
            Style.PANEL = 0x666666;
            Style.PROGRESS_BAR = 0x666666;
            
            
            perlinBitmapData = new BitmapData(_width / 2, _height / 2, false);
            //screenBitmapData = new BitmapData(465, 465, true, 0x00ffffff);
            screenBitmapData = new BitmapData(_width, _height, false);
            
            screen = new Bitmap(screenBitmapData);
            addChild(screen);
            
            window = new Window(this, 305, 10, "control");
            window.hasMinimizeButton = true;
            window.width = 465 - window.x - 10;
            window.height = 330;
            window.alpha = 0.7;
            
            
            scaleLabel = new Label(window, 10, 20, "");
            
            scaleSlider = new HSlider(window, scaleLabel.x, scaleLabel.y + scaleLabel.height + 5, onScaleChange);
            scaleSlider.minimum = 2;
            scaleSlider.maximum = 11;
            
            
            sineLabel = new Label(window, scaleSlider.x, scaleSlider.y + scaleSlider.height + 5, "");
            
            sineSlider = new HSlider(window, sineLabel.x, sineLabel.y + sineLabel.height + 5, onSineOffsetChange);
            sineSlider.minimum = 10;
            sineSlider.maximum = 89;
            
            
            thresholdLabel = new Label(window, sineSlider.x, sineSlider.y + sineSlider.height + 5, "");
            
            thresholdSlider = new HSlider(window, thresholdLabel.x, thresholdLabel.y + thresholdLabel.height + 5, onThresholdChange);
            thresholdSlider.minimum = 50;
            thresholdSlider.maximum = 149;
            
            
            //label = new Label(window, 10, 10);
            
            checkbox = new CheckBox(window, thresholdSlider.x, thresholdSlider.y + thresholdSlider.height + 5, "threshold");
            
            var i:int;
            var label:Label;
            var slider:VSlider;
            
            colTPropertyLabelArray = [];
            colTPropertySliderArray = [];
            
            for (i = 0; i < 6; i += 1)
            {
                label = new Label(window, 10 + 23 * i, checkbox.y + checkbox.height + 10, "");
                slider = new VSlider(window, label.x, label.y + label.height + 15, onChangeColTSlider);
                slider.name = colTPropertyShortNameArray[i] + "#" + String(i);
                
                if (i < 3)
                {
                    slider.minimum = 0;
                    slider.maximum = 1;
                    slider.tick = 0.01;
                }
                else
                {
                    slider.minimum = 0;
                    slider.maximum = 255;
                    slider.tick = 1;
                }
                
                colTPropertyLabelArray.push(label);
                colTPropertySliderArray.push(slider);
                
            }
            
            
            resetButton = new PushButton(window, checkbox.x, slider.y + slider.height + 10, "Reset", onReset);
            resetButton.width = 465 - window.x - 30;
            
            onReset();
            
           
            addEventListener(Event.ENTER_FRAME, onLoop);
            
        }
        
        private function onChangeColTSlider(e:Event):void
        {
            var str:Array = e.target.name.split("#");
            var index:int = parseInt(str[1]);
            
            colT[colTPropertyArray[index]] = e.target.value;
            
            if (index < 3)
            {
                colTPropertyLabelArray[index].text = str[0] + "\n" + String(int(e.target.value * 100) / 100);
            }
            else
            {
                colTPropertyLabelArray[index].text = str[0] + "\n" + String(e.target.value);
            }
        }
        
        private function onThresholdChange(e:Event):void
        {
            _threshold = e.target.value;
            thresholdLabel.text = "threshold:\t" + String(_threshold);
        }
        
        private function onSineOffsetChange(e:Event):void
        {
            _sineOffset = e.target.value;
            sineLabel.text = "sine Offset:\t" + String(_sineOffset);
        }
        
        private function onScaleChange(e:Event):void
        {
            _scale = e.target.value;
            scaleLabel.text = "scale:\t" + String(_scale);
        }

        private function onReset(e:Event = null):void
        {
            var i:int;
            
            offsets = [];
            speeds = [];
            
            for (i = 0; i < numOctaves; i += 1)
            {
                offsets.push(new Point());
                speeds.push(new Point(Math.random() * 8 - 4, Math.random() * 8 - 4));
            }
            
            colT = new ColorTransform(Math.random(), 
                                      Math.random(), 
                                      Math.random(), 
                                      1, 
                                      int(Math.random() * 256),
                                      int(Math.random() * 256),
                                      int(Math.random() * 256),
                                      0);
                                      
            
            
            //colT = new ColorTransform();
            _scale = Math.random() * 10 + 2;
            scaleSlider.value = _scale;
            _sineOffset = Math.random() * 10 + 80;
            sineSlider.value = _sineOffset;
            _threshold = Math.random() * 100 + 50;
            thresholdSlider.value = _threshold;
            
            scaleLabel.text = "scale:\t" + String(_scale);
            sineLabel.text = "sine Offset:\t" + String(_sineOffset);
            thresholdLabel.text = "threshold:\t" + String(_threshold);
            //label.text = "scale:\t" + String(_scale) + "\nthreshold:\t" + String(_threshold);
            
            var label:Label;
            var slider:VSlider;
            
            for (i = 0; i < 6; i += 1)
            {
                label = colTPropertyLabelArray[i];
                slider = colTPropertySliderArray[i];
                
                if (i < 3)
                {
                    label.text = colTPropertyShortNameArray[i] + "\n" + String(int(colT[colTPropertyArray[i]] * 100) / 100);
                }
                else
                {
                    label.text = colTPropertyShortNameArray[i] + "\n" + String(colT[colTPropertyArray[i]]);
                }
                slider.value = colT[colTPropertyArray[i]];
            }
            
        }
        
        private function onLoop(e:Event):void
        {
            //startTime = getTimer();
            
            var i:int;
            for (i = 0; i < numOctaves; i += 1)
            {
                offsets[i].x += speeds[i].x;
                offsets[i].y += speeds[i].y;
            }
            
            perlinBitmapData.perlinNoise(465/_scale, 465/_scale, numOctaves, randomSeed, false, false, 7, false, offsets);
            
            var j:int;
            var x:Number;
            var y:Number;
            var num:Number;
            var color:uint;
            var r:uint;
            var g:uint;
            var b:uint;
            
            screenBitmapData.lock();
            //screenBitmapData.fillRect(screenBitmapData.rect, 0xff000000);
            
            //for (i = 0; i < _width; i += 1)
            for (i = 0; i < 233; i += 1)
            {
                //for (j = 0; j < _height; j += 1)
                for (j = 0; j < 233; j += 1)
                {
                    //x = i / _width * 1.0;
                    x = i / 233 * 1.0;
                    color = perlinBitmapData.getPixel(i, j);
                    y = (color & 0xff) / 255;
                    
                    num = (1 + Math.sin((x + y / 2) * _sineOffset)) / 2;
                    num = num < 0 ? 0 : num;
                    
                    //color = num * 255;
                    b = num * 255;
                    
                    y = ((color >> 8) & 0xff) / 255;
                    
                    num = (1 + Math.sin((x + y / 2) * _sineOffset)) / 2;
                    num = num < 0 ? 0 : num;
                    
                    g = num * 255;
                    
                    
                    y = ((color >> 16) & 0xff) / 255;
                    
                    num = (1 + Math.sin((x + y / 2) * _sineOffset)) / 2;
                    num = num < 0 ? 0 : num;
                    
                    r = num * 255;
                    
                    if (checkbox.selected == true)
                    {
                        if (r + g + b < _threshold * 3)
                        {
                            continue;
                        }
                    }
                    
                    //screenBitmapData.setPixel(i, j, 0xff << 24 | color << 16 | color << 8 | color);
                    //screenBitmapData.setPixel(i, j, r << 16 | g << 8 | b);
                    screenBitmapData.fillRect(new Rectangle(i * 2, j * 2, 2, 2), r << 16 | g << 8 | b);
                    
                }
            }
            
            screenBitmapData.colorTransform(screenBitmapData.rect, colT);
            screenBitmapData.unlock();
            
            
            //perlinBitmapData = new BitmapData(465, 465, false);
            
            
            //trace(getTimer() - startTime);
            
        }
       
   }
}