/**
 * Copyright devon_o ( http://wonderfl.net/user/devon_o )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/IRon
 */

package 
{
    
import com.adobe.utils.AGALMiniAssembler;
import com.bit101.components.HUISlider;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageScaleMode;
import flash.display3D.Context3D;
import flash.display3D.Context3DProfile;
import flash.display3D.Context3DProgramType;
import flash.display3D.Context3DRenderMode;
import flash.display3D.Context3DTextureFormat;
import flash.display3D.Context3DVertexBufferFormat;
import flash.display3D.IndexBuffer3D;
import flash.display3D.Program3D;
import flash.display3D.VertexBuffer3D;
import flash.display3D.textures.Texture;
import flash.events.Event;
import flash.geom.Matrix3D;
import flash.net.URLRequest;
import flash.system.LoaderContext;

/**
 * Kaleidoscope in AGAL
 * ported from https://www.shadertoy.com/view/4sfGzs
 * @author Devon O.
 */

[SWF(width='465', height='465', backgroundColor='#000000', frameRate='60')]
public class Main extends Sprite 
{
 
    private static var VERTEX_SHADER:String =
    <![CDATA[
    
    m44 op, va0, vc0
    mov v0, va1 
    
    ]]>;
    
    
    private static var FRAGMENT_SHADER:String =
    <![CDATA[
    
    mov ft2.xy, v0.xy
    mov ft2.w, fc2.x
    sub ft2.z, fc2.y, ft2.w
    mul ft2.z, ft2.z, ft2.x
    add ft2.x, ft2.z, fc2.x

    sub ft2.z, fc2.y, ft2.w
    mul ft2.z, ft2.z, ft2.y
    add ft2.y, ft2.z, fc2.x

    //resolution tweak
    div ft2.x, ft2.x, fc3.w

    // Atan2
    add ft2.x, ft2.x, fc1.x
     
    div ft3.x, ft2.y, ft2.x
    neg ft3.y, ft3.x 
     
    mul ft4.y, fc1.y, ft3.x 
    add ft4.z, fc0.x, ft3.x
    div ft5.x, ft4.y, ft4.z  
     
    mul ft4.y, fc1.y, ft3.y
    add ft4.z, fc0.x, ft3.y
    div ft5.y, ft4.y, ft4.z  
     
    slt ft4.x, ft2.x, fc0.y
    slt ft4.y, ft2.y, fc0.y
    sub ft4.z, fc0.x, ft4.x
    sub ft4.w, fc0.x, ft4.y
     
    mul ft3.x, ft4.z, ft4.w
    mul ft3.y, ft4.x, ft4.w
    mul ft3.z, ft4.x, ft4.y
    mul ft3.w, ft4.z, ft4.y
     
    sub ft4.x, ft5.x, fc0.z 
    neg ft4.y, ft5.y      
    mov ft4.z, ft5.x 
    sub ft4.w, fc0.z, ft5.y 
     
    mul ft4, ft4, ft3
     
    add ft4.xy, ft4.xz, ft4.yw 
    add ft4.x, ft4.x, ft4.y
    
    // eo Atan2

    mul ft0.x, ft2.x, ft2.x
    mul ft0.y, ft2.y, ft2.y
    add ft0.x, ft0.x, ft0.y
    sqt ft0.x, ft0.x
    
    mov ft5.x, fc2.z
    div ft5.x, ft5.x, fc1.w
    add ft5.x, ft4.x, ft5.x
    div ft5.y, ft5.x, fc2.z
    frc ft5.y, ft5.y
    mul ft5.y, ft5.y, fc2.z
    
    mov ft5.x, fc2.z
    div ft5.x, ft5.x fc3.z
    sub ft5.x, ft5.y, ft5.x
    abs ft5.x, ft5.x
    add ft5.y, ft0.x, fc2.y
    div ft4.x, ft5.x, ft5.y
    
    mul ft0.x, ft0.x, fc3.x
    cos ft1.x, ft4.x
    mul ft1.x, ft1.x, ft0.x
    sin ft1.y, ft4.x
    mul ft1.y, ft1.y, ft0.x
    
    mov ft4.x, fc2.w
    
    cos ft2.x, ft4.x
    sin ft2.y, ft4.x
    
    mul ft3.x, ft2.y, fc3.y
    mul ft3.y, ft1.y, ft2.y
    mul ft3.z, ft1.x, ft2.x
    sub ft6.x, ft3.z, ft3.y
    sub ft6.x, ft6.x, ft3.x
    
    mul ft3.x, ft2.x, fc3.y
    mul ft3.y, ft1.y, ft2.x
    mul ft3.z, ft1.x, ft2.y
    add ft6.y, ft3.z, ft3.y
    add ft6.y, ft6.y, ft3.x
    
    mul ft6.xy, ft6.xy, fc3.z
    
    tex oc, ft6.xy, fs0<2d, clamp, nearest, mipnone>
    
    ]]>;
    
    private var context:Context3D;
    private var isReady:Boolean;
    private var program:Program3D;
    private var renderMatrix:Matrix3D;
    private var vertexBuffer:VertexBuffer3D;
    private var indexBuffer:IndexBuffer3D;
    private var textureData:BitmapData;
    private var texture:Texture;
    private var textureWidth:int;
    private var textureHeight:int;

    public function Main():void 
    {
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        this.isReady = false;
        this.renderMatrix = new Matrix3D();
        
        loadImage();
        startRender();
    }
    
    private function loadImage():void 
    {
        var l:Loader = new Loader();
        l.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoad);
        var path:String = "http://assets.wonderfl.net/images/related_images/1/12/1247/124761a085cc7a1704c9fb601fe9d35e2e5a8b2e";
        l.load(new URLRequest(path), new LoaderContext(true));
    }
    
    private function onImageLoad(event:Event=null):void
    {
        event.currentTarget.removeEventListener(Event.COMPLETE, onImageLoad);
        var l:Loader = (event.currentTarget as LoaderInfo).loader;
        this.textureData = (l.content as Bitmap).bitmapData;    
        
        requestContext();
    }
    
    private function startRender():void
    {
        addEventListener(Event.ENTER_FRAME, onFrame);
    }
    
    private function requestContext():void
    {
        stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, onStage3dContext);
        stage.stage3Ds[0].requestContext3D(Context3DRenderMode.AUTO, Context3DProfile.BASELINE);
    }
    
    private function onStage3dContext(e:Event):void
    {
        this.context=stage.stage3Ds[0].context3D;
        this.context.configureBackBuffer(stage.stageWidth, stage.stageHeight, 2, false, false);
        
        createVertexBuffer();
        createIndexBuffer();
        createTextures();
        createPrograms();
        createControls();
        
        this.isReady = true;
    }
    
    private function createVertexBuffer():void
    {
        var vertices:Vector.<Number> = new <Number>[
        //    x            y        u  v
            -1.0,         1.0,      0, 0, 
             1.0,         1.0,      1, 0,
            -1.0,        -1.0,      0, 1,
             1.0,        -1.0,      1, 1  ];
            
        this.vertexBuffer=this.context.createVertexBuffer(4, 4);
        this.vertexBuffer.uploadFromVector(vertices, 0, 4);
    }
    
    private function createIndexBuffer():void
    {
        this.indexBuffer=this.context.createIndexBuffer(6);
        
       // 2 triangles (0, 1, 2) & (1, 3, 2)
       //   0 - 1
       //   | / |
       //   2 - 3
        this.indexBuffer.uploadFromVector(new <uint>[0, 1, 2,   1, 3, 2], 0, 6);
    }
    
    private function createTextures():void
    {
        this.textureWidth=this.textureData.width;
        this.textureHeight=this.textureData.height;
        this.texture = this.context.createTexture(this.textureWidth, this.textureHeight, Context3DTextureFormat.BGRA, false);
        this.texture.uploadFromBitmapData(this.textureData);
        this.textureData.dispose();
    }

    private function createPrograms():void
    {
        var vertexShaderAssembler:AGALMiniAssembler = new AGALMiniAssembler();
        vertexShaderAssembler.assemble(Context3DProgramType.VERTEX, VERTEX_SHADER);
        
        var fragmentShaderAssembler:AGALMiniAssembler = new AGALMiniAssembler();
        fragmentShaderAssembler.assemble(Context3DProgramType.FRAGMENT, FRAGMENT_SHADER);
        
        this.program = this.context.createProgram();
        this.program.upload(vertexShaderAssembler.agalcode, fragmentShaderAssembler.agalcode);
    }
    
    private function createControls():void
    {
        var s1:HUISlider = new HUISlider(this, 5, 5, "Levels", function(e:Event):void { numLevels = s1.value*.50; } );
        s1.minimum = 2.0;
        s1.maximum = 25.0;
        s1.tick = 1.0;
        s1.value = 5.0;
        
        var s2:HUISlider = new HUISlider(this, 5, 20, "Speed", function(e:Event):void { speed = s2.value; } );
        s2.minimum = -10.0;
        s2.maximum = 10.0;
        s2.tick = 1.0;
        s2.value = 1.0;
    }
    

    private var fc0:Vector.<Number> = new <Number>[1, 0, Math.PI, 2 * Math.PI];
    private var fc1:Vector.<Number> = new <Number>[1e-10, Math.PI / 2, 0, 4];
    private var fc2:Vector.<Number> = new <Number>[-1, 1, Math.PI/5,  0.0];
    private var fc3:Vector.<Number> = new <Number>[.1, .2, 2, 0];
    
    private var time:Number=0.0;
    private var numLevels:Number=2.5;
    private var speed:Number=1.0;
    
    private function onFrame(e:Event):void
    {
        if (!this.isReady)
            return;
            
        this.context.clear(0, 0, 0, 1);
        
        this.context.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, this.renderMatrix, true);
        
        this.context.setVertexBufferAt(0, this.vertexBuffer, 0, Context3DVertexBufferFormat.FLOAT_2);
        this.context.setVertexBufferAt(1, this.vertexBuffer, 2, Context3DVertexBufferFormat.FLOAT_2);
        
        this.fc2[2] = Math.PI / this.numLevels;
        this.fc2[3] = this.time;
        this.fc3[3] = this.textureHeight / this.textureWidth;
        
        this.context.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, this.fc0, 1);
        this.context.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 1, this.fc1, 1);
        this.context.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 2, this.fc2, 1);
        this.context.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 3, this.fc3, 1);
        
        this.context.setTextureAt(0, this.texture);
        this.context.setProgram(this.program);
        this.context.drawTriangles(this.indexBuffer);
        this.context.present();
        
        this.time+=(speed/textureWidth);
    }
    
}
    
}