/**
 * Copyright hakerlab ( http://wonderfl.net/user/hakerlab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/IFMT
 */

// forked from divillysausages's flash on 2011-5-13
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.ui.Mouse;
    
    public class TestLine extends Sprite
    {
        private var m_points:Vector.<Point> = null;
        private var m_mouseX:Number = 0.0;
        private var m_mouseY:Number = 0.0;
        
        public function TestLine() 
        {
            // add the mouse listeners
            this.stage.addEventListener( MouseEvent.MOUSE_DOWN, this._onDown );
            this.stage.addEventListener( MouseEvent.MOUSE_UP, this._onUp );
            this.stage.addEventListener( MouseEvent.MOUSE_MOVE, this._onMove );
            
            this.m_points = new Vector.<Point>();
        }
        
        // start the line
        private function _onDown( e:MouseEvent ):void
        {
            this.stage.addEventListener( Event.ENTER_FRAME, this._onEnterFrame );
            this.m_points.push( new Point( e.stageX, e.stageY ) );
        }
        
        // clear the line
        private function _onUp( e:MouseEvent ):void
        {
            this.stage.removeEventListener( Event.ENTER_FRAME, this._onEnterFrame );
            
            // clear our points array
            this.m_points.length = 0;
        }
        
        // keep track of the current mouse pos
        private function _onMove( e:MouseEvent ):void
        {
            this.m_mouseX = e.stageX;
            this.m_mouseY = e.stageY;
        }
        
        // add a new point and draw the line
        private function _onEnterFrame( e:Event ):void
        {
            // add a new point to our array
            this.m_points.push( new Point( this.m_mouseX, this.m_mouseY ) );
            
            this._draw();
        }
        
        // draw our line
        private function _draw():void
        {
            // if we don't have enough points, return
            if ( this.m_points.length < 2 )
                return;
            this.graphics.clear();
            
            this.graphics.lineStyle( 2 );
            var len:int = this.m_points.length;
            var dir:Point = new Point;    // direction of the line
            var norL:Point = new Point;    // left normal
            var norR:Point = new Point;    // right normal
            var max:Number = 20.0 / len;// used to calculate the line width
            
            // move to the start
            this.graphics.moveTo( this.m_points[0].x, this.m_points[0].y );
            
            var start:Point = null;
            var end:Point = null;
            var width:Number = 0.0;
            
            // now go up the left
            for ( var i:int = 0; i < len; i++ )
            {
                // stop 1 point from the end
                if ( i >= len - 2 )
                {
                    this.graphics.lineTo( this.m_points[this.m_points.length - 1].x, this.m_points[this.m_points.length - 1].y );
                    continue;
                }
                
                // get the start and end points
                start = this.m_points[i];
                end = this.m_points[i + 1];
                
                // get the dir of the line
                dir.x = end.x - start.x;
                dir.y = end.y - start.y;
                
                // get the left normal
                norL.x = dir.y;
                norL.y = -dir.x;
                norL.normalize( 1.0 );
                
                // get how far to go out from the central column and draw the line
                width = max * i;
                this.graphics.lineTo( end.x + norL.x * width, end.y + norL.y * width );
            }
            
            // now go down the right
            for ( i = len - 2; i >= 0; i-- )
            {
                // stop at the end
                if ( i == 0 )
                {
                    this.graphics.lineTo( this.m_points[i].x, this.m_points[i].y );
                    continue;
                }
                
                // get the start and end points
                start = this.m_points[i];
                end = this.m_points[i - 1];
                
                // get the dir
                dir.x = end.x - start.x;
                dir.y = end.y - start.y;
                
                // get the left normal (we're going back towards the start, so left is outside)
                norL.x = dir.y;
                norL.y = -dir.x;
                norL.normalize( 1.0 );
                
                // get our width and draw it
                width = max * i;
                this.graphics.lineTo( end.x + norL.x * width, end.y + norL.y * width );
            }
            
            //=================================================================================
            // debug
            this.graphics.lineStyle( 1.0, 0xff0000 );
            for ( i = 0; i < len; i++ )
            {
                if ( i >= len - 1 )
                {
                    this.graphics.lineTo( this.m_points[i].x, this.m_points[i].y );
                    continue;
                }
                
                // get the start and end points
                start = this.m_points[i];
                end = this.m_points[i + 1];
                
                // draw the central spine
                this.graphics.moveTo( start.x, start.y );
                this.graphics.lineTo( end.x, end.y );
                
                // get the dir
                dir.x = end.x - start.x;
                dir.y = end.y - start.y;
                
                // get the left normal
                norL.x = dir.y;
                norL.y = -dir.x;
                norL.normalize( 1.0 );
                
                // get the right normal
                norR.x = -dir.y;
                norR.y = dir.x;
                norR.normalize( 1.0 );
                
                // get our width
                width = max * i;
                
                // draw the left normal
                this.graphics.moveTo( end.x, end.y );
                this.graphics.lineTo( end.x + norL.x * width, end.y + norL.y * width );
                
                // draw the right normal
                this.graphics.moveTo( end.x, end.y );
                this.graphics.lineTo( end.x + norR.x * width, end.y + norR.y * width );
            }
            //=================================================================================
        }
        
    }

}