/**
 * Copyright 3f5 ( http://wonderfl.net/user/3f5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ICW7
 */

// forked from 3f5's 血しぶき高速化
// forked from 3f5's 血しぶき
// forked from yuitest's forked from: ビックバンです
// forked from 3f5's ビックバンです
package {
    import flash.net.LocalConnection;
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    import net.hires.debug.Stats;
    [SWF(frameRate="60", width="465", height="465")]
    public class Test extends Sprite {
        private var bitmap:BitmapData;
        private var bitmapRect:Rectangle;
        private var timer:Number = -1;
        
        private var last:Blood;
        private var first:Blood;
        
        private const rect:Rectangle = new Rectangle();

        public function Test() {
            stage.quality = "low";
            stage.mouseChildren = false;

            bitmap = new BitmapData(465, 465, false, 0xFFFFFF);
            bitmapRect = bitmap.rect;

            stage.addEventListener(MouseEvent.MOUSE_DOWN, function (event:MouseEvent):void {
                for (var i:uint = 0; i < 100; i++) {
                    push(stage.mouseX, stage.mouseY, 10,0);
                }
            });
            addChild(new Bitmap(bitmap));
            addChild(new Stats());
            addEventListener(Event.ENTER_FRAME, update);
        }
        private function push(x:Number, y:Number, size:int, gravity:Number):void {
            var blood:Blood = new Blood(x, y, size, gravity, rand(rand(-5, -1), rand(1, 5)), rand(rand(-5, -1), rand(1, 5)));

            if (!first) {
                first = last = blood;
            }
            else {
                blood.prev = last;
                last.next = blood;
                last = blood;
            }

            blood = null;
        }

        private function update(event:Event):void {
            if (!first) {
                return;
            }

            var blood:Blood = first;

            bitmap.lock();
            bitmap.fillRect(bitmapRect, 0xffffff);

            do {
                if (blood.y > 465) {
                    remove(blood);
                }
                else if (rand(1, 15) === 1 && blood.size - 3 >= 1) {
                    push(blood.x, blood.y, blood.size - 3, blood.gravity);
                    push(blood.x, blood.y, blood.size - 3, blood.gravity);
                    push(blood.x, blood.y, blood.size - 3, blood.gravity);
                    push(blood.x, blood.y, blood.size - 3, blood.gravity);
                    push(blood.x, blood.y, blood.size - 3, blood.gravity);
                    remove(blood);
                }
                else {
                  blood.aX *= 0.99;
                  blood.gravity += 0.002;
                  blood.aY = blood.aY * 0.99 + blood.gravity;
                  blood.x += blood.aX;
                  blood.y += blood.aY;
                
                  rect.width = blood.size;
                  rect.height = blood.size;
                  rect.x = blood.x;
                  rect.y = blood.y; 
                  bitmap.fillRect(rect, 0xFF0000);
                }
            } while (blood = blood.next);

            bitmap.unlock();
            
            blood = null;
        }
        
        private function remove(blood:Blood):void {
            if (blood === first && blood === last) {
                blood = null;
                first = null;
                last = null;
            }
            else if (blood === first) {
                first = blood.next;
                first.prev = null;
            }
            else if (blood === last) {
                last = blood.prev;
                last.next = null;
            }
            else {
                blood.prev.next = blood.next;
                blood.next.prev = blood.prev;
            }
            
            blood = null;
        }

        private function rand(min:int, max:int):int {
            var num:Number = Math.random() * (max - min + 1) + min;
            return (num >= ~~num) ? ~~num : ~~num - 1;
            //return Math.floor(Math.random() * (max - min + 1) + min);
        }

    }
}

final class Blood
{
    public var aY:Number;
    public var aX:Number;
    public var size:int;
    public var gravity:Number;
    public var x:Number;
    public var y:Number;

    public var next:Blood;
    public var prev:Blood;

    public function Blood(_x:Number, _y:Number, _size:int,_gravity:Number, _aX:Number, _aY:Number) {
        x = _x;
        y = _y;
        size = _size;
        gravity = _gravity;
        aX = _aX;
        aY = _aY;
    }
}
    
