/**
 * Copyright J.J ( http://wonderfl.net/user/J.J )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/I9tK
 */

package  {
    
    import flash.display.MovieClip;
    import flash.filters.GradientBevelFilter;
    import flash.display.Graphics;
    import flash.text.engine.GraphicElement;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.geom.Point;
    import com.bit101.components.Slider;
    import com.bit101.components.Label;

    

    public class Fourier extends MovieClip {

        private var i:int=0;
        private var w:int;
        private var h:int;
        private var R:Array;
        private var r:Number;
        private var colors:Array;
        private var points:Array;
        private var ps:Array;
        private var qx:Array;
        private var circles:Array;
        private var rl:Number;
        private var canvas:MovieClip;
        private var circCent:Point=new Point(120,200);
        private var fieldRad:Number;

        public function Fourier() {
        
            // constructor code
            stage.frameRate=60;
                w=stage.stageWidth;
                h=stage.stageHeight;
                canvas=new MovieClip();
                
                points=[];
                ps=[];
                qx=[];
                circles=[];
                R=[ 1, 0, .25, 0, .15, 0, .107, 0];
                colors = [0xff00f0,0x00e500,0xff5a00,0xfffc00,0x2a00ff,0x00f6ff,0xff0000,0x00ff00];
                var sum:Number = .0;
                for (var u in R) {
                    //R[u]*=1/2;
                    sum += R[u];

                    }
                r = 200 / sum;
                
                rl=R.length;
                fieldRad=(w/rl)/2;
                var mc:MovieClip=new MovieClip();
                this.addChild(mc);
                var gc:Graphics=mc.graphics;
                gc.beginFill(0x101010);
                gc.drawRect(0,0,w,h);
                gc.lineStyle(.1, 0x808080,.1);
                var step:Number=10;
                var st:Number = 0;
                //    i in 0 ... Std.int(w/step)
                    for (var i:int;i<int(w/step);i++) {
                    gc.moveTo(st, 0);
                    gc.lineTo(st, h);
                    st += step;
                    }
                    st=0;

                    for (i=0;i<int(h/step);i++) {
                    gc.moveTo(0, st);
                    gc.lineTo(w, st);
                    st += step;
                    }
                    var x = .0;
                    for ( i=0;i<rl;i++) {

                        qx[i] = [];
                        createCircle(x, 0,R[i],i);
                        x += w / rl;
                        trace(x)

                    }
                
                    this.addEventListener(Event.ENTER_FRAME,loop);
                    this.addChild(canvas);
                    

        }//endcnst

        private function loop(e:Event){

                    

            var dopi:Number = Math.PI * 2;
            var speed:int =2;
            var x =circCent.x;
            var y = circCent.y;
            
            var n:int = 8;
            var g :Graphics=canvas.graphics;
            var sc:Number=.8;

                //j in i ... (i+speed)

             for(var j:int=i;j<(i+speed);j++){

                  var a :Number= j / 400* dopi;
                 x = circCent.x;
                 y = circCent.y;
                 g.clear();
                 
                 for(var k:int=0;k<R.length;k++){
                    var  rx = R[k] * r*sc;
                    var ry = R[k] * r*sc;
                      var x2:Number = Math.cos((k+1) * a)*rx;
                     var y2:Number = Math.sin((k+1) * a)*ry;

                 qx[k].unshift(new Point(w / rl * 3, y));
                 for each(var kx in qx[k]) kx.x++;
                 if ( qx[k].length > 300)  qx[k].pop();
                 g.lineStyle(.5,0x808080);
                 g.drawCircle(x, y, 2);
                 g.drawCircle(x, y, R[k] * r*sc);
                 y += y2;
                 x += x2;
                     
                }
                var p :Point= new Point(w / rl * 3, y);
          
                ps.unshift(p);
                if (points.length > 200) points.pop();
                points.unshift(new Point(x, y));
                for each(var pj in ps) pj.x++;
                    if (ps.length > 300) {              
                        var pqq:Point=ps.pop()
                        pqq=null;

                        };
          

             }

            g.lineStyle(1);
            var t:Number = 1.0;
            var c :int= 0;
            for each(var q in qx) {
                t *= .5;
                g.lineStyle(2, colors[c],t);
                g.moveTo(q[0].x, q[0].y);

                for each( kx in q) {
                    g.lineTo(kx.x, kx.y);

                }
                c++;
            }
           

            g.lineStyle(1);
            g.moveTo(w / rl * 3, 0);
            g.lineTo(w / rl * 3, h);
            g.moveTo(x, y);
            g.lineTo(ps[0].x, ps[0].y);
            g.lineStyle(2, 0x11aaff);
             

            for each(p in ps) {
                //g.moveTo(p.x, p.y);
                g.lineTo(p.x+1, p.y);
                
                }
            g.moveTo(points[0].x, points[0].y);
            g.lineStyle(1,0xffffff);
            t = 1.1;

         

            for each(p in points) {
                t *= .99;
                g.lineStyle(1, 0xff0000, t);
                g.lineTo(p.x, p.y);
                };

        g.beginFill(0xff0000);
        g.drawCircle(x, y, 5);
                 i += speed;
                //------                
                var sum:Number = .0;

        for each(var u in R) {
            sum += u;
            }
         q = 200 / sum;
         r += (q - r) * .1;


        }

        private function createCircle(x:Number,y:Number,r:Number,idx:int):MovieClip {

        var sp :MovieClip= new MovieClip();            
        sp.idx = idx;        
        circles.push(sp);
        this.addChild(sp);
        var g :Graphics= sp.graphics;
        g.lineStyle(.1);
        g.beginFill(0x808080, .2);
        var q :MovieClip= new MovieClip();
        g.drawRect(0, 0, w/rl, w/rl);
        sp.addChild(q);
        g = q.graphics;
        sp.x = x;
        sp.y = y;
        sp.q = q;
        g.lineStyle(1,0x808080);

            
        var slide:Slider=new Slider(Slider.VERTICAL,this,x+fieldRad,y);    
            slide.setSliderParams(0,1,R[idx]);         
            slide.x-=slide.width/2;
            var h2:Number=slide.height/3;
            slide.height=h2;
            slide.y+=2
            slide.alpha=.5;
            var lable:Label=new Label(this,slide.x-6,slide.y+slide.height,"R"+idx+":"+R[idx].toFixed(2));
            slide.addEventListener(Event.CHANGE,function (e:Event){
                var tar:Slider=e.target as Slider;
            R[idx]=tar.value;
                lable.text="R"+idx+":"+tar.value.toFixed(2);

                })

        return sp;

    }        

    }
    

}

