/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/H0qt
 */

// forked from o8que's ソートを使う （forked from: ballの重なりはどうすればよいですか？）
/*
 * 全てのボールの重なり順が正しく表示される解決方法の一つです。
 * 
 * ボールが他のボールより前にあるか後にあるかは、
 * 2つのボールのY座標の値を比較すればわかります。
 * （前にあるものほどY座標の値が大きくなるので）
 * ボールをY座標の値が小さい順にソート（並び替え）し、
 * 奥にあるボールから順にaddChild()で再配置するようにすることで、
 * 全てのボールを正しい重なり順で表示することができます。
 * 
 * （この方法は、配列中のボールの並びを頻繁に入れ替えるため、
 * 　ボール自身（ボールのクラス）に
 * 　自分の位置情報を持たせて更新させています。）
 * 
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	
	public class FlashTest extends Sprite {
		public static const RADIUS:int = 200;	// 回転する円の半径
		public static const BALL_NUM:int = 12;	// ボールの個数
		
		private var _balls:Array;
		
		public function FlashTest() {
			_balls = new Array();
			for (var i:int = 0; i < BALL_NUM; i++) {
				var ball:Ball = new Ball((i * (360 / BALL_NUM)) * (Math.PI / 180), 0xffffff * Math.random(), 30);
				_balls.push(ball);
				addChild(ball);
			}
			
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void {
			var i:int;
			var speed:Number = ((mouseX - 232) / 30) * (Math.PI / 180);
			
			for (i = 0; i < BALL_NUM; i++) {
				_balls[i].update(speed);
			}
			
			// ボールのyの数値に基づくソート（配列の並び替え）を行う
			// この処理の後、配列_ballsに入っているballの並び順は、
			// yの数値が小さい順（奥にある順）に並び替えられている
			_balls.sortOn("y", Array.NUMERIC);
			
			// 奥にあるボールから順に再配置していく
			for (i = 0; i < BALL_NUM; i++) {
				addChild(_balls[i]);
			}
		}
	}
}

import flash.display.Sprite;
import flash.filters.BlurFilter;
import flash.geom.Matrix;

class Ball extends Sprite {
	private var _angle:Number;	// 角度（ラジアン）
	
	public function Ball(angle:Number, color:uint, size:int) {
		_angle = angle;
		
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, size);
		graphics.endFill();
	}
	
	public function update(speed:Number):void {
		_angle += speed;
		
		transform.matrix = new Matrix(
			Math.sin(_angle),
			0,
			-(Math.cos(_angle) / 2),
			1,
			232 + FlashTest.RADIUS * Math.cos(_angle),
			232 + FlashTest.RADIUS * Math.sin(_angle) / 5
		);
		
		// フィルタで奥の方をぼかす
		var blur:Number = (232 - y) / 5;
		filters = [new BlurFilter(blur, blur)];
	}
}