/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Grkn
 */

// forked from ProjectNya's Fireworks2011
////////////////////////////////////////////////////////////////////////////////
// Fireworks2011
//
// [AS3.0] ドットの光 (8)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1097
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.utils.Timer;
    import flash.events.TimerEvent;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var fireworks:Fireworks;
        private var timer:Timer;
        private var colors:Array;
        private var points:Array;
        private var count:uint = 0;

        public function Main() {
            //Wonderfl.capture_delay(4);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            colors = new Array();
            colors.push([{h: 200, s: 0}, {h: 200, s: 0.2}]);
            colors.push([{h: 0, s: 0.2}, {h: 0, s: 0.4}]);
            colors.push([{h: 60, s: 0.2}, {h: 60, s: 0.4}]);
            colors.push([{h: 150, s: 0.2}, {h: 150, s: 0.4}]);
            //
            points = new Array();
            // 2
            points.push(new Point(24+4, 84));
            points.push(new Point(24+52, 60));
            points.push(new Point(24+100, 84));
            points.push(new Point(24+68, 124));
            points.push(new Point(24+36, 164));
            points.push(new Point(24+4, 204));
            points.push(new Point(24+52, 204));
            points.push(new Point(24+100, 204));
            // 0
            points.push(new Point(56+172, 60));
            points.push(new Point(56+140, 84));
            points.push(new Point(56+124, 132));
            points.push(new Point(56+140, 180));
            points.push(new Point(56+172, 204));
            points.push(new Point(56+212, 180));
            points.push(new Point(56+220, 132));
            points.push(new Point(56+212, 84));
            points.push(new Point(56+172, 60));
            // 1
            points.push(new Point(64+292, 60));
            points.push(new Point(64+292, 108));
            points.push(new Point(64+292, 156));
            points.push(new Point(64+292, 204));
            // 1
            points.push(new Point(24+412, 60));
            points.push(new Point(24+412, 108));
            points.push(new Point(24+412, 156));
            points.push(new Point(24+412, 204));
            //
            fireworks = new Fireworks(new Rectangle(0, 0, 465, 465));
            addChild(fireworks);
            start();
        }
        private function start():void {
            fireworks.addEventListener(Fireworks.COMPLETE, complete, false, 0, true);
            fireworks.launch(points[count], colors[count%colors.length]);
            startTimer();
        }
        private function startTimer():void {
            timer = new Timer(200, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, launch, false, 0, true);
            timer.start();
        }
        private function launch(evt:TimerEvent):void {
            timer.removeEventListener(TimerEvent.TIMER_COMPLETE, launch);
            count ++;
            if (count < points.length) {
                fireworks.launch(points[count], colors[count%colors.length]);
                startTimer();
            }
        }
        private function complete(evt:Event):void {
            fireworks.removeEventListener(Fireworks.COMPLETE, complete);
            timer = new Timer(1000, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, restart, false, 0, true);
            timer.start();
        }
        private function restart(evt:TimerEvent):void {
            evt.target.removeEventListener(TimerEvent.TIMER_COMPLETE, restart);
            count = 0;
            start();
        }

    }

}


//////////////////////////////////////////////////
// Fireworksクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.PixelSnapping;
import flash.display.BlendMode;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.filters.BlurFilter;
import flash.events.Event;

class Fireworks extends Sprite {
    private var rect:Rectangle;
    private var bitmapData:BitmapData;
    private var sparkle:BitmapData;
    private var afterglow:BitmapData;
    private static var scale:uint = 4;
    private var matrix:Matrix;
    private var amatrix:Matrix;
    private var colorTrans:ColorTransform;
    private var blur:BlurFilter;
    private var fireworks:Array;
    private var garbage:Array;
    private var initialized:Boolean = false;
    public static const COMPLETE:String = Event.COMPLETE;

    public function Fireworks(r:Rectangle) {
        rect = r;
        init();
    }

    private function init():void {
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        var bitmap:Bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        sparkle = new BitmapData(rect.width/scale, rect.height/scale, true, 0x00000000);
        var sBitmap:Bitmap = new Bitmap(sparkle);
        sBitmap.smoothing = true;
        sBitmap.blendMode = BlendMode.ADD;
        sBitmap.scaleX = sBitmap.scaleY = scale;
        addChild(sBitmap);
        afterglow = new BitmapData(rect.width*2/scale, rect.height*2/scale, true, 0x00000000);
        var aBitmap:Bitmap = new Bitmap(afterglow, PixelSnapping.AUTO, true);
        aBitmap.blendMode = BlendMode.ADD;
        aBitmap.scaleX = aBitmap.scaleY = scale/2;
        addChild(aBitmap);
        matrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
        amatrix = new Matrix(2/scale, 0, 0, 2/scale, 0, 0);
        colorTrans = new ColorTransform(0.16, 0.16, 0.16);
        blur = new BlurFilter(2, 2, 1);
        fireworks = new Array();
        garbage = new Array();
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function launch(targetPos:Point, color:Object):void {
        var firework:Firework = new Firework(bitmapData);
        firework.id = fireworks.length;
        firework.targetPos = targetPos;
        firework.create(color);
        firework.addEventListener(Firework.COMPLETE, complete, false, 0, true);
        fireworks.push(firework);
    }
    private function update(evt:Event):void {
        if (fireworks.length < 1) initialized = true;
        if (fireworks.length > 0) {
            bitmapData.lock();
            bitmapData.fillRect(bitmapData.rect, 0x00000000);
            if (garbage.length > 0) remove();
            for (var n:uint = 0; n < fireworks.length; n++) {
                var firework:Firework = fireworks[n];
                firework.emit();
            }
            bitmapData.unlock();
            sparkle.lock();
            sparkle.fillRect(sparkle.rect, 0x00000000);
            sparkle.draw(bitmapData, matrix);
            sparkle.unlock();
        }
        afterglow.lock();
        afterglow.draw(bitmapData, amatrix, colorTrans, BlendMode.ADD);
        afterglow.applyFilter(afterglow, afterglow.rect, new Point(), blur);
        afterglow.unlock();
        if (initialized && fireworks.length < 2) {
            fireworks = new Array();
            reset();
            dispatchEvent(new Event(Fireworks.COMPLETE));
            initialized = false;
        }
    }
    private function complete(evt:Event):void {
        var firework:Firework = Firework(evt.target);
        firework.removeEventListener(Firework.COMPLETE, complete);
        garbage.push(firework.id);
    }
    private function remove():void {
        for (var n:uint = 0; n < garbage.length; n++) {
            var id:uint = garbage[n];
            var firework:Firework = fireworks[id];
            fireworks.splice(id, 1);
            firework = null;
        }
        reset();
    }
    private function reset():void {
        for (var n:uint = 0; n < fireworks.length; n++) {
            var firework:Firework = fireworks[n];
            firework.id = n;
        }
        garbage = new Array();
    }

}


//////////////////////////////////////////////////
// Fireworkクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.events.Event;
import frocessing.color.ColorHSV;

class Firework extends EventDispatcher {
    public var id:uint;
    private var bitmapData:BitmapData;
    private var rect:Rectangle;
    private var launcher:ParticleDot;
    private var dots:Array;
    private static var speed:Number = 10;
    private static var deceleration:Number = 0.94;
    private static var gravity:Number = 0.05;
    private var color:ColorHSV;
    private var colors:Object;
    private static var length:Number = 2;
    private var manager:Bresenham;
    public var emit:Function;
    private var se:SoundEffect;
    private static var soundPath:String = "http://hwzhiyin.com/uploadfile/1367968019.mp3";
    public var targetPos:Point;
    public static const COMPLETE:String = Event.COMPLETE;

    public function Firework(s:BitmapData) {
        bitmapData  = s;
        rect = bitmapData.rect;
        init();
    }

    private function init():void {
        dots = new Array();
        color = new ColorHSV(0, 1);
        manager = new Bresenham(bitmapData);
        emit = ready;
        se = new SoundEffect();
        se.load(soundPath);
    }
    private function ready():void {
    }
    public function create(option:Object):void {
        colors = option;
        launcher = new ParticleDot(targetPos.x, rect.height);
        launcher.vy = - speed*(1 + Math.random()*0.05);
        color.h = colors.h;
        color.s = colors.s;
        launcher.rgb = color.value;
        emit = launch;
    }
    private function launch():void {
        launcher.vy += gravity;
        launcher.y += (targetPos.y - launcher.y)*0.5;
        bitmapData.setPixel32(launcher.x, launcher.y, 0xFF << 24 | launcher.rgb);
        if (Math.abs(targetPos.y - launcher.y) < 0.5) {
            explode(160, new Point(launcher.x, launcher.y), launcher.rgb);
            launcher = null;
        }
    }
    private function explode(max:uint, point:Point, rgb:uint):void {
        for (var n:uint = 0; n < max; n++) {
            var energy:Number = Math.random()*5;
            var angle:Number = Math.random()*360;
            var dot:ParticleDot = new ParticleDot(point.x, point.y, energy, angle);
            dot.velocity = Math.random()*5;
            dot.vx = Math.cos(dot.angle*Math.PI/180)*dot.velocity;
            dot.vy = Math.sin(dot.angle*Math.PI/180)*dot.velocity;
            dot.px = dot.x;
            dot.py = dot.y;
            dot.rgb = rgb;
            dots.push(dot);
        }
        emit = spread;
        se.play(0.6);
    }
    private function spread():void {
        for (var n:uint = 0; n < dots.length; n++) {
            var dot:ParticleDot = dots[n];
            dot.vx *= deceleration;
            dot.vy *= deceleration;
            dot.vy += gravity;
            dot.x += dot.vx;
            dot.y += dot.vy;
            dot.energy *= deceleration;
            var x0:int = dot.x;
            var y0:int = dot.y;
            var x1:int = dot.x - (dot.x - dot.px)*length;
            var y1:int = dot.y - (dot.y - dot.py)*length;
            color.h = colors[1].h + (colors[0].h - colors[1].h)*dot.energy*0.2;
            color.s = colors[1].s + (colors[0].s - colors[1].s)*dot.energy*0.2;
            dot.rgb = color.value;
            manager.draw(x0, y0, x1, y1, dot.rgb, 1);
            dot.px = dot.x;
            dot.py = dot.y;
            if (dot.energy < 0.05) {
                dots.splice(n, 1);
                dot = null;
                if (dots.length < 1) {
                    dispatchEvent(new Event(Firework.COMPLETE));
                }
            }
        }
    }

}


//////////////////////////////////////////////////
// EmitLightクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import frocessing.color.ColorHSV;

class EmitLight {
    private var canvas:BitmapData;
    private var rect:Rectangle;
    private var dots:Array;
    private static var deceleration:Number = 0.1;
    private var color:ColorHSV;

    public function EmitLight(c:BitmapData) {
        canvas  = c;
        rect = canvas.rect;
        init();
    }

    private function init():void {
        dots = new Array();
        color = new ColorHSV(0, 0.4);
    }
    public function create(max:uint):void {
        for (var n:uint = 0; n < max; n++) {
            var px:Number = Math.random()*rect.width;
            var py:Number = rect.height - Math.random()*5;
            var energy:Number = Math.random() + 0.5;
            var dot:ParticleDot = new ParticleDot(px, py, energy);
            color.h = Math.random()*360;
            dot.rgb = color.value;
            dots.push(dot);
        }
    }
    public function emit():void {
        for (var n:uint = 0; n < dots.length; n++) {
            var dot:ParticleDot = dots[n];
            dot.energy -= deceleration;
            canvas.setPixel(dot.x, dot.y, dot.rgb);
            if (dot.energy < 0) {
                dots.splice(n, 1);
                dot = null;
            }
        }
    }

}


//////////////////////////////////////////////////
// ParticleDotクラス
//////////////////////////////////////////////////

class ParticleDot {
    public var x:Number = 0;
    public var y:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var px:Number = 0;
    public var py:Number = 0;
    public var energy:Number = 1;
    public var angle:Number = 0;
    public var velocity:Number = 1;
    public var rgb:uint = 0xFFFFFF;

    public function ParticleDot(_x:Number, _y:Number, e:Number = 1, a:Number = 0):void {
        x = _x;
        y = _y;
        energy = e;
        angle = a;
    }
    
}


//////////////////////////////////////////////////
// Bresenhamクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;

class Bresenham {
    private var canvas:BitmapData;

    public function Bresenham(c:BitmapData) {
        canvas = c;
    }

    public function draw(x0:int, y0:int, x1:int, y1:int, color:uint, alpha:Number):void {
        var steep:Boolean = Math.abs(y1 - y0) > Math.abs(x1 - x0);
        var t:int;
        if (steep) {
            t = x0;
            x0 = y0;
            y0 = t;
            t = x1;
            x1 = y1;
            y1 = t;
        }
        if (x0 > x1) {
            t = x0;
            x0 = x1;
            x1 = t;
            t = y0;
            y0 = y1;
            y1 = t;
        }
        var dx:int = x1 - x0;
        var dy:int = Math.abs(y1 - y0);
        var e:int = dx*0.5;
        var ys:int = (y0 < y1) ? 1 : -1;
        var y:int = y0;
        for (var x:int = x0; x <= x1; x++) {
            if (steep) {
                plot(y, x, color, alpha);
            } else {
                plot(x, y, color, alpha);
            }
            e = e - dy;
            if (e < 0) {
                y = y + ys;
                e = e + dx;
            }
        }
    }
    private function plot(x:int, y:int, c:uint, a:Number):void {
        canvas.setPixel32(x, y, c | ((a*0xFF) << 24));
    }

}


//////////////////////////////////////////////////
// SoundEffectクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.net.URLRequest;

class SoundEffect extends EventDispatcher {
    public var id:String;
    private var sound:Sound;
    private var channel:SoundChannel;
    private var level:Number;
    private var volume:Number = 1;
    private var looping:Boolean = false;
    public var initialized:Boolean = false;
    public var playing:Boolean = false;
    private var muted:Boolean = false;
    private var mute:Number = 1;

    public function SoundEffect() {
    }

    public function init(Snd:Class):void {
        sound = new Snd();
    }
    public function load(filePath:String):void {
        sound = new Sound();
        sound.load(new URLRequest(filePath));
        sound.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        sound.addEventListener(Event.COMPLETE, initialize, false, 0, true);
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function initialize(evt:Event):void {
        initialized = true;
        channel = sound.play();
        channel.stop();
        dispatchEvent(evt);
    }
    public function play(lv:Number, loop:Boolean = false):void {
        playing = true;
        if (channel) channel.stop();
            level = lv;
            looping = loop;
            channel = sound.play();
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume*mute;
            channel.soundTransform = transform;
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
    }
    public function stop():void {
        playing = false;
        channel.stop();
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
    }
    public function setVolume(v:Number):void {
        volume = v;
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume*mute;
        channel.soundTransform = transform;
    }
    public function setMute(m:Boolean):void {
        muted = m;
        if (muted) {
            mute = 0;
        } else {
            mute = 1;
        }
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume*mute;
        channel.soundTransform = transform;
    }
    private function complete(evt:Event):void {
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        dispatchEvent(new Event(Event.COMPLETE));
        if (looping) {
            channel = sound.play(0);
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume*mute;
            channel.soundTransform = transform;
        } else {
            playing = false;
        }
    }

}
