/**
 * Copyright Alex.Stenezky ( http://wonderfl.net/user/Alex.Stenezky )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/GYOq
 */

// forked from lizhi's Bezier Particle
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    /**
     * ...
     * @author lizhi http://game-develop.net/
     */
    [SWF(width=465,height=465,backgroundColor=0xffffff,frameRate=60)]
    public class Bezier4 extends Sprite
    {
        private var ps:Array;
        private var maxSpeed:Number = 3;
        private var forceScale:Number = 0.05;
        private var friction:Number = 0.7;
        private var segmentLength:Number = 5;
        private var windX:Number = -5;
        private var windY:Number = 0;
        public function Bezier4() 
        {
            ps = [];
            var c:int = 20;
            while (c-->0) {
                ps.push(new Particle);
            }
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        private function onMouseMove(e:MouseEvent):void 
        {
            ps[0].x = mouseX;
            ps[0].y = mouseY;
            e.updateAfterEvent();
            draw();
        }
        
        private function draw():void {
            graphics.clear();
            graphics.lineStyle(0);
            graphics.moveTo(ps[0].x, ps[0].y);
            for (var i:int = 1; i < ps.length;i++ ) {
                graphics.curveTo(ps[i-1].x, ps[i-1].y,ps[i-1].x/2+ps[i].x/2,ps[i-1].y/2+ps[i].y/2);
            }
        }
        
        private function update(e:Event):void 
        {
            for (var i:int = 1; i < ps.length;i++ ) {
                var pp:Particle = ps[i - 1];
                var p:Particle = ps[i];
                p.ax = (pp.x- p.x+windX)*forceScale;
                p.ay = (pp.y- p.y+windY)*forceScale;
                p.vx += p.ax;
                p.vy += p.ay;
                p.vx = p.vx > maxSpeed?maxSpeed:p.vx;
                p.vx = p.vx < -maxSpeed? -maxSpeed:p.vx;
                p.vy = p.vy > maxSpeed?maxSpeed:p.vy;
                p.vy = p.vy < -maxSpeed? -maxSpeed:p.vy;
                p.vx *= friction;
                p.vy *= friction;
                p.x += p.vx;
                p.y += p.vy;
            }
            draw();
        }
        
    }

}
import flash.geom.Point;
class Particle extends Point {
    public var vx:Number=0;
    public var vy:Number=0;
    public var ax:Number;
    public var ay:Number;
}