/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/GXJ1
 */

package {
    import flash.events.Event;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class Warp extends Sprite {
        private const messages:Array = ["hello there", "good to see ya", "this is greekfellows", "have some fun!", "and back to\nthe beginning...", "オッス", "会えてうれしいぜ", "グリィクフェロウズだ", "ぜひ楽しんでくれ！\n（ってなにを？！）", "んじゃまた初めから..."];
        private var ci:int = 0;
        
        private var gx:Number;
        private var gy:Number;
        private var gz:Number;
        
        private var sprite:Sprite;
        private var textfield:TextField;
        
        private var animation:String;
        
        private const WIPE_LEFTWARDS:String = "wipe leftwards";
        private const WIPE_RIGHTWARDS:String = "wipe rightwards";
        private const WIPE_UPWARDS:String = "wipe upwards";
        private const WIPE_DOWNWARDS:String = "wipe downwards";
        private const WIPE_INWARDS:String = "wipe inwards";
        private const WIPE_OUTWARDS:String = "wipe outwards";
        
        private var allanimations:Array;
        
        public function Warp() {
            init();
        }
        
        private function init():void {
            allanimations = [WIPE_LEFTWARDS, WIPE_RIGHTWARDS, WIPE_UPWARDS, WIPE_DOWNWARDS, WIPE_INWARDS, WIPE_OUTWARDS];
            
            this.x = 465 / 2;
            this.y = 465 / 2;
            this.z = 0;
            
            gx = 0;
            gy = 0;
            gz = 0;
            
            sprite = new Sprite();
            sprite.x = 0;
            sprite.y = 0;
            sprite.z = 0;
            this.addChild(sprite);
            
            textfield = text(messages[ci]);
            ci++;
            
            prepare();
        }
        
        private function prepare():void {
            animation = allanimations[ Math.floor( Math.random() * allanimations.length ) ];
            
            switch (animation) {
                case WIPE_LEFTWARDS:
                textfield.x -= 465;
                gx += 465;
                break;
                
                case WIPE_RIGHTWARDS:
                textfield.x += 465;
                gx -= 465;
                break;
                
                case WIPE_UPWARDS:
                textfield.y -= 465;
                gy += 465;
                break;
                
                case WIPE_DOWNWARDS:
                textfield.y += 465;
                gy -= 465;
                break;
                
                case WIPE_INWARDS:
                textfield.z += 465;
                gz -= 465;
                
                case WIPE_OUTWARDS:
                textfield.z -= 465;
                gz += 465;
            }
            
            this.addEventListener(Event.ENTER_FRAME, warp);
        }

        
        private function warp(e:Event):void {
            sprite.x += (gx - sprite.x) / 10;
            sprite.y += (gy - sprite.y) / 10;
            sprite.z += (gz - sprite.z) / 10;
            
            if (sprite.numChildren > 1) {
                sprite.getChildAt(sprite.numChildren - 2).alpha -= (sprite.getChildAt(sprite.numChildren - 2).alpha - .1) / 10;
            }
            
            if (Math.abs(gx - sprite.x) < 1 && Math.abs(gy - sprite.y) < 1 && Math.abs(gz - sprite.z) < 1) {
                sprite.x = gx;
                sprite.y = gy;
                sprite.z = gz;
                
                if (sprite.numChildren > 1) {
                    sprite.getChildAt(sprite.numChildren - 2).alpha = .1;
                }
                
                this.removeEventListener(Event.ENTER_FRAME, warp);
                
                textfield = text(messages[ci]);
                ci++;
                
                if (ci >= messages.length) {
                    ci = 0;
                }
                
                prepare();
            }
        }

        
        private function text(string:String):TextField {
            var tf:TextField = new TextField();
            tf.selectable = false;
            tf.text = string;
            
            var fr:TextFormat = new TextFormat();
            fr.font = "Segoe UI Light";
            fr.size = 48;
            
            tf.setTextFormat(fr);
            
            tf.width = tf.textWidth + 4;
            tf.height = tf.textHeight + 4;
            tf.x = -sprite.x - tf.textWidth / 2;
            tf.y = -sprite.y - tf.textHeight / 2;
            tf.z = -sprite.z;
            
            sprite.addChild(tf);
            
            return tf;
        }

    }
}