/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/GLTY
 */

// forked from wh0's modern stripes
package {
    import flash.display.*;
    import flash.filters.*;
    import flash.geom.*;
    [SWF(backgroundColor=0x202020)]
    public class FlashTest extends Sprite {
        
        private static const MAX:int = 16;
        private static const SIZE:int = 32;
        private static const MIN:Number = 4;
        private static const SOFT:DropShadowFilter = new DropShadowFilter(0, 0, 0x000000, 0.5, 16, 0);
        
        public function FlashTest() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            var i:int;
            var d:Vector.<int> = new Vector.<int>(SIZE);
            for (i = 0; i < SIZE; i++) {
                d[i] = Math.random() * MAX;
            }
            var l:Vector.<int> = new Vector.<int>(SIZE);
            for (i = 1; i < SIZE; i++) {
                l[i] = d[i] > d[i - 1] ? l[i - 1] + 1 : 0;
            }
            var r:Vector.<int> = new Vector.<int>(SIZE);
            for (i = SIZE - 2; i >= 0; i--) {
                r[i] = d[i] > d[i + 1] ? r[i + 1] + 1 : 0;
            }
            var m:Vector.<int> = new Vector.<int>(SIZE);
            var c:Vector.<int> = new Vector.<int>(MAX);
            for (i = 0; i < SIZE; i++) {
                m[i] = Math.max(l[i], r[i]);
                c[m[i]]++;
            }
            var p:Vector.<Vector.<int>> = new Vector.<Vector.<int>>(MAX);
            for (i = 0; i < MAX; i++) {
                p[i] = new Vector.<int>(c[i]);
                c[i] = 0;
            }
            for (i = 0; i < SIZE; i++) {
                p[m[i]][c[m[i]]++] = i;
            }
            var x:Vector.<Number> = new Vector.<Number>(SIZE + 1);
            x[0] = 0;
            x[SIZE] = stage.stageWidth - MIN * SIZE;
            for (i = 1; i < SIZE; i++) {
                x[i] = Math.random() * x[SIZE];
            }
            x.sort(function(a:Number, b:Number):Number { return a - b });
            for (i = 1; i <= SIZE; i++) {
                x[i] = Math.floor(x[i] + i * MIN);
            }
            
            // ok enough calculations, let's render.
            for (i = 1; i < MAX; i++) {
                var s:Shape = new Shape();
                s.graphics.beginFill(0x202020 * i + 0x202020);
                for (var j:int = 0; j < c[i]; j++) {
                    var k:int = p[i][j];
                    s.graphics.drawRect(x[k], 0, x[k + 1] - x[k], stage.stageHeight);
                }
                s.graphics.endFill();
                s.filters = [SOFT];
                addChild(s);
            }
            transform.matrix = new Matrix(1, 0, -0.2, 1, stage.stageHeight * 0.1, 0);
        }
        
    }
}