/**
 * Copyright wrotenodoc ( http://wonderfl.net/user/wrotenodoc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/GHAl
 */

package {
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.display.Sprite;    
    import flash.display.Bitmap;
    import flash.display.BitmapData
    
    public class FlashTest extends Sprite {
        
        private const W:Number = 512
        private const H:Number = 512
        
        private var _field:BitmapData
        private var _fieldBmp:Bitmap
        private var _container:Sprite
        private var _particles:Array = []
        private var _bd:BitmapData
        
        public function FlashTest() {
            // write as3 code here..
            graphics.beginFill(0x0)
            graphics.drawRect(0, 0, W, H)
            
            _field = new BitmapData(W, H, false, 0x0)
            _field.perlinNoise(W/4, H/4, 4, Math.random()*0xffffff, false, true, 1, true)
            _field.threshold(_field, _field.rect, new Point, "<=", 127, 0xff000000, 0xff, true)
            _field.threshold(_field, _field.rect, new Point, ">", 127, 0xffffffff, 0xff, true)
            addChild(_fieldBmp = new Bitmap(_field))
            
            addChild(_container = new Sprite)
            _bd = new BitmapData(W, H, true, 0x0)
            addChild(new Bitmap(_bd))
            
            stage.addEventListener("mouseMove", onMouseMove)
            stage.addEventListener("click", toggle)
            addEventListener("enterFrame", loop)
        }
        
        private function toggle(e:MouseEvent):void {
            _fieldBmp.visible = !_fieldBmp.visible
        }
        
        private var cnt:int = 0
        private function onMouseMove(e:MouseEvent):void {
            if(cnt++ < 30) return
            cnt = 0
            
            if(_field.getPixel(mouseX, mouseY) > 0) return
            for(var i:int=0; i<16; i++){
                var p:Particle = new Particle(Math.PI*2 * (i/16))
                p.x = mouseX
                p.y = mouseY
                _particles.push(p)
                _container.addChild(p)
            }
        }
        
        private function loop(e:Event):void {
            for(var i:int=0; i<_particles.length; i++){
                var expired:Boolean = _particles[i].integrate(_field)
                if(expired){
                    _container.removeChild(_particles[i])
                    _particles.splice(i, 1)
                }
            }
            _bd.draw(_container)
            _bd.colorTransform(_bd.rect, new ColorTransform(1,1,1,0.96))
            //_bd.applyFilter(_bd, _bd.rect, new Point, new BlurFilter(2, 2, 1))
        }

    }
}

import flash.display.Shape
import flash.display.BitmapData

class Particle extends Shape {
    
    private const velocity:Number = 3
    private var _vx:Number, _vy:Number
    private var _life:int = 100
    
    public function Particle(angle:Number) {
        graphics.beginFill(0xffffff)
        graphics.drawCircle(0, 0, 1)
        _vx = velocity * Math.cos(angle)
        _vy = velocity * Math.sin(angle)
    }
    
    public function integrate(bd:BitmapData):Boolean {
        x += _vx
        y += _vy
        if(bd.rect.contains(x, y) == false || bd.getPixel(x, y) > 0){
            _vx *= -1 ; _vy *= -1
            x += _vx ; y += _vy
        }

        _life --
        return _life <= 0
    }
    
}
