/**
 * Copyright YoupSolo ( http://wonderfl.net/user/YoupSolo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/GA7F
 */

package {
    import flash.filters.DropShadowFilter;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.display.DisplayObjectContainer;
    import flash.text.TextFieldAutoSize;
    /**
     * ...
     * @author YopSolo
     */    
    public class SuperShapeTest extends Sprite {
        private var sh:Shape;
        private var infos:TextField;
        
        public function SuperShapeTest() {            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);                        
        }
        
        private function init(event:Event = null):void
        {
            var bg:Sprite = new Sprite();
            bg.graphics.beginFill(0x333333);
            bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            bg.graphics.endFill();
            bg.cacheAsBitmap = true;            
            addChild(bg);
            
            sh = new Shape();
            sh.x = stage.stageWidth / 2;
            sh.y = stage.stageHeight / 2;
            sh.cacheAsBitmap = true;
            addChild(sh);    
            
            sh.filters = [new DropShadowFilter()];        
            buildTextField(this, "SuperShape Test",5,5);
            
            onClickStage();
            
            stage.addEventListener(MouseEvent.CLICK, onClickStage);
            addEventListener(Event.ENTER_FRAME, oef);
        }
        
        private function buildTextField(doc:DisplayObjectContainer, txt:String, x:int = 0, y:int = 0):TextField
        {
            var fmt:TextFormat = new TextFormat;
            fmt.color = 0xFFFFFF;
            fmt.font = 'Arial'; //(new FONT_HARMONY() as Font).fontName;
            fmt.size = 11; // 8;
            var tf:TextField = new TextField;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.opaqueBackground = 0x0; // opaque background allow a perfect font rendering even in StageQuality.LOW mode
            tf.selectable = false;
            //tf.embedFonts = true;
            tf.defaultTextFormat = fmt;
            tf.text = txt;
            tf.x = x;
            tf.y = y;           

            doc.addChild(tf);
            return tf;
        }           
        
        private function oef(event:Event):void
        {
            if(sh.stage)
            {
                sh.rotation += 1;
            }
        }

        
        private function onClickStage(event:MouseEvent = null):void
        {
            sh.graphics.clear();
            sh.graphics.lineStyle(2, Math.random() * 0xFFFFFF);
            sh.graphics.beginFill(Math.random() * 0xFFFFFF);
            
            var m:Number =  int(Math.random() * 50 - 25);
            var n1:Number = int(Math.random() * 50);
            var n2:Number = int(Math.random() * 50);
            var n3:Number = int(Math.random() * 50);
            if (infos) removeChild(infos);
            infos = buildTextField(this, "M:"+m+" N1:"+n1+" N2:"+n2+" N3:"+n3,5,25);
            SuperShape.draw(sh.graphics, 0, 0, 30 + Math.random() * 30, m, n1, n2, n3);
            sh.graphics.endFill();
        }
    }
}

import flash.display.Graphics;
class SuperShape
{
        /**
         * https://en.wikipedia.org/wiki/Superformula
         * @param    target
         * @param    CX, start position X
         * @param    CY, start position Y
         * @param    scale
         * @param    m, ? :D
         * @param    n1, ? :D
         * @param    n2, ? :D
         * @param    n3, ? :D
         * @param    step, precision .001 is great, 1 is very low
         * @param    a, ? :D
         * @param    b, ? :D
         * 
         * check the wiki page for details on parameters :p
         */

        public static function draw(target:Graphics, CX:Number, CY:Number, scale:Number, m:Number, n1:Number, n2:Number, n3:Number, step:Number = .001, a:Number = 1, b:Number = 1):void
        {
            const PI_2:Number = Math.PI * 2;
            var fpX:Number;
            var fpY:Number;
            var u:Number = 0;
            var r:Number;
            var x:Number;
            var y:Number;            

            while (u < PI_2)
            {
                x = Math.pow(Math.abs(Math.cos(m * u / 4) / a), n2);
                y = Math.pow(Math.abs(Math.sin(m * u / 4) / b), n3);
                r = Math.pow(x + y, -1 / n1);               

                // Convert to Cartesian coordinates for drawing.
                x = r * Math.cos(u) * scale + CX;
                y = r * Math.sin(u) * scale + CY;
                
                // draw
                if (u == 0)
                {
                    fpX = x;
                    fpY = y;
                    target.moveTo(x, y);
                }
                else
                {
                    target.lineTo(x, y);
                }
                // inc
                u += step;
            }
            // always close the shape
            target.lineTo(fpX, fpY);
        }   
}
