/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/G3aV
 */

package {
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class FlashTest extends Sprite {
        
        public var _width:int = 465;
        public var _height:int = 465;
        
        public var mapSerialArray:Vector.<Vector.<int>> = new Vector.<Vector.<int>>(); //for performance
        public var neighbors:Array = [];
        
        public var mapSize:int = 6;
        public var map:Vector.<Vector.<Vector.<HexCell>>> = new Vector.<Vector.<Vector.<HexCell>>>(2 * mapSize + 1);
        public var edgeLength:int = 20;
        public var edgeW:int;
        public var edgeH:int;
        
        public var cellSprite:Sprite;
        
        public var blockColorArray:Array = [0xcc0000, 0x00cc00, 0x0000cc, 0xcccc00, 0x00cccc, 0xcc00cc];
        
        public var matchingShape:Shape;
        public var refreshButton:PushButton;
        
        public function FlashTest() {
            // write as3 code here..
            addChild(new Bitmap(new BitmapData(465, 465, false, 0x292929)));
            
            var i:int;
            for (i = 0; i < 6; i += 1)
            {
                neighbors[i] = [];
            }
            neighbors[0] = [+1, -1, 0];
            neighbors[1] = [+1, 0, -1];
            neighbors[2] = [0, +1, -1];
            neighbors[3] = [-1, +1, 0];
            neighbors[4] = [-1, 0, +1];
            neighbors[5] = [0, -1, +1];
            
            edgeW = edgeLength * 3 / 2;
            edgeH = edgeLength * Math.sqrt(3) / 2;
            
            
            cellSprite = new Sprite();
            addChild(cellSprite);
            
            initMap(map);
            drawMap(map);
            
            matchingShape = new Shape();
            addChild(matchingShape);
            
            findMatch();
            
            refreshButton = new PushButton(this, 465 - 110, 10, "Refresh", onRefresh);
        }
        
        private function onRefresh(e:Event):void
        {
            var i:int;
            var hexCell:HexCell;
            
            matchingShape.graphics.clear();
            
            for (i = 0; i < mapSerialArray.length; i += 1)
            {
                hexCell = map[mapSerialArray[i][0] + mapSize][mapSerialArray[i][1] + mapSize][mapSerialArray[i][2] + mapSize];
                hexCell._color = Math.random() * blockColorArray.length;
                hexCell.drawCell(hexCell._G.graphics, blockColorArray[hexCell._color], true);
            }
            
            findMatch();
        }
        
        private function findMatch():void
        {
            var i:int;
            var hexCell:HexCell;
            var hexCell2:HexCell;
            var nowX:int;
            var nowY:int;
            var nowZ:int;
            var k:int;
            
            for (i = 0; i < mapSerialArray.length; i += 1)
            {
                hexCell = map[mapSerialArray[i][0] + mapSize][mapSerialArray[i][1] + mapSize][mapSerialArray[i][2] + mapSize];
                
                for (k = 0; k < 6; k += 1)
                {
                    nowX = mapSerialArray[i][0] + neighbors[k][0];
                    nowY = mapSerialArray[i][1] + neighbors[k][1];
                    nowZ = mapSerialArray[i][2] + neighbors[k][2];
                    
                    if (calcBoundary(nowX, nowY, nowZ) == true)
                    {
                        hexCell2 = map[nowX + mapSize][nowY + mapSize][nowZ + mapSize];
                        if (hexCell2._color == hexCell._color)
                        {
                            
                            matchingShape.graphics.lineStyle(3, 0x000000, 0.7);
                            matchingShape.graphics.moveTo(hexCell.x, hexCell.y);
                            
                            //matchingShape.graphics.lineTo(hexCell2.x, hexCell2.y);
                            
                            while (true)
                            {
                                nowX += neighbors[k][0];
                                nowY += neighbors[k][1];
                                nowZ += neighbors[k][2];
                                
                                if (calcBoundary(nowX, nowY, nowZ) == true)
                                {
                                    hexCell2 = map[nowX + mapSize][nowY + mapSize][nowZ + mapSize];
                                    if (hexCell2._color == hexCell._color)
                                    {
                                        matchingShape.graphics.lineTo(hexCell2.x, hexCell2.y);
                                    }
                                    else
                                    {
                                        break;
                                    }
                                }
                                else
                                {
                                    break;
                                }
                            }
                        }
                    }
                    
                }
                
            }
        }
        
        private function onHexCellMouseOver(e:MouseEvent):void
        {
            var hexCell:HexCell = e.target.parent as HexCell;
            hexCell.alpha = 0.5;
        }
        
        private function onHexCellMouseOut(e:MouseEvent):void
        {
            var hexCell:HexCell = e.target.parent as HexCell;
            hexCell.alpha = 1;
        }
        
        private function drawMap(map:Vector.<Vector.<Vector.<HexCell>>>):void
        {
            var i:int;
            var hexCell:HexCell;
            
            for (i = 0; i < mapSerialArray.length; i += 1)
            {
                hexCell = map[mapSerialArray[i][0] + mapSize][mapSerialArray[i][1] + mapSize][mapSerialArray[i][2] + mapSize];
                
                hexCell._color = Math.random() * blockColorArray.length;
                hexCell.drawCell(hexCell._G.graphics, blockColorArray[hexCell._color], true);
                hexCell.drawCell(hexCell._GLine.graphics, 0xffffff, false);
                
                
                
                hexCell.x = _width / 2 + hexCell._x * edgeW;
                hexCell.y = _height / 2 + (0 - hexCell._y + hexCell._z) * edgeH;
                cellSprite.addChild(hexCell);
            }
            
            //cellSprite.addEventListener(MouseEvent.CLICK, onHexCellClick, true);
            cellSprite.addEventListener(MouseEvent.MOUSE_OVER, onHexCellMouseOver, true);
            cellSprite.addEventListener(MouseEvent.MOUSE_OUT, onHexCellMouseOut, true);
            
            
            
        }
        
        private function initMap(map:Vector.<Vector.<Vector.<HexCell>>>):void
        {
            var i:int, j:int, k:int;
            var hexCell:HexCell;
            var serialIndex:int = 0;
            
            for (i = -1 * mapSize; i < mapSize + 1; i += 1)
            {
                map[i+mapSize] = new Vector.<Vector.<HexCell>>(2 * mapSize + 1);
                for (j = -1 * mapSize; j < mapSize + 1; j += 1)
                {
                    map[i+mapSize][j+mapSize] = new Vector.<HexCell>(2 * mapSize + 1);
                    for (k = -1 * mapSize; k < mapSize + 1; k += 1)
                    {
                        if (i + j + k == 0)
                        {
                            hexCell = new HexCell(i, j, k, edgeLength);
                            cellSprite.addChild(hexCell);
                            
                            map[i + mapSize][j + mapSize][k + mapSize] = hexCell;
                            
                            mapSerialArray[serialIndex] = new Vector.<int>(3);
                            mapSerialArray[serialIndex][0] = i;
                            mapSerialArray[serialIndex][1] = j;
                            mapSerialArray[serialIndex][2] = k;
                            serialIndex += 1;
                        }
                        
                    }
                }
            }
            
        }
        
        private function calcBoundary(_x:int, _y:int, _z:int):Boolean
        {
            if (_x + _y + _z == 0 &&
                _x >= -mapSize && _x <= mapSize &&
                _y >= -mapSize && _y <= mapSize &&
                _z >= -mapSize && _z <= mapSize)
                {
                    return true;
                }
                
            return false;
        }
    }
}

Class 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.geom.ColorTransform;
    
    /**
     * ...
     * @author ypc
     */
    class HexCell extends Sprite
    {
        public var _x:int;
        public var _y:int;
        public var _z:int;
        public var _G:Sprite;
        public var _GLine:Sprite;
        public var edgeLength:int = 20;
        public var _color:int = -1;
        public var _hasPawn:Boolean = false;
        
        public function HexCell(_x:int, _y:int, _z:int, edge:int=20) 
        {
            this._x = _x;
            this._y = _y;
            this._z = _z;
            this.edgeLength = edge;
            
            _G = new Sprite();
            _GLine = new Sprite();
            
            addChild(_G);
            addChild(_GLine);
            
        }
        
        public function drawCell(_G:Graphics, color:uint, fill:Boolean):void
        {
            var angle:Number;
            
            _G.clear();
            if (fill == true)
            {
                _G.beginFill(color, 0.8);
                //_G.beginFill(color);
            }
            else
            {
                _G.lineStyle(1, color);
            }
            
            
            _G.moveTo(edgeLength, 0);
            for (var i:int = 1; i <= 6; i += 1)
            {
                angle = 2 * Math.PI / 6 * i;
                _G.lineTo(edgeLength * Math.cos(angle), edgeLength * Math.sin(angle));
            }
            
            if (fill == true)
            {
                _G.endFill();
            }
            
            
        }
        
    }

}