/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/FrPs
 */

// forked from yd_niku's ExtentionExample
package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var ball:Sprite= new BallSprite(0xFF9933);
            ball.x = 50;
            ball.y = 50
            addChild( ball );
            
            var moveBall:Sprite= new MoveBallSprite (0x000066);
            moveBall.x = 100;
            moveBall.y = 50
            addChild( moveBall );
            
            var dropBall:Sprite= new DropBallSprite(0x006600);
            dropBall.x = 150;
            dropBall.y = 50
            addChild( dropBall );
            
            var mouseTraceBall:Sprite= new MouseTracerBallSprite ( 0xFF3300 );
            mouseTraceBall.x = 200;
            mouseTraceBall.y = 50;
            addChild( mouseTraceBall );
            
        }
    }
}

import flash.display.*;
import flash.events.*;

class BallSprite extends Sprite {
    public function BallSprite( color:uint ){
        super();
        
        graphics.beginFill(color);
        graphics.drawCircle( 0, 0, 10 );
        graphics.endFill();
    }
}
class MoveBallSprite extends BallSprite {
    public var velocityX:Number = 1;
    public var velocityY:Number = 1;
    public function MoveBallSprite( color:uint ) {
        super( color );
        addEventListener( Event.ENTER_FRAME, updatePosition );
    }
    private function updatePosition( e:Event ):void {
        x += velocityX;
        y += velocityY;
    }
}

class DropBallSprite extends MoveBallSprite{
    public var gravity:Number = 0.6;
    public function DropBallSprite ( color:uint ) {
        super( color );
        addEventListener( Event.ENTER_FRAME, updateVelocity );
    }
    private function updateVelocity ( e:Event ):void {
        velocityY += gravity;
    }
}

class MouseTracerBallSprite extends MoveBallSprite{
    public function MouseTracerBallSprite ( color:uint ) {
        super( color );
        addEventListener( Event.ENTER_FRAME, updateVelocity );
    }
    private function updateVelocity ( e:Event ):void {
        velocityX = ( root.mouseX - x ) * 0.1;
        velocityY = ( root.mouseY - y ) * 0.1;
    }
}

