/**
 * Copyright yabuchany ( http://wonderfl.net/user/yabuchany )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/FgDW
 */

// forked from yabuchany's ColorCellophane
// forked from yabuchany's BeatTimerとBetweenAS3の練習
// http://wonderfl.net/c/3abIの「VJ風にしてみた forked from: モアレっぽい感じ」を参考にBeatTimerとBetweenAS3の練習
// timerHandlerの中身の部分をBetweenAS3の練習用に変更しました。
// timerHandlerの中身の部分をhttp://wonderfl.net/c/8muPの「四畳半神話大系的な何か」を参考に変更しました。
// 音楽はhttp://level0.kayac.com/2010/09/wonderflatractor.phpの「WonderflでAtractorと音楽で遊んでみた」の記事を参考にhttp://freemusicarchive.org/で探した曲です。
     /*
     * Free Music Archive:Lee_Rosevere_-_01_-_Christmas_Eve_At_Midnight_Small_Town_Square
     * http://creativecommons.org/licenses/by-nc-nd/3.0/
     */
package  {
    import flash.display.*;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(backgroundColor="0", frameRate="60", width="465", height="465")]

    public class ColorCellophane2 extends Sprite{
        private var _phase:int;
        private var _gain:int;
        private var _sound:Sound;
        private var _soundChannel:SoundChannel;
        private var _beatTimer:BeatTimer;
        private var _isOnBeat:Boolean;        
        private const EZ:Number = .6; //速度が変わるよ！
        private var _tw:ITween;
        private var _container:Sprite = new Sprite();
        private var MAX:int = 10;
        private var _cnt:int = 0;
        private var _topBox:Box;
        private var _lastBox:Box;

        
        //
        private var twArray:Array = [];
        
        
        public function ColorCellophane2() {
            Wonderfl.capture_delay(30);
            addEventListener(Event.ENTER_FRAME, timerHandler);

            _beatTimer = new BeatTimer();        
            _sound = new Sound();

            _sound.load(new URLRequest("http://yabuchany.com/blog/wp-content/uploads/2010/12/src/Lee_Rosevere_-_01_-_Christmas_Eve_At_Midnight_Small_Town_Square.mp3"));
            _sound.addEventListener(Event.COMPLETE, loadCompleteHadler);
        };
        
        private function loadCompleteHadler(e:Event):void {
            _sound.removeEventListener(Event.COMPLETE, loadCompleteHadler);
            soundStart();
        }
        
        private function soundStart():void {
            _soundChannel = _sound.play(0);
            _beatTimer.start(120);
            _soundChannel.addEventListener(Event.SOUND_COMPLETE, soundCompleteHandler );
        }
        
        private function soundCompleteHandler(e:Event):void {
            
            removeEventListener(Event.ENTER_FRAME, timerHandler);
            removeChild(_container);
            _soundChannel.removeEventListener(Event.SOUND_COMPLETE, soundCompleteHandler );
        }
        private function timerHandler(e:Event):void {
            
            _beatTimer.update();
            if ((_beatTimer.beatPosition | 0) % 4 == 0) {
                if (!_isOnBeat) {
                    var w:Number = Math.random()*150+50;
                    var h:Number = Math.random()*150+50;
                    var box:Box = new Box(w/2,h/2,w,h);
                    _topBox = box;
                    _lastBox = box;
            
                    //_container.rotationZ = Math.random() * 360 - 180;    // コメントアウト
                    _container.x = stage.stageWidth/2;
                    _container.y = stage.stageHeight/2;
                
            
                    addChild(_container);
                    box.x = _container.x + w / 10;
                    _container.addChild(box);
            
                    _tw = BetweenAS3.parallel(
                    BetweenAS3.tween(box,{width:box.width},{width:0},EZ,Quint.easeInOut),
                    BetweenAS3.tween(box, { height:box.height }, { height:0 }, EZ, Quint.easeInOut));
                    
                    _tw.addEventListener(TweenEvent.COMPLETE,compTween);
                    _tw.play();
                    
                    // 角度
                    twArray.push(BetweenAS3.tween(_container,{rotationZ:Math.random() * 180 - 90},null,EZ,Quint.easeInOut),
                    BetweenAS3.tween(_container,{z:Math.random() * 1000},null,EZ,Quint.easeInOut));
                    
                }
            }else {
                if(Math.random() > 0.5)    _isOnBeat = false;
            }
        }
        private function compTween(e:TweenEvent):void
        {
            _tw.removeEventListener(TweenEvent.COMPLETE,compTween);
            _cnt++;
            trace("_cnt"+_cnt);
            
            var twArray:Array = [];
            var w:Number = Math.random()*150 + 50;
            var h:Number = Math.random()*150 + 50;
            
            var box:Box = _topBox;
            //途中のbox
            while(box.linkBox){
                if(_lastBox.width>_lastBox.height){
                    twArray.push(BetweenAS3.parallel(
                        BetweenAS3.tween(box,{x:box.x - _lastBox.width},null,EZ,Quint.easeInOut),
                        BetweenAS3.tween(box,{y:box.y - _lastBox.height},null,EZ,Quint.easeInOut)
                    ));
                }else{
                    twArray.push(BetweenAS3.parallel(
                        BetweenAS3.tween(box,{x:box.x -_lastBox.x},null,EZ,Quint.easeInOut),
                        BetweenAS3.tween(box,{y:box.y -_lastBox.y},null,EZ,Quint.easeInOut)
                    ));
                }
                box = box.linkBox;
                box.alpha = 0.05;
                
            }
            
            //最後のboxと新しいbox
            var box_new:Box = new Box( -4, -4, w, h);
            box_new.x = box.width / 2;
            box_new.y = box.height;
            _container.addChild(box_new);
            
            if(box.width>box.height){
                twArray.push(BetweenAS3.parallel(
                    BetweenAS3.tween(box,{x:box.x - box.width},null,EZ,Quint.easeInOut),
                    BetweenAS3.tween(box,{y:box.y - box.height},null,EZ,Quint.easeInOut),
                    BetweenAS3.tween(box_new,{x:0},{x:box.width},EZ,Quint.easeInOut),
                    BetweenAS3.tween(box_new,{y:0},{y:box.height},EZ,Quint.easeInOut)
                ));
            }else{
                twArray.push(BetweenAS3.parallel(
                    BetweenAS3.tween(box,{x:box.x + box.width},null,EZ,Quint.easeInOut),
                    BetweenAS3.tween(box,{y:box.y + box.height},null,EZ,Quint.easeInOut),
                    BetweenAS3.tween(box_new,{x:0},{x:box.width},EZ,Quint.easeInOut),
                    BetweenAS3.tween(box_new,{y:0},{y:box.height},EZ,Quint.easeInOut)
                ));
            }
            twArray.push(BetweenAS3.parallel(
                BetweenAS3.tween(box_new,{width:w},{width:0},EZ,Quint.easeInOut),
                BetweenAS3.tween(box_new,{height:h},{height:0},EZ,Quint.easeInOut)));
            
            //新しい配列をリストに追加
            box.linkBox = box_new;
            _lastBox = box_new;
            //5個以上になったら古いの消すよ
            if (_cnt > 5) {
                trace("if文");
                var bufBox:Box = _topBox.linkBox;
                _container.removeChild(_topBox);
                _topBox = bufBox;
                
                _cnt = 0;
            }
            //ちょいちょい角度を変えてみる
            if(_cnt % 3 == 0){
                twArray.push(BetweenAS3.tween(_container,{rotationZ:Math.random() * 360 - 180},null,.2,Quint.easeInOut),
                BetweenAS3.tween(_container,{z:Math.random() * 800},3,EZ,Quint.easeInOut));
                _cnt = 0;
            }
            _tw = BetweenAS3.parallelTweens( twArray );
            _tw.addEventListener(TweenEvent.COMPLETE,compTween);
            
            _tw.play();
        }
    }
}

import flash.display.Sprite;
import flash.utils.getTimer;

class Box extends Sprite
{
    public var linkBox:Box = null;
    public function Box(x:Number,y:Number,w:Number,h:Number):void
    {
        var lineColor:uint = 0xFFFFFF;
        var fillColor:uint = 0xFFFFFF*Math.random();
        graphics.lineStyle(2,lineColor,1,true,"normal","square");
        graphics.beginFill(fillColor,1);
        graphics.drawRoundRect(-4, -4, w, h, 8, 8);
        //graphics.drawCircle(0, 0, 8);
        graphics.endFill();
    }
}



class BeatTimer
{
    public function BeatTimer()
    {
    }
    
    private var _bpm:Number;
    private var _startTime:uint;
    private var _beatPosition:Number;
    private var _phase:Number;
    private var _isOnBeat:Boolean = false;
    
    public function get bpm():Number
    {
        return _bpm;
    }
    
    public function get beatPosition():Number
    {
        return _beatPosition;
    }
    
    public function get phase():Number
    {
        return _phase;
    }
    
    public function get isOnBeat():Boolean
    {
        return _isOnBeat;
    }
    
    public function start(bpm:Number):void
    {
        _bpm = bpm;
        _startTime = getTimer();
        update();
    }
    
    public function update():void
    {
        var currentTime:uint = getTimer();
        var beatInterval:Number = (60 * 1000) / _bpm;
        var oldPosition:Number = _beatPosition;
        
        _beatPosition = (currentTime - _startTime) / beatInterval;
        _phase = _beatPosition - int(_beatPosition);
        _isOnBeat = int(oldPosition) != int(_beatPosition);
    }
}