/**
 * Copyright beinteractive ( http://wonderfl.net/user/beinteractive )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Eoxj
 */

package
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.easing.*;
	
	public class Sample extends Sprite
	{
		public function Sample()
		{
			var box1:Box = addNewBox(100);
			var box2:Box = addNewBox(200);
			var box3:Box = addNewBox(300);
			
			// Create a tween
			_t = BetweenAS3.parallel(
				BetweenAS3.physical(box1, {x: 400}, null, Physical.uniform(12.0)),
				BetweenAS3.physical(box2, {x: 400}, null, Physical.accelerate(2.0, 4.0)),
				BetweenAS3.physical(box3, {x: 400}, null, Physical.exponential(0.2))
			);
			
			// Set to be never stop
			_t.stopOnComplete = false;
			
			// Start the tween
			_t.play();
			
			// MouseUp listener
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}
		
		private var _t:ITween;
		
		private function mouseUpHandler(e:MouseEvent):void
		{
			// Stop the tween if playing
			// Start the tween if stopping
			_t.togglePause();
			
			// Note: You can use gotoAndPlay(time) or gotoAndStop(time) too.
		}
		
		private function addNewBox(y:Number):Box
		{
			var box:Box = new Box();
			box.x = 20;
			box.y = y;
			addChild(box);
			return box;
		}
	}
}

import flash.display.Sprite;

internal class Box extends Sprite
{
	public function Box()
	{
		graphics.beginFill(0);
		graphics.drawRect(-10, -10, 20, 20);
		graphics.endFill();
	}
}