/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/EoYC
 */

// forked from codeonwort's Fast CUTS
// forked from christian's CUTS
// perlin noise study for speed-up the effect
package
{
    import flash.geom.*;
    import flash.filters.*;
    import flash.display.*;
    import flash.events.Event;
    import flash.utils.getTimer;
    import net.hires.debug.Stats

    [ SWF (width = '465', height = '465', backgroundColor = '0xFFFFFF', frameRate = '30') ]
    public class CUTS extends Sprite
    {
        private var e : BitmapData = new BitmapData (465, 465, true, 0x00), s : BitmapData = e.clone ();
        private var c : ColorTransform = new ColorTransform (1, 1, 1, 0.99);
        private var b : BlurFilter = new BlurFilter (2, 2, 5);
        private var o : Array = [new Point (), new Point ()];
        private var t : Number;
        
        private var zero:Point = new Point(0, 0)
        private var mat:Matrix = new Matrix
        private var halfRect:Rectangle = new Rectangle(0, 0, e.width, e.height)
        private var octave1:BitmapData
        private var octave2:BitmapData
        
        private var original:Boolean = false
        
        public function CUTS ()
        {
            Wonderfl.disable_capture ();
            stage.scaleMode = 'noScale';
            
            octave1 = new BitmapData(e.width*2, e.height*2, true, 0x0)
            octave2 = octave1.clone()
            
            e.perlinNoise(200, 200, 1, 0xAAA, true, true, 7, true)
            octave1.copyPixels(e, e.rect, new Point)
            octave1.copyPixels(octave1, halfRect, new Point(e.width, 0))
            octave1.copyPixels(octave1, halfRect, new Point(0, e.height))
            octave1.copyPixels(octave1, halfRect, new Point(e.width, e.height))
            
            e.perlinNoise(200, 200, 2, 0xAAA, true, true, 7, true)
            octave2.copyPixels(e, e.rect, new Point)
            octave2.copyPixels(octave2, halfRect, new Point(e.width, 0))
            octave2.copyPixels(octave2, halfRect, new Point(0, e.height))
            octave2.copyPixels(octave2, halfRect, new Point(e.width, e.height))
            octave2.draw(octave1, null, null, 'subtract')
            octave2.threshold(octave2, octave2.rect, new Point, '==', 0xff000000)
            
            addChild (new Bitmap (s))
            addChild(new Stats)

            addEventListener (Event.ENTER_FRAME, render);
            stage.addEventListener('mouseDown', toggleRenderMode)
        }
        
        private function toggleRenderMode($:Event):void {
            s.fillRect(s.rect, 0x0)
            original = !original
        }

        private function render ($ : Event = null) : void
        {
            t = getTimer ();
            
            if(original){
                o[1].x =- (o[0].x = Math.sin (t * 0.00005) * 250);
                o[1].y =- (o[0].y = Math.cos (t * 0.00005) * 250);
                e.perlinNoise(200, 200, 2, 0xAAA, true, true, 7, true, o)
            }else{
                o[1].x =- (o[0].x = Math.sin (t * 0.0005) * 250);
                o[1].y =- (o[0].y = Math.cos (t * 0.0005) * 250);
                halfRect.x = -o[0].x % e.width
                halfRect.y = -o[0].y % e.height
                while(halfRect.x < 0) halfRect.x += e.width
                while(halfRect.y < 0) halfRect.y += e.height
                e.copyPixels(octave1, halfRect, zero)
                
                halfRect.x = -o[1].x % e.width
                halfRect.y = -o[1].y % e.height
                while(halfRect.x < 0) halfRect.x += e.width
                while(halfRect.y < 0) halfRect.y += e.height
                mat.identity()
                mat.translate(-halfRect.x, -halfRect.y)
                e.draw(octave2, mat, null, 'add')
            }
            
            e.threshold (e, e.rect, e.rect.topLeft, '!=', 0xFF808080, 0x00000000);
            e.applyFilter (e, e.rect, e.rect.topLeft, b);
            
            e.draw (e, null, null, BlendMode.ADD, null, true);
            e.draw (e, null, null, BlendMode.ADD, null, true);
            e.threshold (e, e.rect, e.rect.topLeft, '==', 0xFFFFFFFF, 0x00000000);
            
            s.colorTransform (s.rect, c);
            s.copyPixels (e, e.rect, e.rect.topLeft, null, null, true);
        }
    }
}