/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/EjMA
 */

// forked from spanvega's MANDRAKE # 1
// forked from saruzaru's Animated Sunflower Seed Spiral remix
// forked from lespleen's forked from: Animated Sunflower Seed Spiral
// forked from Quasimondo's Animated Sunflower Seed Spiral
// forked from Quasimondo's Sunflower Seed Spiral

package
{
    import flash.events.Event;
    import flash.events.MouseEvent;

    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;

    import flash.utils.ByteArray;
    import flash.net.FileReference;

    import flash.filters.BlurFilter;

    import frocessing.color.ColorHSV;

    import com.adobe.images.JPGEncoder;
    import com.adobe.images.PNGEncoder;

    import com.bit101.components.Knob;
    import com.bit101.components.Label;
    import com.bit101.components.CheckBox;
    import com.bit101.components.PushButton;
    import com.bit101.components.RadioButton;
    import com.bit101.components.NumericStepper;

    /*
    * -> PRESS CANCEL TO CLEAR BITMAPDATA
    * -> CLICK PANEL BACKGROUND TO DRAG IT
    * -> USE MOUSE WHEEL TO HIDE | SHOW IT
    * -> CLICK OUTSIDE PANEL TO LOCK OR UNLOCK MOUSE
    * -> PRESS CAPTURE TO EXPORT IMAGE AS JPG OR PNG
    */

    [SWF(width = '465', height = '465', frameRate='25', backgroundColor='0xFFFFFF')]
   
    public class MANDRAKE extends Sprite
    {    
        private var color : ColorHSV = new ColorHSV (225);

        private var spiral_pixels  : uint = 4500;
        private var spiral_radius  : uint = 1;
        private var spiral_padding : uint = 4;

        private var spiral_blurX : uint = 3;
        private var spiral_blurY : uint = 3;

        private var offset : Number = 0;

        private var export_type : String;
        private var chLock : CheckBox;
        private var onLock : Boolean;
        private var zoom : Number;

        private var pixels : BitmapData;
        private var spiral : Bitmap;
        private var panel : Sprite;

        private var stageW : Number;
        private var stageH : Number;
        private var appliX : Number;
        private var appliY : Number;


        public function MANDRAKE () 
        {
            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        }

        private function init() : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {
                removeEventListener (Event.ADDED_TO_STAGE, init);
            }

            stageH = stage.stageHeight;
            stageW = stage.stageWidth;

            stage.scaleMode = 'noScale';
            stage.align = 'TL';

            appliX = stageW /2;
            appliY = stageH /2;

            stage.addEventListener
            (
                MouseEvent.MOUSE_WHEEL,
                onPanelDisplay
            );

            stage.addEventListener
            (
                MouseEvent.CLICK,
                onMouseLock
            );

            //

            spiral = new Bitmap ();

            addChild (spiral);

            pixels = new BitmapData
            (
                stageW, stageH, false, 0
            );

            // 

            onPanelBuild ();

            //

            stage.addEventListener (Event.ENTER_FRAME, onRender);                   
        }

        private function onRender (e : Event) : void
        {
            var p1 : Number = mouseX - appliX;
            var p2 : Number = mouseY - appliY;

            zoom = Math.sqrt (p1 * p1 + p2 * p2);

            //

            var cc : uint = color.value;

            color.h += 0.75;

            //

            var offset_d : Number = (offset += 0.0015) + (onLock ? 0 : zoom);

            var divergence : Number = (137.50776 + offset_d) / 180 * Math.PI;

            //

            pixels.lock ();

            pixels.applyFilter (pixels, pixels.rect, new Point(), new BlurFilter (spiral_blurX, spiral_blurY));

            for (var i : uint = 0; i < spiral_pixels; i++)
            {
                var d : Number = (spiral_radius + spiral_padding) * Math.sqrt(i) - spiral_radius * 0.3;
                var a : Number = divergence * i;

                pixels.setPixel
                (
                    appliX + Math.cos(a) * d, appliY + Math.sin (a) * d, cc
                );
            }

            pixels.unlock ();

            //

            spiral.bitmapData = pixels;
        }

        //

        private function onPanelBuild () : void
        {
            panel = new Sprite ();
            panel.x = 10;
            panel.y = 10;
    
            var rect : Sprite = new Sprite ();
            rect.graphics.lineStyle (1, 0xFFFFFF);
            rect.graphics.beginFill (0xFFFFFF, 0.75);
            rect.graphics.drawRect (0, 0, 292, 78);
            rect.graphics.endFill ();
            
            rect.addEventListener
            (
                MouseEvent.MOUSE_DOWN, onDragStart
            );
            rect.addEventListener
            (
                MouseEvent.MOUSE_UP,   onDragStop
            );

            panel.addChild (rect);

            //

            chLock = new CheckBox (panel, 5, 65, '', onMouseLock);
            chLock.enabled = false;

            var lb_lock : Label = new Label (panel, 17, 61, 'MOUSE LOCK');

            //

            var btn_clear : PushButton = new PushButton (panel, 5, 44, 'CANCEL', onDataCancel);
            btn_clear.height = 16;
            btn_clear.width = 71;

            var btn_capture : PushButton = new PushButton (panel, 5, 22, 'CAPTURE', onDataCapture);
            btn_capture.height = 16;
            btn_capture.width = 71;

            //

            var rb_png : RadioButton = new RadioButton (panel, 5, 5, 'PNG', true, onExportType);

            var rb_jpg : RadioButton = new RadioButton (panel, 46, 5, 'JPG', false, onExportType);

            export_type = rb_png.label;

            //
            
            var line : Sprite = new Sprite ();
            line.graphics.lineStyle (1, 0xFFFFFF);
            line.graphics.moveTo (85, 7);
            line.graphics.lineTo (85, 74);
            
            
            panel.addChild (line);
            
            //

            var kb_pixels : Knob = new Knob (panel, 95, 1, 'PIXELS', onPixels);
            kb_pixels.labelPrecision = 0;
            kb_pixels.maximum = 27500;
            kb_pixels.minimum = 500;
            kb_pixels.value = spiral_pixels;

            //

            var kb_radius : Knob = new Knob (panel, 142, 1, 'RADIUS', onRadius);
            kb_radius.labelPrecision = 0;
            kb_radius.maximum = 15;
            kb_radius.minimum = 1;
            kb_radius.value = spiral_radius;
            
            //

            var kb_padding : Knob = new Knob (panel, 189, 1, 'PADDING', onPadding);
            kb_padding.labelPrecision = 0;
            kb_padding.maximum = 15;
            kb_padding.minimum = 1;
            kb_padding.value = spiral_padding;

            //

            var lb_blurX : Label = new Label (panel, 235, 1, 'BLUR X');

            var ns_blurX : NumericStepper = new NumericStepper (panel, 238, 22, onBlurX);
            ns_blurX.width = 50;
            ns_blurX.maximum = 10;
            ns_blurX.minimum = 0;
            ns_blurX.value = spiral_blurX;

            var lb_blurY : Label = new Label (panel, 235, 61, 'BLUR Y');

            var ns_blurY : NumericStepper = new NumericStepper (panel, 238, 44, onBlurY);
            ns_blurY.width = 50;
            ns_blurY.maximum = 10;
            ns_blurY.minimum = 0;
            ns_blurY.value = spiral_blurY;

            //

            addChild (panel);
        }

        // --o COMPONENTS HANDLERS

        private function onPixels (e : Event) : void
        {
            spiral_pixels = e.target.value;
        }

        private function onRadius (e : Event) : void
        {
            spiral_radius = e.target.value;
        }

        private function onPadding (e : Event) : void
        {
            spiral_padding = e.target.value;
        }

        private function onBlurX (e : Event) : void
        {
            spiral_blurX = e.target.value;
        }

        private function onBlurY (e : Event) : void
        {
            spiral_blurY = e.target.value;
        }

        private function onDragStart (e : MouseEvent) : void
        {
            panel.startDrag ();

            onLock = true;
        }

        private function onDragStop (e : MouseEvent) : void
        {
            panel.stopDrag ();

            onLock = chLock.selected;
        }

        private function onMouseLock (e : MouseEvent) : void
        {
            if (! panel.hitTestPoint(mouseX, mouseY))
            {
                chLock.selected = (onLock = !onLock);

                offset += zoom;
            }
        }

        private function onDataCancel (e : MouseEvent) : void
        {
            pixels = new BitmapData
            (
                stageW, stageH, false, 0
            );
        }
        
        private function onExportType (e : Event) : void
        {
            export_type = e.target.label;
        }

        private function onDataCapture (e : Event) : void
        {
            var img_bytes : ByteArray;

            switch (export_type)
            {
                case 'PNG' :  img_bytes = PNGEncoder.encode (pixels);
                    break;
                case 'JPG' :  var coder : JPGEncoder = new JPGEncoder (100);
                              img_bytes = coder.encode (pixels);
            }

            new FileReference().save
            (
                img_bytes, 'MANDRAKE#1.' + export_type
            );
        }

        private function onPanelDisplay (e : MouseEvent) : void
        {
            panel.visible = !panel.visible;
        }
    }
}