/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/EI5c
 */

package 

{

    

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.events.MouseEvent;

    import flash.events.TimerEvent;

    import flash.geom.Point;

    import flash.utils.Timer;

    /**

     * 

     * 

     * 

     * 参考

     * https://ja.wikipedia.org/wiki/%E3%83%99%E3%82%B8%E3%82%A7%E6%9B%B2%E7%B7%9A

     * http://wonderfl.net/c/oyQM

     * 

     * ...

     * @author umhr

     */

    public class Conteiner extends Sprite 

    {

        private var _timer:Timer = new Timer(100, 20);

        private var _step1List:Array/*Point*/ = [];

        public function Conteiner() 

        {

            init();

        }

        private function init():void 

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }



        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            

            stage.addEventListener(MouseEvent.CLICK, stage_click);

            _timer.addEventListener(TimerEvent.TIMER, timer_timer);

            

            stage_click(null);

        }

        

        private function timer_timer(e:TimerEvent):void 

        {

            calc(_step1List, _timer.currentCount);

        }

        

        private function stage_click(e:MouseEvent):void 

        {

            setPoints();

            _timer.reset();

            _timer.start();

        }

        

        private function calc(step1List:Array/*Point*/, partition:int):void 

        {

            graphics.clear();

            

            drawLine(step1List, 0x00FF00, 0.3);

            

            var step4List:Array/*Point*/ = [];

            step4List[0] = step1List[0];

            

            var n:int = partition;

            for (var i:int = 1; i <= n; i++) 

            {

                var ratio:Number = 1 - (i / (n + 1));

                

                var step2List:Array/*Point*/ = [];

                step2List[0] = Point.interpolate(step1List[0], step1List[1], ratio);

                step2List[1] = Point.interpolate(step1List[1], step1List[2], ratio);

                step2List[2] = Point.interpolate(step1List[2], step1List[3], ratio);

                drawLine(step2List, 0xFF0000, 0.3);

                

                var step3List:Array/*Point*/ = [];

                step3List[0] = Point.interpolate(step2List[0], step2List[1], ratio);

                step3List[1] = Point.interpolate(step2List[1], step2List[2], ratio);

                drawLine(step3List, 0xFFFF00, 0.3);

                

                step4List[i] = Point.interpolate(step3List[0], step3List[1], ratio);

            }

            

            step4List.push(step1List[3]);

            drawLine(step4List, 0x0000FF, 1);

            

        }

        

        private function drawLine(pointList:Array/*Point*/, rgb:int, alpha:Number):void 

        {

            graphics.lineStyle(0, rgb, alpha);

            

            var n:int = pointList.length;

            for (var i:int = 0; i < n; i++) 

            {

                if (i == 0) {

                    graphics.moveTo(pointList[i].x, pointList[i].y);

                }else {

                    graphics.lineTo(pointList[i].x, pointList[i].y);

                }

            }

        }

        

        

        private function setPoints():void 

        {

            var n:int = 4;

            for (var i:int = 0; i < n; i++) 

            {

                var point:Point = new Point();

                point.x = Math.random() * stage.stageWidth;

                point.y = Math.random() * stage.stageHeight;

                _step1List[i] = point;

            }

        }

    }

    

}