/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ECva
 */

// forked from clockmaker's forked from: スムージング
// forked from ProjectNya's スムージング
////////////////////////////////////////////////////////////////////////////////
// スムージング
////////////////////////////////////////////////////////////////////////////////

package {
    import flash.events.MouseEvent;

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
     import flash.display.StageQuality;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var loader:Loader;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var filePath:String = "3/30/3017/3017fcecb780512f5c2b28596dbf9d0b43bd2f87";
        private static var scale:Number = 0.5;
        private static var CR:String = String.fromCharCode(13);
        private var labelQ:Label;

        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(basePath + filePath), new LoaderContext(true));
        }
        private function complete(evt:Event):void {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, complete);
            //
            var bitmap:Bitmap = Bitmap(loader.content);
            addChild(bitmap);
            bitmap.x = 22;
            bitmap.y = 22;
            //
            var matrix:Matrix = new Matrix();
            matrix.rotate(Math.PI / 10);
            matrix.scale(scale, scale);
            //
            var bitmapData1:BitmapData = new BitmapData(bitmap.width*scale, bitmap.height*scale, false, 0xFF000000);
            bitmapData1.draw(bitmap.bitmapData, matrix, null, null, null, false);
            var bitmap1:Bitmap = new Bitmap(bitmapData1);
            bitmap1.smoothing = false;
            addChild(bitmap1);
            bitmap1.x = 22;
            bitmap1.y = bitmap.y + bitmap1.height + 10;
            var label1:Label = new Label(200, 20);
            addChild(label1);
            label1.textColor = 0x666666;
            label1.text = "BitmapData.draw(): false" + CR + "Bitmap.smoothing: " + bitmap1.smoothing;
            label1.x = bitmap.x;
            label1.y = bitmap1.y + bitmap1.height;
            //
            var bitmapData2:BitmapData = new BitmapData(bitmap.width*scale, bitmap.height*scale, false, 0xFF000000);
            bitmapData2.draw(bitmap.bitmapData, matrix, null, null, null, true);
            var bitmap2:Bitmap = new Bitmap(bitmapData2);
            bitmap2.smoothing = false;
            addChild(bitmap2);
            bitmap2.x = bitmap1.x + bitmap1.width + 10;
            bitmap2.y = bitmap1.y;
            var label2:Label = new Label(200, 20);
            addChild(label2);
            label2.textColor = 0x666666;
            label2.text = "BitmapData.draw(): true" + CR + "Bitmap.smoothing: " + bitmap2.smoothing;
            label2.x = bitmap2.x;
            label2.y = bitmap2.y + bitmap2.height;
            //
            var bitmapData3:BitmapData = new BitmapData(bitmap.width*scale, bitmap.height*scale, false, 0xFF000000);
            bitmapData3.draw(bitmap.bitmapData, matrix, null, null, null, false);
            var bitmap3:Bitmap = new Bitmap(bitmapData3);
            bitmap3.smoothing = true;
            addChild(bitmap3);
            bitmap3.x = 22;
            bitmap3.y = label1.y + label1.height + 10;
            var label3:Label = new Label(200, 20);
            addChild(label3);
            label3.textColor = 0x666666;
            label3.text = "BitmapData.draw(): false" + CR + "Bitmap.smoothing: " + bitmap3.smoothing;
            label3.x = bitmap.x;
            label3.y = bitmap3.y + bitmap3.height;
            
            //
            var bitmapData4:BitmapData = new BitmapData(bitmap.width*scale, bitmap.height*scale, false, 0xFF000000);
            bitmapData4.draw(bitmap.bitmapData, matrix, null, null, null, true);
            var bitmap4:Bitmap = new Bitmap(bitmapData4);
            bitmap4.smoothing = true;
            addChild(bitmap4);
            bitmap4.x = bitmap1.x + bitmap1.width + 10;
            bitmap4.y = bitmap3.y;
            var label4:Label = new Label(200, 20);
            addChild(label4);
            label4.textColor = 0x666666;
            label4.text = "BitmapData.draw(): true" + CR + "Bitmap.smoothing: " + bitmap4.smoothing;
            label4.x = bitmap4.x;
            label4.y = bitmap4.y + bitmap4.height;
            // ちょとじゃまなのでちこくしとく
            bitmap.scaleX = bitmap.scaleY = 0.5;
            
            labelQ = new Label(200, 20);
            addChild(labelQ);
            labelQ.textColor = 0x666666;
            labelQ.x = bitmap.x + bitmap.width + 10;
            labelQ.y = bitmap.y;
            stage.addEventListener(MouseEvent.CLICK, onClickStage);
            onClickStage();
        }
        
        private function onClickStage(e:MouseEvent = null):void
        {
            switch(stage.quality.toLowerCase())
            {
                case StageQuality.BEST:
                    stage.quality = StageQuality.HIGH;
                break;
                case StageQuality.HIGH:
                    stage.quality = StageQuality.MEDIUM;
                break;
                case StageQuality.MEDIUM:
                    stage.quality = StageQuality.LOW;
                break;
                case StageQuality.LOW:
                    stage.quality = StageQuality.BEST;
                break;
            }
            labelQ.text = "stage click to change stage.quality : " + stage.quality;
        }

        
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
