/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/E9Za
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            initEmpty(32,32);
            var i:int; var k:int;
            for(i=0;i<32;i+=1)
            { setTile(Math.random()*mw,Math.random()*mh,1); }
            
            for (i=0;i<32;i+=2)
            for (k=0;k<32;k+=2)
            { setTile(k,i, 1); }
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        public function isKey(k:int):Boolean { return vecKey[k]; }
        
        public var cx:Number = 235;
        public var cy:Number = 235;
      
 
        public var vecGrid:Vector.<int>;
        public var mw:int = 0;         public var mh:int = 0;
        public var cw:Number = 32;     public var ch:Number = 32;

        public function initEmpty(aw:int, ah:int):void
        { mw=aw; mh=ah; vecGrid = new Vector.<int>(aw*ah, false); }

        public function setTile(ax:int, ay:int, t:int):void
        { if (ax<0||ax>=mw||ay<0||ay>=mh) {return;} vecGrid[ay*mw+ax]=t; }

        public function getTile(ax:int, ay:int ):int
        { if (ax<0||ax>=mw||ay<0||ay>=mh) {return 0;}  return vecGrid[ay*mw+ax]; } 
        
        public function isWall(ax:Number,ay:Number):Boolean
        { return getTile(ax/cw,ay/ch) >0; }

       public function onEnter(e:Event):void
       {
           graphics.clear();
           graphics.lineStyle(2, 0);
           
           var wmove:int; wmove=0;
           var ms:Number; ms = 4;
           if (isKey(Keyboard.UP) && isWall(cx,cy-16)==false) { cy-=ms; wmove|=1;}
           if (isKey(Keyboard.DOWN)&& isWall(cx,cy+16)==false) { cy+=ms; wmove|=1; }
           if (isKey(Keyboard.LEFT)&& isWall(cx-16,cy)==false) { cx-=ms; wmove|=2;}
           if (isKey(Keyboard.RIGHT)&& isWall(cx+16,cy)==false) { cx+=ms; wmove|=2; }
           
           
           var ax:Number; var ay:Number;
           ax = Math.floor(cx/32)*32+16;
           ay = Math.floor(cy/32)*32+16;
           
           if (wmove==1) { cx+=(ax-cx)*0.5; }
           if (wmove==2) { cy+=(ay-cy)*0.5; } 
           
           
             var i:int; var k:int; var yt:int; var t:int;
            for (i=0;i<mh;i+=1)
            {
             yt = i * mw;
             for (k=0;k<mw;k+=1)
             {
               t = vecGrid[k+yt];
               if (t<=0) { continue; }
               ax=k*cw;ay=i*ch; 
                 graphics.beginFill(0x404040, 1); 
                     graphics.drawRect(ax,ay,cw,ch);           
                 graphics.endFill();  

              continue;
             }//nextk
            }//nexti  

           /*
             graphics.lineStyle(2,0x808080);
           for(i=0;i<16;i+=1)
           {
             graphics.moveTo(i*32,0);
             graphics.lineTo(i*32,465);   
             graphics.moveTo(0,i*32);
             graphics.lineTo(465,i*32);
           }//nexti
           */
           
           
           graphics.lineStyle(2,0);
           graphics.drawCircle(cx,cy,16);
           
       }//onenter  
        
    }//classend
}