/**
 * Copyright a24 ( http://wonderfl.net/user/a24 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/E0lV
 */

//
// BetweenAS3 とかで brightness を扱いやすくするよ。
// alpha も同時にいじれるよ。
//

package  
{
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import org.libspark.betweenas3.BetweenAS3;
	
	public class Main extends Sprite
	{
		public function Main() 
		{
			Wonderfl.capture_delay(30);
			
			// BackGround
			graphics.beginFill(0);
			graphics.drawRect(0, 0, 465, 465);
			
			// Image
			var sp:Sprite = new Sprite();
			sp.buttonMode = true;
			sp.x = 130;
			sp.y = 130;
			
			var loader:Loader = new Loader();
			loader.load(new URLRequest("http://wonderfl.net/static/tmp/related_images/2d9441af90236d85651fdb27d672a79b787f902dm"));
			sp.addChild(loader);
			addChild(sp);
			
			// Brightness
			var briEffect:Brightness = new Brightness(sp);
			
			// Click & Tween
			sp.addEventListener(MouseEvent.CLICK, function():void
			{
				BetweenAS3.tween(briEffect, { brightness:0, alpha:1 }, { brightness:2.55, alpha:0.5 }, 1.0).play();
			});
			
		}
	}
}


import flash.display.DisplayObject;
import flash.geom.ColorTransform;

class Brightness
{
	private var _target:DisplayObject;
	private var _alpha:Number;
	private var _brightness:Number;
	private var _colorTf:ColorTransform;
	
	/**
	 * アルファ値や輝値を変更するヘルパークラスです。
	 * @param	target	対象となるオブジェクト
	 */
	public function Brightness(target:DisplayObject) 
	{
		_target     = target;
		_colorTf    = target.transform.colorTransform;
		_alpha      = 1;
		_brightness = 0;
	}
	
	/**
	 * アルファ値
	 */
	public function get alpha():Number { return _alpha; }
	public function set alpha(value:Number):void 
	{
		_alpha = value;
		_colorTf.alphaMultiplier = _alpha;
		_target.transform.colorTransform = _colorTf;
	}
	
	/**
	 * 輝値
	 */
	public function get brightness():Number { return _brightness; }
	public function set brightness(value:Number):void 
	{
		_brightness = value;
		_colorTf.redOffset   = _brightness * 100;
		_colorTf.greenOffset = _brightness * 100;
		_colorTf.blueOffset  = _brightness * 100;
		_target.transform.colorTransform = _colorTf;
	}
	
	/**
	 * カラー値
	 */
	public function get colorTf():ColorTransform { return _colorTf; }
	public function set colorTf(value:ColorTransform):void 
	{
		_colorTf = value;
	}
}