/**
 * Copyright matsumos ( http://wonderfl.net/user/matsumos )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Dx5k
 */

package  
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    /**
     * ...
     * @author matsumos
     */
    public class GetAccurateBoundsTest extends Sprite
    {    
        private var circle:Sprite = new Sprite();

        public function GetAccurateBoundsTest() 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            circle.graphics.beginFill(0xFF0000,0.5);
            circle.graphics.drawEllipse(0, 0, 50, 30);
            circle.graphics.endFill();
            addChild(circle);
            circle.x = 100;
            circle.y = 100;

            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(e:Event):void 
        {
            circle.rotation += 1;
            
            graphics.clear();
            graphics.beginFill(0x0, 0.2);
            const rect:Rectangle = getAccurateBounds(circle);
            graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
            graphics.endFill();
        }
        
        private static var bitmapData:BitmapData;
        private static var boundsColorTint:uint = 0x0000FF;
        private static var colorTransform:ColorTransform = new ColorTransform();
        {
            colorTransform.color = boundsColorTint;
        }
        
        // see http://labs.almerblank.com/2009/11/moving-rotated-objects-the-getbounds-bug-and-how-to-fix-it-part-one/
        private static function getAccurateBounds( clip:DisplayObject ):Rectangle
        {
            bitmapData = new BitmapData( clip.width, clip.height, true, 0xFF000000 );
            var mate:Matrix = clip.transform.matrix;
            mate.tx = 0;
            mate.ty = 0;
            mate.a = mate.a < 0 ? -mate.a : mate.a;
            mate.b = mate.b < 0 ? -mate.b : mate.b;
            mate.c = mate.c < 0 ? -mate.c : mate.c;
            mate.d = mate.d < 0 ? -mate.d : mate.d;
            bitmapData.draw( clip ,mate);
            var ret:Rectangle = bitmapData.getColorBoundsRect( 0xFFFFFF, boundsColorTint, false );
            var bound:Rectangle = clip.getBounds(clip.parent);
            ret.offsetPoint(bound.topLeft);
            bitmapData.dispose();
            
            return ret;
        }    
    }
}