/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/DIgq
 */

/**
 * FlipText Generator
 * @author Yukiya Okuda<alumican.net>
 */
package  
{
	import com.bit101.components.PushButton;
	import flash.display.Bitmap;
	import flash.display.Graphics;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.System;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Quart;
	
	public class FlipTextGenerator extends Sprite
	{
		static public const W:int = 465;
		static public const H:int = 465;
		
		private var _input:TextField;
		private var _flipped:TextField;
		private var _shape1:Shape;
		private var _shape2:Shape;
		
		public function FlipTextGenerator():void 
		{
			visible = false;
			
			//
			var bg:Loader = addChild( new Loader() ) as Loader;
			bg.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
			{
				Bitmap(bg.content).smoothing = true;
				bg.scaleX = bg.scaleY = Math.min(W / bg.width, H / bg.height);
				bg.x = (W - bg.width ) * 0.5;
				bg.y = (H - bg.height) * 0.5;
				
				visible = true;
			});
			bg.load( new URLRequest("http://assets.wonderfl.net/images/related_images/6/6c/6c37/6c375d56b3d309ccb066647a5990b28bee232958"), new LoaderContext(true) );
			
			//
			var rect1:Rectangle = new Rectangle(255, 10 , 200, 80);
			var rect2:Rectangle = new Rectangle(10 , 375, 200, 80);
			
			//
			_shape1 = addChild( new Shape() ) as Shape;
			_shape2 = addChild( new Shape() ) as Shape;
			var g:Graphics;
			
			//
			var fmt:TextFormat = new TextFormat();
			fmt.size = 24;
			
			_input                   = addChild( new TextField() ) as TextField;
			_input.x                 = rect1.x + 15;
			_input.y                 = rect1.y + 10;
			_input.width             = rect1.width - 25;
			_input.height            = rect1.height - 20;
			_input.type              = TextFieldType.INPUT;
		//	_input.restrict          = "\\u0020-\\u007E\\u203F\\u2045\\u2234";
			
			_input.wordWrap          = true;
			_input.defaultTextFormat = fmt;
			_input.text              = "input here !";
			
			_flipped                   = addChild( new TextField() ) as TextField;
			_flipped.x                 = rect2.x + 10;
			_flipped.y                 = rect2.y + 10;
			_flipped.width             = rect2.width - 25;
			_flipped.height            = rect2.height - 20;
			_flipped.type              = TextFieldType.DYNAMIC;
			_flipped.wordWrap          = true;
			_flipped.defaultTextFormat = fmt;
			_flipped.text              = FlipTable.flip("output here !");
			
			_input.addEventListener(Event.CHANGE, function():void
			{
				_input.text = _input.text.toLowerCase();
				_flipped.text = FlipTable.flip(_input.text);
				
				BetweenAS3.parallel(
					BetweenAS3.tween(_shape1, { scaleX : 1, scaleY : 1 }, { scaleX : 1.05, scaleY : 1.05 }, 0.4, Quart.easeOut),
					BetweenAS3.tween(_shape2, { scaleX : 1, scaleY : 1 }, { scaleX : 1.05, scaleY : 1.05 }, 0.4, Quart.easeOut)
				).play();
			});
			
			//
			_shape1.x = rect1.x + rect1.width  * 0.5;
			_shape1.y = rect1.y + rect1.height * 0.5;
			
			rect1.x -= _shape1.x;
			rect1.y -= _shape1.y;
			
			g = _shape1.graphics;
			
			g.lineStyle(2, 0x0);
			g.beginFill(0xffffff);
			g.drawRoundRect(rect1.x, rect1.y, rect1.width, rect1.height, 40, 40);
			g.endFill();
			
			g.beginFill(0xffffff);
			g.moveTo(rect1.left + 90     , rect1.bottom - 10);
			g.lineTo(rect1.left + 90 - 25, rect1.bottom + 20);
			g.lineTo(rect1.left + 90 + 25, rect1.bottom - 10);
			g.endFill();
			
			g.lineStyle(0, 0x0, 0);
			g.beginFill(0xffffff);
			g.drawRect(rect1.left + 75, rect1.bottom - 14, 50, 15 - 2);
			g.endFill();
			
			//
			_shape2.x = rect2.x + rect2.width  * 0.5;
			_shape2.y = rect2.y + rect2.height * 0.5;
			
			rect2.x -= _shape2.x;
			rect2.y -= _shape2.y;
			
			g = _shape2.graphics;
			
			g.lineStyle(2, 0x0);
			g.beginFill(0xffffff);
			g.drawRoundRect(rect2.x, rect2.y, rect2.width, rect2.height, 40, 40);
			g.endFill();
			
			g.beginFill(0xffffff);
			g.moveTo(rect2.left + 110     , rect2.top + 10);
			g.lineTo(rect2.left + 110 + 25, rect2.top - 20);
			g.lineTo(rect2.left + 110 - 25, rect2.top + 10);
			g.endFill();
			
			g.lineStyle(0, 0x0, 0);
			g.beginFill(0xffffff);
			g.drawRect(rect2.left + 75, rect2.top + 1, 50, 15);
			g.endFill();
			
			//
			var button:PushButton = new PushButton(this, 465 - 120 - 10, 435, "COPY TO CLIPBOARD", function(e:MouseEvent):void
			{
				System.setClipboard(_flipped.text);
			});
			button.width = 120;
		}
	}
}

class FlipTable
{
	static private var _table:Object = 
	{
		/*
		 * Flip Title
		 * @see http://fliptitle.com/
		 */
		a : '\u0250',
		b : 'q',
		c : '\u0254', //open o -- from pne
		d : 'p',
		e : '\u01DD',
		f : '\u025F', //from pne
		g : '\u0183',
		h : '\u0265',
		i : '\u0131', //from pne
		j : '\u027E',
		k : '\u029E',
	//	l : '\u0283',
		m : '\u026F',
		n : 'u',
		r : '\u0279',
		t : '\u0287',
		v : '\u028C',
		w : '\u028D',
		y : '\u028E',
		'.' : '\u02D9',
		'[' : ']',
		'(' : ')',
		'{' : '}',
		'?' : '\u00BF', //from pne
		'!' : '\u00A1',
		"\'" : ',',
		'<' : '>',
		'_' : '\u203E',
		';' : '\u061B',
		'\u203F' : '\u2040',
		'\u2045' : '\u2046',
		'\u2234' : '\u2235',
		'\r' : '\n' //thank you, Yeeliberto
	};
	
	static public function flip(s:String):String
	{
		if (!_isInitialized) _initialize();
		return s.split("").reverse().join("").replace(
			/./g,
			function($sub:String, $index:int, $str:String):String
			{
				return (_table[$sub] != null) ? _table[$sub] : $sub;
			}
		);
	}
	
	static private function _initialize():void
	{
		for (var code:String in _table)
		{
			_table[_table[code]] = code;
		}
		_isInitialized = true;
	}
	static private var _isInitialized:Boolean = false;
}