/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/DH6C
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
 
	public class Main extends Sprite
	{	
		private var bd:BitmapData;
		private var brush:BitmapData;
		private var prev:Point = new Point();
 
		public function Main()
		{	
			bd = new BitmapData(stage.stageWidth, stage.stageHeight, false);
			addChild(new Bitmap(bd));
 
			var circle:Sprite = new Sprite();
			circle.graphics.beginFill(0x0);
			circle.graphics.drawCircle(3, 3, 3);
			circle.graphics.endFill();
 
			brush = new BitmapData(6, 6, true, 0x0);
			brush.draw(circle);
 
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
 
		private function onMouseDown(event:MouseEvent):void
		{	
			prev.x = mouseX;
			prev.y = mouseY;
 
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private function onMouseMove(event:MouseEvent):void
		{
			var tx:Number = (mouseX - prev.x) / 10;
			var ty:Number = (mouseY - prev.y) / 10;
 
			for (var i:int = 0; i < 10; i++)
			{
				bd.copyPixels(brush, brush.rect, new Point(prev.x - brush.width / 2, prev.y - brush.height / 2));
				prev.x += tx;
				prev.y += ty;
			}
		}
 
		private function onMouseUp(event:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}
