/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/CIXL
 */

// forked from Robbie.Maglone's forked from: flash on 2011-7-14
// forked from flashvictim's flash on 2011-7-14
package
{
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;
    
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    
    public class Matus extends Sprite
    {
        private var _bg:Shape;
        private var _tf:TextField;
        private var _tFormat:TextFormat;
        
        public function Matus()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            drawBg(null);
            
            stage.addEventListener(Event.RESIZE, drawBg);
            
            init3D();
            
            createSpectrum();
            
            loadSong();
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private var _viewport:Viewport3D;
        private var _camera:Camera3D;
        private var _scene:Scene3D;
        private var _renderer:BasicRenderEngine;
        
        private var _cubesList:Array = [];
        
        public const CHANNELS:int = 128;
        
        private function init3D():void
        {
            _viewport = new Viewport3D(512, 512, true);
            addChild(_viewport);
            
            _scene = new Scene3D();
            
            _camera = new Camera3D();
            
            _renderer = new BasicRenderEngine();
        }
        private function createSpectrum():void
        {
            var cube:Cube;
            var nR:Number;
            var nG:Number;
            var nB:Number;
            var nRadians:Number;
            var nColor:uint;
            
            for (var i:uint = 0; i < CHANNELS; i++)
            {
                nRadians = (i * (360 / CHANNELS)) * (Math.PI / 180);
                
                nR = Math.cos(nRadians)                      * 127 + 128 << 16;
                nG = Math.cos(nRadians + 2 * Math.PI / 3) * 127 + 128 << 8;    
                nB = Math.cos(nRadians + 4 * Math.PI / 3) * 127 + 128;
                
                nColor = nR | nG | nB;
                
                var mat:ColorMaterial = new ColorMaterial(nColor);
                mat.doubleSided = true;
                
                var matList:MaterialsList = new MaterialsList();
                matList.addMaterial(mat, "all");
                
                cube = new Cube(matList, 50, 50, 400);
                cube.rotationY = 360 / CHANNELS * i;
                cube.moveForward(500);
                _scene.addChild(cube);
                
                _cubesList[i] = cube;
            }
        }
                
        private var _snd:Sound;
        private var _sndChannel:SoundChannel;
        private var _ba:ByteArray;
        
        private function loadSong():void
        {
            Security.loadPolicyFile("http://www.flashvictim.com/crossdomain.xml");
            
                       _snd = new Sound();
            _snd.addEventListener(Event.COMPLETE, sndLoadComplete);
            _snd.load(url, new SoundLoaderContext(1000, true));
        }
        private function sndLoadComplete(evt:Event):void
        {
            _sndChannel = _snd.play();
        }
        
        private function enterFrameHandler(evt:Event):void
        {
            _ba = new ByteArray();

            SoundMixer.computeSpectrum(_ba, true);
            
            var chModulo:Number = int(512 / CHANNELS);
            var avg:Number = 0;
            var temp:Number = 0;
            var currentCh:Number = 0;
            
            for (var i:uint = 0; i < 512; i++)
            {
                temp = _ba.readFloat();
                avg += temp;
                
                if (i % chModulo)
                {
                    if (currentCh < _cubesList.length)
                    {
                        avg /= chModulo;
                        
                        if (avg > _cubesList[currentCh].scaleY)
                        {
                            _cubesList[currentCh].scaleY = avg * 2;
                        }
                        else
                        {
                            _cubesList[currentCh].scaleY -= 0.04;
                            
                            if (_cubesList[currentCh].scaleY <= 0.1)
                            {
                                _cubesList[currentCh].scaleY = 0.1;
                            }
                        }
                        _cubesList[currentCh].x += (_cubesList[currentCh].x - _cubesList[currentCh].x) / 32;
                        _cubesList[currentCh].y = _cubesList[currentCh].scaleY * 400 / 2;
                        _cubesList[currentCh].z += (_cubesList[currentCh].z - _cubesList[currentCh].z) / 32;
                    }
                    
                    currentCh++;
                    avg = 0;
                }
            }
                
            _camera.orbit(-70, _viewport.containerSprite.mouseX);
            
            _renderer.renderScene(_scene, _camera, _viewport);
        }
        
        private function drawBg(evt:Event):void
        {
            if (!_bg)
            {
                _bg = new Shape();
                addChild(_bg);
            }
            
            _bg.graphics.beginFill(0x000000);
            _bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            _bg.graphics.endFill();
            
            if (!_tFormat)
            {
                _tFormat = new TextFormat();
                _tFormat.color = 0xffffff;
                _tFormat.size = 10;
                _tFormat.font = "Arial";
                _tFormat.align = "right";
            }
            
            if (!_tf)
            {
                _tf = new TextField();
                _tf.multiline = true;
                _tf.autoSize = TextFieldAutoSize.LEFT;
                _tf.htmlText = "http://caster.fnshosting.com:4155/live";
                addChild(_tf);
                _tf.setTextFormat(_tFormat);
            }
            
            _tf.y = stage.stageHeight - 25;
            _tf.x = stage.stageWidth - _tf.textWidth - 10;
        }
    }
}