/**
 * Copyright vuja22 ( http://wonderfl.net/user/vuja22 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/CIGj
 */

// forked from kaikoga's 憑かれたようにゆとりソリティアを解き続ける何か
package {
    
    /*
     * 3枚出しはAIが面倒だったので1枚出しです
     * どうゲームにすればいいのか不明
     */
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class FlashTest extends Sprite {
        
        private var deck:CardPile;
        private var trash:CardPile;
        
        private var columns:Array;
        private var goals:Array;
        
        private var modified:Boolean;
        
        private static const UPPER_Y:int = 50;
        private static const LOWER_Y:int = 150;
        private static const PILE_DY:int = -1;
        
        private function createDeck():void {
            var result:CardPile = new CardPile(20, UPPER_Y, 0, PILE_DY, true);
            for (var num:int = 1; num <= 13; num++) {
                for (var suit:int = 0; suit < 4; suit++) {
                    result.addChild(new Card(num, suit, true, 0, 0));
                }
            }
            result.shuffle();
            this.addChild(result);
            this.deck = result;
        }
        private function createTrash():void {
            var result:CardPile = new CardPile(90, UPPER_Y, 0, PILE_DY, true);
            this.addChild(result);
            this.trash = result;
        }
        private function createColumns():void {
            var result:Array = [];
            for (var i:int = 0; i < 7; i++) {
                var column:CardPile = new CardPile(i*65 + 5, LOWER_Y, 0, 18, true);
                result.push(column);
                for (var j:int = i; j >= 0; j--) {
                    var card:Card = this.deck.removeTop();
                    card.isFaceUp = (j == 0);
                    column.addChild(card);
                }
                this.addChild(column);
            }
            this.columns = result;
        }
        private function createGoals():void {
            var result:Array = [];
            for (var i:int = 0; i < 4; i++) {
                var goal:CardPile = new CardPile(180+i*70, UPPER_Y, 0, PILE_DY, true);
                result.push(goal);
                this.addChild(goal);
            }
            this.goals = result;
        }
        
        public function FlashTest() {
            this.reset();
            this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame);
            this.addEventListener(MouseEvent.CLICK, this.onClick);
        }
        
        private function onClick(event:MouseEvent):void {
            this.reset();
        }
        
        private function reset():void {
            while (this.numChildren > 0) {
                this.removeChildAt(0);
            }
            this.modified = false;
            this.createDeck();
            this.createTrash();
            this.createColumns();
            this.createGoals();
        }
        
        private function goalsTryAccept(card:Card):Boolean {
            for each (var goal:CardPile in this.goals) {
                if (goal.isEmpty) {
                    if (card.num == 1) {
                        goal.addChild(card);
                        this.modified = true;
                        return true;
                    }
                } else {
                    var goalTop:Card = goal.top;
                    if (goalTop.suit == card.suit && goalTop.num == card.num - 1) {
                        goal.addChild(card);
                        this.modified = true;
                        return true;
                    }
                }
            }
            return false;
        }
        
        private function columnsTryAccept(card:Card):Boolean {
            for each (var column:CardPile in this.columns) {
                if (column.isEmpty) {
                    if (card.num == 13) {
                        column.addChild(card);
                        this.modified = true;
                        return true;
                    }
                } else {
                    var columnTop:Card = column.top;
                    if (columnTop.color != card.color && columnTop.num == card.num + 1) {
                        column.addChild(card);
                        this.modified = true;
                        return true;
                    }
                }
            }
            return false;
        }
        
        private function onEnterFrame(event:Event):void {
            if (this.deck.isEmpty) {
                this.trash.dumpTo(this.deck);
                if (this.modified) {
                    this.modified = !this.modified;
                } else {
                    this.reset();
                }
            } else {
                var card:Card = this.deck.removeTop();
                if (this.goalsTryAccept(card)) {
                    return;
                }
                if (this.columnsTryAccept(card)) {
                    return;
                }
                this.trash.addChild(card);
            }
            
            for each (var column:CardPile in this.columns) {
                if (column.numChildren != 0 && this.goalsTryAccept(column.top)) {
                    if (column.top) {
                        column.top.isFaceUp = true;
                    }
                } else if (column.bottom && (!column.bottom.isFaceUp || column.bottom.num < 13)) {
                    var faceUpBottom:Card = column.faceUpBottom;
                    if (columnsTryAccept(faceUpBottom)) {
                        column.moveTo(CardPile(faceUpBottom.parent))
                    }
                    if (column.top) {
                        column.top.isFaceUp = true;
                    }
                }
            }
            
        }
        
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.system.Capabilities;
import flash.text.TextField;
import flash.text.TextFormat;

class CardPile extends Sprite {
    
    private var dx:Number = 0;
    private var dy:Number = 0;
    public function CardPile(x:Number, y:Number, dx:Number, dy:Number, showBase:Boolean = false) {
        super();
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
        if (showBase) {
            var g:Graphics = this.graphics;
            g.lineStyle(1, 0x999999);
            g.beginFill(0xeeeeee);
            g.drawRect(0, 0, 60 - 1, 80 - 1);
        }
    }
    
    public function get isEmpty():Boolean {
        return this.numChildren == 0;
    }
    
    public function get top():Card {
        if (this.numChildren == 0) {
            return null;
        }
        return Card(this.getChildAt(this.numChildren - 1));
    }
    
    public function get bottom():Card {
        if (this.numChildren == 0) {
            return null;
        }
        return Card(this.getChildAt(0));
    }
    
    public function get faceUpBottom():Card {
        var result:Card;
        for (var index:int= this.numChildren - 1; index >= 0; index--) {
            var card:Card = Card(this.getChildAt(index));
            if (card.isFaceUp) {
                result = card;
            } else {
                break;
            } 
        }
        return result;
    }
    
    public function removeTop():Card {
        if (this.numChildren == 0) {
            return null;
        }
        return Card(this.removeChildAt(this.numChildren - 1));
    }
    
    public function dumpTo(target:CardPile):void {
        while (this.numChildren > 0) {
            target.addChild(this.removeTop());
        }
    }
    
    public function moveTo(target:CardPile):void {
        var card:Card;
        do {
            card = this.faceUpBottom;
            if (card) {
                target.addChild(this.removeChild(card));
            }
        } while(card);
    }
    
    override public function addChild(child:DisplayObject):DisplayObject {
        var result:DisplayObject = super.addChild(child);
        this.refresh();
        return result;
    }
    
    override public function addChildAt(child:DisplayObject, index:int):DisplayObject {
        var result:DisplayObject = super.addChildAt(child, index >= 0 ? index : this.numChildren + index);
        this.refresh();
        return result;
    }
    
    override public function removeChild(child:DisplayObject):DisplayObject {
        var result:DisplayObject = super.removeChild(child);
        this.refresh();
        return result;
    }
    
    override public function removeChildAt(index:int):DisplayObject {
        var result:DisplayObject = super.removeChildAt(index >= 0 ? index : this.numChildren + index);
        this.refresh();
        return result;
    }
    
    public function shuffle():void {
        if (this.numChildren < 2) {
            return;
        }
        for (var i:int = 1; i < this.numChildren; i++) {
            var j:int = Math.floor(Math.random() * (i + 1));
            if (i != j) {
                this.swapChildrenAt(i, j);
            }
        }
        this.refresh();
    }
    
    public function refresh():void {
        var x:Number = 0;
        var y:Number = 0;
        var c:int = this.numChildren;
        for (var i:int = 0; i < c; i++) {
            var child:DisplayObject = this.getChildAt(i);
            child.x = x;
            child.y = y;
            x += this.dx;
            y += this.dy
        }
    }
    
}

class Card extends Bitmap {
    
    private var _suit:int = 0;
    public function get suit():int {
        return this._suit;
    }
    public function set suit(value:int):void {
        this._suit = value;
        this.refresh();
    }
    
    public function get color():uint {
        switch (this._suit) {
            case 1:
            case 2:
            return 0xffffff;
            break;
        }
        return 0x000000;
    }
    
    private var _num:int = 0;
    public function get num():int {
        return this._num;
    }
    public function set num(value:int):void {
        this._num = value;
        this.refresh();
    }
    
    private var _isFaceUp:Boolean = true;
    public function get isFaceUp():Boolean {
        return this._isFaceUp;
    }
    public function set isFaceUp(value:Boolean):void {
        this._isFaceUp = value;
        this.refresh();
    }
    private function refresh():void {
        this.bitmapData = CardBitmaps.instance.getCardBitmapData(this._num, this._suit, this._isFaceUp);
    }
    
    public function Card(num:int = 1, suit:int = 0, faceUp:Boolean = true, x:Number = 0, y:Number = 0) {
        super();
        this._suit = suit;
        this._num = num;
        this._isFaceUp = faceUp;
        this.x = x;
        this.y = y;
        this.refresh();
    }
    
}

class CardBitmaps {
    
    public static var instance:CardBitmaps = new CardBitmaps();
    
    private static function createTextField():TextField {
        var result:TextField = new TextField;
        result.width = 48;
        result.height = 20;
        return result;
    }
    private static function createTextFormat():TextFormat {
        var result:TextFormat = new TextFormat("_等幅", 16);
        result.bold = true;
        result.align = "center";
        return result;
    }
    private static var _textField:TextField = createTextField(); 
    private static var _textFormat:TextFormat = createTextFormat();
    private static var _workBitmapData:BitmapData = new BitmapData(48, 20, true, 0x00000000);
    private static var _matrix:Matrix = new Matrix();
    
    private function stamp(bitmapData:BitmapData, x:int, y:int, text:String, color:uint, norotate:Boolean = false):void {
        _textFormat.color = color;
        _textField.defaultTextFormat = _textFormat;
        _textField.text = text;
        _workBitmapData.fillRect(_workBitmapData.rect, 0x00000000);
        _workBitmapData.draw(_textField);
        if (y <= 40 || norotate) {
            _matrix.a = 1;
            _matrix.b = 0;
            _matrix.c = 0;
            _matrix.d = 1;
            _matrix.tx = x - (_workBitmapData.width >> 1);
            _matrix.ty = y - 10;
        } else {
            _matrix.a = -1;
            _matrix.b = 0;
            _matrix.c = 0;
            _matrix.d = -1;
            _matrix.tx = x + (_workBitmapData.width >> 1) - 1;
            _matrix.ty = y + 10 - 1;
        }
        _textFormat.color = color;
        _textField.defaultTextFormat = _textFormat;
        _textField.text = text;
        bitmapData.draw(_workBitmapData, _matrix);
    }
    
    private static const NUM_CHARS:Array = ["Joker","A","2","3","4","5","6","7","8","9","10","J","Q","K"];
    private static const SUIT_CHARS:Array = ["♠", "♥", "♦", "♣"];
    private static const SUIT_COLORS:Array = [0x000000, 0x990000, 0x990000, 0x000000];
    private var _faceDownBitmapData:BitmapData;
    private var _bitmaps:Array = [];
    public function getCardBitmapData(num:int, suit:int = 0, faceUp:Boolean = true):BitmapData {
        if (!faceUp) {
            if (!_faceDownBitmapData) {
                _faceDownBitmapData = new BitmapData(60, 80, false, 0x000000);
                _faceDownBitmapData.fillRect(new Rectangle(1, 1, 58, 78), 0x33ffcc);
            }
            return _faceDownBitmapData;
        }
        suit &= 3;
        var array:Array = this._bitmaps[suit];
        if (!array) {
            array = [];
            this._bitmaps[suit] = array;
        }
        var result:BitmapData = array[num];
        if (!result) {
            result = new BitmapData(60, 80, false, 0x336633);
            result.fillRect(new Rectangle(1, 1, 58, 78), 0xffffff);
            var char:String = SUIT_CHARS[suit];
            var color:uint = SUIT_COLORS[suit];
            if (num >= 1 && num <= 13) {
                this.stamp(result, 10, 10, NUM_CHARS[num], color);
                this.stamp(result, 10, 25, char, color);
            } else {
                color = 0x000000;
            }
            switch (num) {
                case 1:
                this.stamp(result, 30, 40, char, color);
                break;
                case 2:
                this.stamp(result, 30, 24, char, color);
                this.stamp(result, 30, 56, char, color);
                break;
                case 3:
                this.stamp(result, 30, 16, char, color);
                this.stamp(result, 30, 40, char, color);
                this.stamp(result, 30, 64, char, color);
                break;
                case 4:
                this.stamp(result, 20, 16, char, color);
                this.stamp(result, 40, 16, char, color);
                this.stamp(result, 20, 64, char, color);
                this.stamp(result, 40, 64, char, color);
                break;
                case 5:
                this.stamp(result, 20, 16, char, color);
                this.stamp(result, 40, 16, char, color);
                this.stamp(result, 30, 40, char, color);
                this.stamp(result, 20, 64, char, color);
                this.stamp(result, 40, 64, char, color);
                break;
                case 6:
                this.stamp(result, 20, 16, char, color);
                this.stamp(result, 40, 16, char, color);
                this.stamp(result, 20, 40, char, color);
                this.stamp(result, 40, 40, char, color);
                this.stamp(result, 20, 64, char, color);
                this.stamp(result, 40, 64, char, color);
                break;
                case 7:
                this.stamp(result, 20, 16, char, color);
                this.stamp(result, 40, 16, char, color);
                this.stamp(result, 30, 32, char, color);
                this.stamp(result, 20, 40, char, color);
                this.stamp(result, 40, 40, char, color);
                this.stamp(result, 20, 64, char, color);
                this.stamp(result, 40, 64, char, color);
                break;
                case 8:
                this.stamp(result, 20, 16, char, color);
                this.stamp(result, 40, 16, char, color);
                this.stamp(result, 20, 32, char, color);
                this.stamp(result, 40, 32, char, color);
                this.stamp(result, 20, 48, char, color);
                this.stamp(result, 40, 48, char, color);
                this.stamp(result, 20, 64, char, color);
                this.stamp(result, 40, 64, char, color);
                break;
                case 9:
                this.stamp(result, 20, 16, char, color);
                this.stamp(result, 40, 16, char, color);
                this.stamp(result, 20, 32, char, color);
                this.stamp(result, 40, 32, char, color);
                this.stamp(result, 30, 40, char, color);
                this.stamp(result, 20, 48, char, color);
                this.stamp(result, 40, 48, char, color);
                this.stamp(result, 20, 64, char, color);
                this.stamp(result, 40, 64, char, color);
                break;
                case 10:
                this.stamp(result, 20, 16, char, color);
                this.stamp(result, 40, 16, char, color);
                this.stamp(result, 30, 24, char, color);
                this.stamp(result, 20, 32, char, color);
                this.stamp(result, 40, 32, char, color);
                this.stamp(result, 20, 48, char, color);
                this.stamp(result, 40, 48, char, color);
                this.stamp(result, 30, 56, char, color);
                this.stamp(result, 20, 64, char, color);
                this.stamp(result, 40, 64, char, color);
                break;
                case 11:
                this.stamp(result, 30, 20, char, color);
                this.stamp(result, 30, 40, "JJJ", color, true);
                //this.stamp(result, 30, 40, "(ﾟДﾟ,,)", color, true);
                this.stamp(result, 30, 60, char, color);
                break;
                case 12:
                this.stamp(result, 30, 20, char, color);
                this.stamp(result, 30, 40, "QQQ", color, true);
                //this.stamp(result, 30, 40, "(ﾟーﾟ*)", color, true);
                this.stamp(result, 30, 60, char, color);
                break;
                case 13:
                this.stamp(result, 30, 20, char, color);
                this.stamp(result, 30, 40, "KKK", color, true);
                //this.stamp(result, 30, 40, "（´∀｀ ）", color, true);
                this.stamp(result, 30, 60, char, color);
                break;
                default:
                this.stamp(result, 30, 30, "Joker", color, true);
                //this.stamp(result, 30, 50, "（・∀・ ）", color, true);
                break;
            }
            array[num] = result;
        }
        return result;
    }
    
    public function CardBitmaps() {
        super();
    }
    
}

