/**
 * Copyright i_ze ( http://wonderfl.net/user/i_ze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/CI90
 */

package {
    import flash.utils.ByteArray;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.*;
    import flash.net.*;
    import com.bit101.components.*;
    
    public class FlashTest extends Sprite {
        private var jsonText : InputText;
        private var _nc : NetConnection;
        private var _ta : TextArea;
        
        public function FlashTest() {
     
                jsonText = new InputText(this, 20, 20, '[["9402814", true, {"reason":""}]]');
                jsonText.width = 400;
               var flashTest:FlashTest = this;
                var connect : PushButton = new PushButton(this, 20, 45, "Connect", function(e : MouseEvent) : void
                {
                    flashTest.connect();
                }); connect.width = 70;
                
                var submit : PushButton = new PushButton(this, 100, 45, "Submit", function(e : MouseEvent) : void
                {
                    flashTest.call();
                }); submit.width = 70;
                
                var disconnect : PushButton = new PushButton(this, 180, 45, "Disconnect", function(e : MouseEvent) : void
                {
                    flashTest.disconnect();
                }); disconnect.width = 70;
                
                var clear : PushButton = new PushButton(this, 260, 45, "Clear", function(e : MouseEvent) : void
                {
                    flashTest.clear();
                }); clear.width = 70;
                
                _ta = new TextArea(this, 20, 80, "Type input parameters as JSON array. \nEx.:\n [true,'x'] means -> playing(true,'x') \n [true,[123]] means -> playing(true,[123])\n\n");
                _ta.width = 400;
                _ta.height = 340;
                
        }


        public function connect():void {
            if(!_nc)
            {
                _nc = new NetConnection();
                _nc.objectEncoding = flash.net.ObjectEncoding.AMF3;
                _nc.client = {
                    moduleInfo:onModuleInfo,
                    playing: onPlaying
                }; //TODO add callbacks
                _nc.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
                _nc.connect("rtmp://127.0.0.1:1936/echo");
                //_nc.connect("rtmp://testflot.ums.ustream.tv:1976/echo");
                log("Connecting...");
            }
        }

        public function onPlaying(eventData:*):void {
            log("playing RESPONSE jott");
            log("RESPONSE eventData:" + JSON.stringify(eventData));
        }
        
        public function onModuleInfo(eventData:*):void {
            log("moduleInfo jott");
            log("moduleInfo eventData:" + JSON.stringify(eventData));
        }

        public function netStatusHandler(event:*):void {
            log("NetStatus: " + event + " code: " + event.info.code);
            if(event.info.code=="NetConnection.Connect.Closed" || event.info.code == "NetConnection.Connect.Failed")
            {
                log("Terminate connection...")
                disconnect();
            }
        }

        public function call():void {
            if(_nc)
            {
                log("Calling..");
                try {
                    var input:String = jsonText.text;
                    log("Parse this: " + jsonText.text);
                    var jsonParameters:* = JSON.parse(jsonText.text);
                    if(jsonParameters is Array)
                    {       
                        var parameters:Array = [];
                        parameters.push("playing"); //function name
                        parameters.push(null); // callback 
                        for(var i:int =0;i<jsonParameters.length;i++)
                        {
                            parameters.push(jsonParameters[i]);
                        }
                        _nc.call.apply(this, parameters);
                        log("NC.call.apply called with params:" + JSON.stringify(parameters));
                    } else {
                        log("Invalid json param type (not array): " + jsonText.text);
                    }
                } catch(e:*) {
                    log("Error: "  + e);
                }
            }
        }

        public function disconnect():void {
            if(_nc)
            {
                log("Disconnecting...")
                _nc.close();
                _nc = null;
            }
        }

        public function clear():void {
            _ta.text="";
        }


        public function log(message:String):void {
            _ta.text += message + "\n";
        }
    }
}

