/**
 * Copyright Diablo404 ( http://wonderfl.net/user/Diablo404 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/CCr9
 */

// forked from Ryogo_Quberey's forked from: forked from: forked from: forked from: flash on 2011-2-24
// forked from fakestar0826's forked from: forked from: forked from: flash on 2011-2-24
// forked from fakestar0826's forked from: forked from: flash on 2011-2-24
// forked from fakestar0826's forked from: flash on 2011-2-24
// forked from fakestar0826's flash on 2011-2-24
package {
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(width=1280,height=720,backgroundColor=0,frameRate=60)]
    public class FlashTest extends Sprite 
    {
        private var particles:Array;
        private var minDist:Number = 120;
        private var springAmount:Number = 0.0025;
        private var numParticles:uint = 30;
        
        public function FlashTest() 
        {
            // write as3 code here..
            particles = new Array();
            for(var i:int = 0;i < numParticles;i++)
            {
                var size:Number = Math.random() * 9 + 1.5;
                var p:Ball = new Ball(size, /*Math.random() */ 0xFFFFFF);
                p.x = Math.random() * stage.stageWidth;
                p.y = Math.random() * stage.stageHeight;
                p.vx = Math.random() * 6 - 3;
                p.vy = Math.random() * 6 - 3;
                p.mass = size;
                addChild(p);
                particles.push(p);
            }

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            graphics.clear();
            for(var i:int = 0;i < numParticles;i++)
            {
                var p:Ball = particles[i];
                p.x += p.vx;
                p.y += p.vy;
                if(p.x > stage.stageWidth)
                {
                    p.x = 0;
                }
                else if(p.x < 0)
                {
                    p.x = stage.stageWidth;
                }
                if(p.y > stage.stageHeight)
                {
                    p.y = 0;
                }
                else if(p.y < 0)
                {
                    p.y = stage.stageHeight;
                }


            }
            for(i = 0;i < numParticles - 1;i++)
            {
                var p1:Ball = particles[i];
                for(var j:int = i + 1;j < numParticles;j++)
                {
                    var p2:Ball = particles[j];
                    spring(p1, p2);
                }

            }
        }
        
        private function spring(p1:Ball, p2:Ball):void
        {
            var dx:Number = p2.x - p1.x;
            var dy:Number = p2.y - p1.y;
            var dist:Number = Math.sqrt(dx * dx + dy * dy);
            if(dist < minDist)
            {
                
                graphics.lineStyle(1.2, p2.color, 1 - dist / minDist);
                graphics.moveTo(p1.x, p1.y);
                graphics.lineTo(p2.x, p2.y);
                
                var ax:Number = dx * springAmount;
                var ay:Number = dy * springAmount;
                
                p1.vx += ax / p1.mass;
                p1.vy += ay / p1.mass;
                p2.vx -= ax / p2.mass;
                p2.vy -= ay / p2.mass;
            }

            
        }

        
    }
}
import flash.display.Sprite;

class Ball extends Sprite
{
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var mass:Number = 1;
    public var radius:Number = 30
    public var color:uint = 0xFF0000;
    
    public function Ball(r:Number = 10, c:uint = 0xFF0000)
    {
        radius = r;
        color = c;
        
        graphics.beginFill(c);
        graphics.drawCircle(0, 0, r);
        graphics.endFill();
    }

}
