/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/B0gv
 */

package {
    import flash.display.*;
    import flash.geom.*;
    import flash.utils.*;
    import flash.events.*;
    import net.hires.debug.Stats;

    [SWF(frameRate="60")]
    public class main extends Sprite {
        private var SIZE:int = 80;
        private var bmd:BitmapData = new BitmapData(SIZE, SIZE);
        private var bmp:Bitmap;

        function main(){
            graphics.beginFill(0);
            graphics.drawRect(0,0,465,465);
            addChild(bmp = new Bitmap(bmd));
            bmp.scaleX = bmp.scaleY = 400 / SIZE;
            bmp.x = bmp.y = 32;
            var s:Stats = new Stats;
            addChild(s);
            s.visible = false;
            addEventListener(Event.ENTER_FRAME, oef);
            stage.addEventListener(MouseEvent.CLICK, function(e:Event):void { s.visible = !s.visible; });
        }

        private var dir:Vector3D = new Vector3D;
        private var normal:Vector3D = new Vector3D;

        private function oef(e:Event):void {
            var k:Number, cx:Number, cy:Number, cz:Number;
            var t:Number = getTimer()*0.0003;
            var q:Number = 0.005;
            var q2:Number = q*2;
            for(var y:int = 0; y < SIZE; y++) {
                for(var x:int = 0; x < SIZE; x++) {
                    dir.setTo(x-SIZE*0.5, y-SIZE*0.5, SIZE * 0.66);
                    dir.normalize();
                    var sin:Number = Math.sin(t);
                    var cos:Number = Math.cos(t);
                    var dx:Number = cos * dir.x - sin * dir.z;
                    var dz:Number = sin * dir.x + cos * dir.z;
                    var dy:Number = dir.y;
                    var px:Number = 0, py:Number = 0, pz:Number = t*20;
                    for(var i:int=0; i<24; i++) {
                        /*
                        k = scene(px, py, pz);
                        /*/
                        // inlined:
                        cx = (px > 0 ? px : -px) % 4 - 2;
                        cy = (py > 0 ? py : -py) % 4 - 2;
                        cz = (pz > 0 ? pz : -pz) % 4 - 2;
                        k = Math.sqrt(cx*cx + cy*cy + cz*cz) - 1.2;
                        //*/

                        px += dx * k;
                        py += dy * k;
                        pz += dz * k;
                    }
                    px -= q; py -= q; pz -= q;
                    normal.setTo(
                        scene(px+q2, py, pz),
                        scene(px, py+q2, pz),
                        scene(px, py, pz+q2));
                    normal.normalize();
                    var c:uint = (1 + normal.x) * 127 << 16 | (1 + normal.y) * 127 << 8 | (1 + normal.z) * 127;
                    // c = ((1+normal.z)*127|0)*0x10101;
                    bmd.setPixel(x, y, c);

                }
            }
        }

        private function scene(x:Number, y:Number, z:Number):Number {
            x = (x > 0 ? x : -x) % 4 - 2;
            y = (y > 0 ? y : -y) % 4 - 2;
            z = (z > 0 ? z : -z) % 4 - 2;
            return Math.sqrt(x*x + y*y + z*z) - 1.2;
        }
    }
}

