/**
 * Copyright raa ( http://wonderfl.net/user/raa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AyVk
 */

// forked from Hakuhin's Pixel Bender (ゲームボーイディスプレイ風フィルタ)
// -------------------------------------------------
//
// ゲームボーイディスプレイ風フィルタ
//
//
// カラーの配分は色補正パラメータで調整可能です。
// 矩形中央の値を取得するように変更しました。
// 外部から動画を読み込めるように修正しました。
// -------------------------------------------------
package {
    import flash.events.*;
    import flash.display.*;
    import flash.net.*;
    import flash.text.*;
    import flash.utils.*;
    import flash.system.*;
    import flash.geom.*;
    import flash.filters.*;
    import flash.ui.*;
    import flash.media.*;

    public class Main extends Sprite {
        public function Main() {

 

// -------------------------------------------------
// コンストラクタ
// -------------------------------------------------

// 動画のURL
var movie_url:String = "http://actionscript.web.officelive.com/wonderfl/movie000.mp4";

// 100%表示
stage.scaleMode = StageScaleMode.NO_SCALE;

// 左上
stage.align = StageAlign.TOP_LEFT;
stage.align = "TL";

// ビデオを配置
var video_obj : Video = new Video();
addChild(video_obj);

// ストリーム
var connection:NetConnection = new NetConnection();
connection.connect(null);    
var netStream:NetStream = new NetStream(connection);

// サウンドをOFF
var trans : SoundTransform = netStream.soundTransform;
trans.volume = 0.0;
netStream.soundTransform = trans;

// ビデオとストリームを関連付け
video_obj.attachNetStream(netStream);

// メタデータ取得
var obj:Object = new Object();
obj.onMetaData = function(param:Object):void{
}
netStream.client = obj;

// リザルト作成
var result : Sprite = new Sprite();
addChild(result);
result.x = 0;

// ボタン作成
var button:Button = new Button(stage);
button.y = 10;
button.setSize(60,20);
button.setLabel("開く");
result.addChild(button);

// ボタンが押された
button.addEventListener(MouseEvent.CLICK,function(e:MouseEvent):void{
    load(text.text);
});

// テキストフィールド作成
var text:TextField = new TextField();
text.x = 10;
text.y = 10;
text.height = 20;
text.type = TextFieldType.INPUT;
text.border = true;

// 書式
var format:TextFormat = new TextFormat();
format.font = "ＭＳ ゴシック";    // フォント名
text.defaultTextFormat = format;

// テキスト表示
text.text = movie_url;
result.addChild(text);

// 初期化
init();

// リソース読み込み開始
load(movie_url);


// -------------------------------------------------
// 読み込み
// -------------------------------------------------
function load(url:String):void{

    // 再生開始
    netStream.play(url);
}


// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

    // ステージサイズ
    var w:uint;
    var h:uint;
    
    // リサイズ時にフィット
    stage.addEventListener(Event.RESIZE,ResizeFunc);
    function ResizeFunc(e:Event):void{
        w = stage.stageWidth;
        h = stage.stageHeight;
        video_obj.width = w;
        video_obj.height = h - 40;
        result.y = h - 40;
    
        // テキストフィールド位置
        text.width = w - 10 - 10 - button.width - 10;
    
        // ボタン位置
        button.x = w - button.width - 10;
    }
    ResizeFunc(null);

    // シェーダバイトコード
    var binary : ByteArray = CustomFilterGetByteArray();
    
    // シェーダ作成
    var shader:Shader = new Shader();
    shader.byteCode = binary;
    var filter:ShaderFilter = new ShaderFilter(shader); 

    // パラメータアクセス用
    var data : ShaderData  = shader.data;
    var param : ShaderParameter;

    // パラメータ
    var width:Number = 4;        // ドットの幅
    var height:Number = 4;        // ドットの高さ
    var interval:Number = 1;    // ドット間隔
    var average_multiplier:Number = 1.0;    // 平均カラーの乗算成分
    var average_offset:Number = 0;        // 平均カラーの加算成分
    var bits_per_pixel:Number = 4;    // 　色深度
    
    addEventListener(Event.ENTER_FRAME,function(e:Event):void{

        // ドットの幅
        param = data.width;
        param.value = [width];

        // ドットの高さ
        param = data.height;
        param.value = [height];

        // 水平方向のドット間隔
        param = data.interval_h;
        param.value = [interval];

        // 垂直方向のドット間隔
        param = data.interval_v;
        param.value = [interval];

        // 平均カラーの乗算成分
        param = data.average_multiplier;
        param.value = [average_multiplier];

        // 平均カラーの加算成分
        param = data.average_offset;
        param.value = [average_offset];

        // 色深度
        param = data.bits_per_pixel;
        param.value = [bits_per_pixel];

        // 適応
        video_obj.filters = [filter];
    });

    // テキスト表示
    var tf : TextField = new TextField();
    tf.x = 5;
    tf.y = 5;
    tf.width = 300;
    tf.height = 80;
    tf.border = true;
    tf.background = true;
    tf.alpha = 0.9;
    
    // 書式
    var format : TextFormat = new TextFormat();
    format.font = "ＭＳ ゴシック";
    tf.defaultTextFormat = format;

    addChild(tf);
    addEventListener(Event.ENTER_FRAME,function(e:Event):void{
        var str:String = "";
        str += "ドットの幅　　　　:" + width + "　(上下キーで変更)\n";
        str += "ドットの高さ　　　:" + height + "　(左右キーで変更)\n";
        str += "平均カラー乗算成分:" + (Math.floor(average_multiplier * 100) / 100) + "　(1,2キーで変更)\n";
        str += "平均カラー加算成分:" + average_offset + "　(3,4キーで変更)\n";
        str += "色深度　　　　　　:" + bits_per_pixel + "　(5,6キーで変更)\n";
        str += "ドット間隔　　　　:" + interval + "　(7,8キーで変更)\n";

        tf.text = str;
    });
    
    
    // キー操作
    stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
    function KeyDown(event:KeyboardEvent):void{
        if(event.keyCode == Keyboard.UP)        height -= 1;
        if(event.keyCode == Keyboard.DOWN)        height += 1;
        if(event.keyCode == Keyboard.LEFT)        width -= 1;
        if(event.keyCode == Keyboard.RIGHT)        width += 1;
        if(event.keyCode == 49)        average_multiplier -= 0.05;
        if(event.keyCode == 50)        average_multiplier += 0.05;
        if(event.keyCode == 51)        average_offset -= 5;
        if(event.keyCode == 52)        average_offset += 5;
        if(event.keyCode == 53)        bits_per_pixel -= 1;
        if(event.keyCode == 54)        bits_per_pixel += 1;
        if(event.keyCode == 55)        interval -= 1;
        if(event.keyCode == 56)        interval += 1;
        
        if(width < 1)                    width = 1;
        if(height < 1)                    height = 1;
        if(average_multiplier <-2.0)    average_multiplier =-2.0;
        if(average_multiplier > 2.0)    average_multiplier = 2.0;
        if(average_offset <-255)        average_offset =-255;
        if(average_offset > 255)        average_offset = 255;
        if(bits_per_pixel < 1)            bits_per_pixel = 1;
        if(interval < 0)                interval = 0;
    };

}


// -------------------------------------------------
// シェーダバイトコード
// -------------------------------------------------
function CustomFilterGetByteArray():ByteArray{

    var a:ByteArray = new ByteArray();
    var f:Function;

    f = a.writeUnsignedInt;
    f(0xa5010000); f(0x00a41400); f(0x47616d65); f(0x426f7944); 
    f(0x6973706c); f(0x61794669); f(0x6c746572); f(0xa00c6e61); 
    f(0x6d657370); f(0x61636500); f(0x67616d65); f(0x20626f79); 
    f(0x20646973); f(0x706c6179); f(0x00a00c76); f(0x656e646f); 
    f(0x72004861); f(0x6b756869); f(0x6e00a008); f(0x76657273); 
    f(0x696f6e00); f(0x0100a00c); f(0x64657363); f(0x72697074); 
    f(0x696f6e00); f(0x8351815b); f(0x8380837b); f(0x815b8343); 
    f(0x83668342); f(0x83588376); f(0x838c8343); f(0x95978374); 
    f(0x8342838b); f(0x835e00a1); f(0x01020000); f(0x0c5f4f75); 
    f(0x74436f6f); f(0x726400a3); f(0x00047372); f(0x6300a102); 
    f(0x0401000f); f(0x64737400); f(0xa1010100); f(0x00027769); 
    f(0x64746800); f(0xa2016d69); f(0x6e56616c); f(0x7565003f); 
    f(0x800000a2); f(0x01646566); f(0x61756c74); f(0x56616c75); 
    f(0x65004040); f(0x0000a20c); f(0x64657363); f(0x72697074); 
    f(0x696f6e00); f(0x83688362); f(0x836782cc); f(0x959d00a1); 
    f(0x01010000); f(0x01686569); f(0x67687400); f(0xa2016d69); 
    f(0x6e56616c); f(0x7565003f); f(0x800000a2); f(0x01646566); 
    f(0x61756c74); f(0x56616c75); f(0x65004040); f(0x0000a20c); 
    f(0x64657363); f(0x72697074); f(0x696f6e00); f(0x83688362); 
    f(0x836782cc); f(0x8d8282b3); f(0x00a10101); f(0x02000869); 
    f(0x6e746572); f(0x76616c5f); f(0x6800a201); f(0x6d696e56); 
    f(0x616c7565); f(0x00000000); f(0x00a20164); f(0x65666175); 
    f(0x6c745661); f(0x6c756500); f(0x00000000); f(0xa20c6465); 
    f(0x73637269); f(0x7074696f); f(0x6e009085); f(0x95bd95fb); 
    f(0x8cfc82cc); f(0x83688362); f(0x83678ad4); f(0x8a7500a1); 
    f(0x01010200); f(0x04696e74); f(0x65727661); f(0x6c5f7600); 
    f(0xa2016d69); f(0x6e56616c); f(0x75650000); f(0x000000a2); 
    f(0x01646566); f(0x61756c74); f(0x56616c75); f(0x65000000); 
    f(0x0000a20c); f(0x64657363); f(0x72697074); f(0x696f6e00); 
    f(0x908292bc); f(0x95fb8cfc); f(0x82cc8368); f(0x83628367); 
    f(0x8ad48a75); f(0x00a10104); f(0x03000f69); f(0x6e746572); 
    f(0x76616c5f); f(0x636f6c6f); f(0x7200a204); f(0x64656661); 
    f(0x756c7456); f(0x616c7565); f(0x00000000); f(0x00000000); 
    f(0x00000000); f(0x003f8000); f(0x00a20c64); f(0x65736372); 
    f(0x69707469); f(0x6f6e0083); f(0x68836283); f(0x678ad48a); 
    f(0x7582cc90); f(0x4600a101); f(0x0404000f); f(0x6c696768); 
    f(0x745f636f); f(0x6c6f7200); f(0xa2046465); f(0x6661756c); 
    f(0x7456616c); f(0x7565003f); f(0x40c0c13f); f(0x50d0d13f); 
    f(0x1090913f); f(0x800000a2); f(0x0c646573); f(0x63726970); 
    f(0x74696f6e); f(0x0088ea94); f(0xd496be82); f(0xe982a290); 
    f(0x4600a101); f(0x0405000f); f(0x6461726b); f(0x5f636f6c); 
    f(0x6f7200a2); f(0x04646566); f(0x61756c74); f(0x56616c75); 
    f(0x65003e80); f(0x80813ea0); f(0xa0a13e20); f(0xa0a13f80); 
    f(0x0000a20c); f(0x64657363); f(0x72697074); f(0x696f6e00); 
    f(0x88ea94d4); f(0x88c382a2); f(0x904600a1); f(0x01010200); 
    f(0x02626974); f(0x735f7065); f(0x725f7069); f(0x78656c00); 
    f(0xa2016d69); f(0x6e56616c); f(0x7565003f); f(0x800000a2); 
    f(0x016d6178); f(0x56616c75); f(0x65004380); f(0x0000a201); 
    f(0x64656661); f(0x756c7456); f(0x616c7565); f(0x00408000); 
    f(0x00a20c64); f(0x65736372); f(0x69707469); f(0x6f6e0090); 
    f(0x46905b93); f(0x7800a101); f(0x01020001); f(0x61766572); 
    f(0x6167655f); f(0x6d756c74); f(0x69706c69); f(0x657200a2); 
    f(0x01646566); f(0x61756c74); f(0x56616c75); f(0x65003f80); 
    f(0x0000a20c); f(0x64657363); f(0x72697074); f(0x696f6e00); 
    f(0x95bd8bcf); f(0x834a8389); f(0x815b82cc); f(0x8fe68e5a); 
    f(0x90ac95aa); f(0x00a10101); f(0x06000861); f(0x76657261); 
    f(0x67655f6f); f(0x66667365); f(0x7400a201); f(0x64656661); 
    f(0x756c7456); f(0x616c7565); f(0x00000000); f(0x00a20c64); 
    f(0x65736372); f(0x69707469); f(0x6f6e0095); f(0xbd8bcf83); 
    f(0x4a838981); f(0x5b82cc89); f(0xc18e5a90); f(0xac95aa00); 
    f(0x1d060061); f(0x00001000); f(0x1d060010); f(0x00008000); 
    f(0x01060010); f(0x02000000); f(0x1d070080); f(0x0600c000); 
    f(0x04060010); f(0x07000000); f(0x03060010); f(0x06004000); 
    f(0x1a070040); f(0x0600c000); f(0x1d060010); f(0x07004000); 
    f(0x1d070040); f(0x0600c000); f(0x03070040); f(0x07000000); 
    f(0x1d070020); f(0x06004000); f(0x02070020); f(0x07004000); 
    f(0x1d070040); f(0x07008000); f(0x1d070020); f(0x0600c000); 
    f(0x03070020); f(0x07000000); f(0x32070010); f(0x40000000); 
    f(0x04080080); f(0x0700c000); f(0x03080080); f(0x00008000); 
    f(0x1d070010); f(0x07008000); f(0x01070010); f(0x08000000); 
    f(0x1d070020); f(0x0700c000); f(0x01070020); f(0x02000000); 
    f(0x1d060040); f(0x07008000); f(0x1d070020); f(0x0000c000); 
    f(0x01070020); f(0x02004000); f(0x1d070080); f(0x07008000); 
    f(0x04070020); f(0x07000000); f(0x03070020); f(0x06008000); 
    f(0x1a070010); f(0x07008000); f(0x1d070020); f(0x0700c000); 
    f(0x1d070010); f(0x07008000); f(0x03070010); f(0x07000000); 
    f(0x1d080080); f(0x06008000); f(0x02080080); f(0x0700c000); 
    f(0x1d070010); f(0x08000000); f(0x1d080080); f(0x07008000); 
    f(0x03080080); f(0x07000000); f(0x32080040); f(0x40000000); 
    f(0x04080020); f(0x08004000); f(0x03080020); f(0x0000c000); 
    f(0x1d080040); f(0x08000000); f(0x01080040); f(0x08008000); 
    f(0x1d080080); f(0x08004000); f(0x01080080); f(0x02004000); 
    f(0x1d060020); f(0x08000000); f(0x2a070040); f(0x02000000); 
    f(0x1d018080); f(0x00800000); f(0x34000000); f(0x01800000); 
    f(0x1d0100f3); f(0x03001b00); f(0x35000000); f(0x00000000); 
    f(0x2a070010); f(0x02004000); f(0x1d018040); f(0x00800000); 
    f(0x34000000); f(0x01804000); f(0x1d0100f3); f(0x03001b00); 
    f(0x35000000); f(0x00000000); f(0x310800f1); f(0x06006000); 
    f(0x1d0900f3); f(0x08001b00); f(0x1d080080); f(0x09000000); 
    f(0x01080080); f(0x09004000); f(0x1d080040); f(0x08000000); 
    f(0x01080040); f(0x09008000); f(0x32080080); f(0x40400000); 
    f(0x04080020); f(0x08000000); f(0x03080020); f(0x08004000); 
    f(0x1d080080); f(0x08008000); f(0x1d080040); f(0x08000000); 
    f(0x03080040); f(0x0200c000); f(0x32080020); f(0x437f0000); 
    f(0x04080010); f(0x08008000); f(0x03080010); f(0x06000000); 
    f(0x1d080020); f(0x08004000); f(0x01080020); f(0x0800c000); 
    f(0x1d080080); f(0x08008000); f(0x32080040); f(0x00000000); 
    f(0x2a080080); f(0x08004000); f(0x1d018020); f(0x00800000); 
    f(0x34000000); f(0x01808000); f(0x32080080); f(0x00000000); 
    f(0x36000000); f(0x00000000); f(0x32080040); f(0x3f800000); 
    f(0x2a080040); f(0x08000000); f(0x1d018020); f(0x00800000); 
    f(0x34000000); f(0x01808000); f(0x32080080); f(0x3f800000); 
    f(0x36000000); f(0x00000000); f(0x1d080040); f(0x08000000); 
    f(0x03080040); f(0x02008000); f(0x1a080020); f(0x08004000); 
    f(0x1d080040); f(0x08008000); f(0x32080020); f(0x3f800000); 
    f(0x1d080010); f(0x02008000); f(0x02080010); f(0x08008000); 
    f(0x2a080010); f(0x08004000); f(0x1d018020); f(0x00800000); 
    f(0x34000000); f(0x01808000); f(0x32080020); f(0x3f800000); 
    f(0x1d080010); f(0x02008000); f(0x02080010); f(0x08008000); 
    f(0x1d080040); f(0x0800c000); f(0x36000000); f(0x00000000); 
    f(0x32080020); f(0x3f800000); f(0x1d080010); f(0x02008000); 
    f(0x02080010); f(0x08008000); f(0x04080020); f(0x0800c000); 
    f(0x03080040); f(0x08008000); f(0x1d080020); f(0x04000000); 
    f(0x02080020); f(0x05000000); f(0x1d080010); f(0x08008000); 
    f(0x03080010); f(0x08004000); f(0x1d080020); f(0x0800c000); 
    f(0x01080020); f(0x05000000); f(0x1d090080); f(0x08008000); 
    f(0x1d080020); f(0x04004000); f(0x02080020); f(0x05004000); 
    f(0x1d080010); f(0x08008000); f(0x03080010); f(0x08004000); 
    f(0x1d080020); f(0x0800c000); f(0x01080020); f(0x05004000); 
    f(0x1d090040); f(0x08008000); f(0x1d080020); f(0x04008000); 
    f(0x02080020); f(0x05008000); f(0x1d080010); f(0x08008000); 
    f(0x03080010); f(0x08004000); f(0x1d080020); f(0x0800c000); 
    f(0x01080020); f(0x05008000); f(0x1d090020); f(0x08008000); 
    f(0x1d080020); f(0x0400c000); f(0x02080020); f(0x0500c000); 
    f(0x1d080010); f(0x08008000); f(0x03080010); f(0x08004000); 
    f(0x1d080020); f(0x0800c000); f(0x01080020); f(0x0500c000); 
    f(0x1d090010); f(0x08008000); f(0x1d0100f3); f(0x09001b00); 
    f(0x36000000); f(0x00000000); f(0x36000000); f(0x00000000); 
    
    return a;

}


           
        }
    }
}


// ↓ pbk ファイルのコード
/* -----------------------------------------------------------------------------
    ゲームボーイディスプレイ風フィルタ

    ファイル名    :    game boy display.pbk
    製作        :    Hakuhin    (C)    2009/12/23
 ----------------------------------------------------------------------------- */

/* -----------------------------------------------------------------------------
    パラメータ
    width               ドットの幅
    height              ドットの高さ
    interval_h          水平方向のドット間隔
    interval_v          垂直方向のドット間隔
    interval_color      ドット間隔の色
    light_color            一番明るい色
    dark_color            一番暗い色
    bits_per_pixel      色深度
    average_multiplier  平均カラーの乗算成分 (デフォルト 1.0)
    average_offset        平均カラーの加算成分 (デフォルト 0.0)
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel GameBoyDisplayFilter<
    namespace : "game boy display";
    vendor : "Hakuhin";
    version : 1;
    description : "ゲームボーイディスプレイ風フィルタ";
>{
    input image4 src;    // 入力イメージ
    output pixel4 dst;    // 出力ピクセル


    // -------------------------------------
    // パラメータ
    // -------------------------------------
    parameter float width<
        minValue:float(1.0);
        defaultValue:float(3.0);
        description : "ドットの幅";
    >;
    parameter float height<
        minValue:float(1.0);
        defaultValue:float(3.0);
        description : "ドットの高さ";
    >;
    parameter float interval_h<
        minValue:float(0.0);
        defaultValue:float(0.0);
        description : "水平方向のドット間隔";
    >;
    parameter float interval_v<
        minValue:float(0.0);
        defaultValue:float(0.0);
        description : "垂直方向のドット間隔";
    >;
    parameter pixel4 interval_color<
        defaultValue:pixel4(0,0,0,1);
        description : "ドット間隔の色";
    >;
    parameter pixel4 light_color<
        defaultValue:pixel4(0.7529411764705882,0.8156862745098039,0.5647058823529412,1);
        description : "一番明るい色";
    >;
    parameter pixel4 dark_color<
        defaultValue:pixel4(0.2509803921568627,0.3137254901960784,0.1568627450980392,1);
        description : "一番暗い色";
    >;
    parameter float bits_per_pixel<
        minValue:float(1);
        maxValue:float(256);
        defaultValue:float(4);
        description : "色深度";
    >;
    parameter float average_multiplier<
        defaultValue:float(1.0);
        description : "平均カラーの乗算成分";
    >;
    parameter float average_offset<
        defaultValue:float(0);
        description : "平均カラーの加算成分";
    >;

    // -------------------------------------
    // ピクセルごとに実行される関数
    // -------------------------------------
    void evaluatePixel(){

        // ピクセルの位置を取得
        float2 pos = outCoord();
        
        // 水平方向の位置を周期に丸める
        float length = width + interval_h;
        float x = floor(pos.x / length);
        float h = pos.x - (x * length);
        pos.x = x * length + width / 2.0 + interval_h;
        
        // 垂直方向の位置を周期に丸める
        length = height + interval_v;
        float y = floor(pos.y / length);
        float v = pos.y - (y * length);
        pos.y = y * length + height / 2.0 + interval_v;
        
        if(h < interval_h){
            // ドット間隔の色を出力
            dst = interval_color;
        }else if(v < interval_v){
            // ドット間隔の色を出力
            dst = interval_color;
        }else{
            // 左上の１ドット
            pixel4 color = sampleLinear(src,pos);
            
            // カラー平均
            float average = (color[0] + color[1] + color[2]) / 3.0;
            
            // カラー補正
            average = average * average_multiplier + average_offset / 255.0;
            if(average < 0.0) average = 0.0;
            if(average > 1.0) average = 1.0;
            
            // 減色
            float d = floor(average * bits_per_pixel);
            if(d > bits_per_pixel - 1.0) d = bits_per_pixel - 1.0;
            d /= bits_per_pixel - 1.0;
        
            // 暗い色から明るい色に再配置
            color[0] = (light_color[0] - dark_color[0]) * d + dark_color[0];
            color[1] = (light_color[1] - dark_color[1]) * d + dark_color[1];
            color[2] = (light_color[2] - dark_color[2]) * d + dark_color[2];
            color[3] = (light_color[3] - dark_color[3]) * d + dark_color[3];
            
            dst = color;

        }
    }
}
*/





import flash.events.*;
import flash.display.*;
import flash.text.*;
import flash.geom.*;

// -------------------------------------------------
// ボタン
// -------------------------------------------------
internal class Button extends Sprite {

    private var _width:Number;
    private var _height:Number;
    
    private var _text:TextField;
    private var _background:Sprite;
    

    public function Button(stage:Stage) {
        var slider:Button = this;

        // 背景用スプライト作成
        _background = new Sprite();
        addChild(_background);

        // テキストフィールド
        _text = new TextField();
        addChild(_text);
    
        _text.x = 0;
        _text.y = 0;
        _text.selectable = false;

        // 書式
        var format:TextFormat = new TextFormat();
        format.align = TextFormatAlign.CENTER;    // 整列
        format.font = "ＭＳ ゴシック";    // フォント名
        format.size = 14;                // 文字のポイントサイズ
        format.color = 0x202020;        // 文字の色
        _text.defaultTextFormat = format;
    
        // マウスオーバーで少し明るく
        addEventListener(MouseEvent.MOUSE_OVER,function(e:MouseEvent):void{
            var color : ColorTransform = new ColorTransform(1,1,1,1,8,8,8,0);
            transform.colorTransform = color;
        });

        // マウスアウトで元に戻す
        addEventListener(MouseEvent.MOUSE_OUT,function(e:MouseEvent):void{
            var color : ColorTransform = new ColorTransform(1,1,1,1,0,0,0,0);
            transform.colorTransform = color;                                                           
        });

        // デフォルト値
        setSize(100,100);
        update();
    }
    // リサイズ
    public function setSize(w:Number,h:Number):void{
        // 背景リサイズ
        _width = w;
        _height = h;
        update();
    }
    // ラベルセット
    public function setLabel(str:String):void{
        _text.text = str;
        update();
    }
    // 描画更新
    private function update():void{
        // 背景描画
        var g:Graphics = _background.graphics;
        
        // 角丸矩形描画
        g.clear();
        g.lineStyle ( 0 , 0x808080 , 1.0,false,LineScaleMode.NONE,CapsStyle.ROUND,JointStyle.ROUND);
        g.beginFill ( 0xF0F0F0 , 1.0 );
        g.drawRoundRect ( 0 , 0 , _width , _height , 5 , 5 );
        g.endFill();
        
        // テキスト位置修正
        _text.width  = _width;
        _text.height = _height;
    }
}



// -------------------------------------------------
// 外部画像をサムネイルとしてキャプチャ
// -------------------------------------------------
import flash.net.*;
import flash.events.*;
import flash.display.*;
import flash.geom.*;
function ThumbnailCapture(url:String,time:uint,stage:Stage):void{

    // キャプチャタイミング
    Wonderfl.capture_delay( time );

    
    // スプライト作成
    var sprite : Sprite = new Sprite();

    // ステージ最前面に配置
    stage.addChildAt(sprite,stage.numChildren);
    
    // ローダー
    var loader_obj : Loader = new Loader();
    loader_obj.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

        // メモリからインスタンス化
        var loader_memory : Loader = new Loader();
        loader_memory.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

            // キャプチャ
            var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
            sprite.addChild(loader_memory);
            bmp.draw(sprite);
            sprite.removeChild(loader_memory);
            loader_memory.unload();
            loader_obj.unload();
            loader_memory = null;
            loader_obj = null;
            
            
            // 画像を配置
            var bmp_obj : Bitmap = new Bitmap(bmp);
            bmp_obj .width = stage.stageWidth;
            bmp_obj .height = stage.stageHeight;
            stage.addChild(bmp_obj );
            
        });
        
        // 読み込み開始
        loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
    });
    
    // 読み込み開始
    loader_obj.load(new URLRequest(url));
}