/**
 * Copyright vasylbo ( http://wonderfl.net/user/vasylbo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AvsU
 */

// forked from alpicola's forked from: 15 puzzle
// forked from flashrod's 15 puzzle
// photo: Ville Miettinen's Grundvik main house
// http://www.flickr.com/photos/wili/214317898/

package {
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import caurina.transitions.Tweener;
    public class Fifteen extends Sprite {
        private static const W:int = 465;
        private static const H:int = 465;
        private static const U:int = int(W/3);
        private static const V:int = int(H/3);
        private var board:Array = [];
        private var loader:Loader;

        public function Fifteen() {
            loader = new Loader();
            var context:LoaderContext = new LoaderContext(true);
            loader.contentLoaderInfo.addEventListener("complete", loadingComplete);
            loader.load(new URLRequest("http://farm1.static.flickr.com/57/214317898_596c96ecb6.jpg"), context);
        }

        public function loadingComplete(e:Event):void {
            var source:BitmapData = new BitmapData(W, H, false);
            var sx:Number = W / loader.width;
            var sy:Number = H / loader.height;
            if (sx > sy) {
                source.draw(loader, new Matrix(sx, 0, 0, sx, 0, (H - loader.height * sx) / 2), null, null, null, true);
            } else {
                source.draw(loader, new Matrix(sy, 0, 0, sy, (W - loader.width * sy) / 2, 0), null, null, null, true);
            }
            for (var k:int = 1; k < 9; ++k) {
                var p:Piece = new Piece(k, source);
                addChild(p);
                board.push(p);
            }
            var i:int, j:int = 1;
            for (k = 0; k < 9; ++k) {
                i = int(Math.random()*3);
                shift(i, j);
                j = int(Math.random()*3);
                shift(i, j);
            }
            stage.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
                shift(e.stageX/U, e.stageY/V);
                repaint();
            });
            repaint();
        }
        private function shift(x:int, y:int):void {
            if (x>=0 && x<4 && y>=0 && y<4) {
                for (var i:int = 0; i < 4; ++i) {
                    var p:Piece = board[y*4+i];
                    if (p.value == 16) {
                        for (; i>x; --i)
                            board[y*4+i] = board[y*4+i-1];
                        for (; i<x; ++i)
                            board[y*4+i] = board[y*4+i+1];
                        board[y*4+x] = p;
                        return;
                    }
                }
                for (var j:int = 0; j<4; ++j) {
                    p = board[j*4+x];
                    if (p.value == 16) {
                        for (; j>y; --j)
                            board[j*4+x] = board[(j-1)*4+x];
                        for (; j<y; ++j)
                            board[j*4+x] = board[(j+1)*4+x];
                        board[y*4+x] = p;
                        return;
                    }
                }
            }
        }
        private function repaint():void {
            for (var j:int = 0; j < 4; ++j) {
                for (var i:int = 0; i < 4; ++i) {
                    var p:Piece = board[j*4+i];
                    //p.x = i*U;
                    //p.y = j*V;
                    Tweener.addTween(p, {x:i*U, y:j*V, time:0.1, transition:"easeOutQuad"});
                }
            }
        }
    }
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Point;
import flash.geom.Rectangle;
class Piece extends Sprite {
    public var value:int;
    public function Piece(value:int, source:BitmapData) {
        this.value = value;
        if (value == 16) return;
        var w:Number = source.width / 4;
        var h:Number = source.height / 4;
        var bitmap:BitmapData = new BitmapData(w, h, false);
        var rect:Rectangle = new Rectangle((value-1)%4*w, Math.floor(value/4)*h, w, h);
        bitmap.copyPixels(source, rect, new Point());
        addChild(new Bitmap(bitmap));
    }
}
