/**
 * Copyright yonatan2 ( http://wonderfl.net/user/yonatan2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Au9M
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.media.*;
    import com.bit101.components.*;
    
    public class FlashTest extends Sprite {
        private const RH:int = 25;
        private const OCTAVES:int = 8;
        private var freqs:Array = [0, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 1100];
        private var notes:Array = ["A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#"];
        private var inputs:Array = [];
        private var checks:Array = [];
        private var sound:Sound;
        private var t:int = 0;
        
        public function FlashTest() {
            var i:int;
            
            for(i=0; i<12; i++) {
                new Label(this, 0, 100+i*RH, notes[i]);
                inputs.push(new InputText(this, 20, 100+i*RH, freqs[i]));
                inputs[i].width = 40;
            }
            for(var o:int=0; o<OCTAVES; o++) { 
                for(i=0; i<12; i++) {
                    checks.push(new CheckBox(this, 70+o*20, 100+i*RH + 3));
                }
            }
            
            new PushButton(this, 0, 0, "-1", function(e:*):void { transpose(-1); });
            new PushButton(this, 105, 0, "+1", function(e:*):void { transpose(1); });
            new PushButton(this, 0, 25, "-12", function(e:*):void { transpose(-12); });
            new PushButton(this, 105, 25, "+12", function(e:*):void { transpose(12); });
            sound = new Sound();
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onSampleData);
            sound.play();
        }
        
        private function transpose(offset:int):void {
            var newstate:Array = [], i:int;
            for(i=0; i<checks.length; i++) newstate[i+offset] = checks[i].selected;
            for(i=0; i<checks.length; i++) checks[i].selected = newstate[i];
        }

        private function onSampleData(e:SampleDataEvent):void {
            var i:int;

            for (i = 0; i < 8192; i++, t++) {
                var out:Number = 0;//Math.sin(t/44100*Math.PI * 440);
/*
                for(i=0; i<checks.length; i++) {
                    if(checks[i].selected) out += Math.sin(t/44100*Math.PI * 440);    
                }
                */
                e.data.writeFloat(out);
                e.data.writeFloat(out);
            }            
        }
    }
}