/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Au4r
 */

package {
    import flash.events.Event;
    import flash.geom.*;
    import flash.filters.*;
    import flash.display.*;
    import flash.text.*;
    import net.hires.debug.Stats;
    [SWF(frameRate="60")]
    public class FlashTest extends Sprite {
        private var _field : BitmapData;
        private var _nbullet : int;
        private const LIMBULLET : int = 10000;
        private var _firstbullet : Bullet;
        private var _lastbullet : Bullet;
        
        private const INTERVAL : int = 1;
        private var _timecount : int;
        private var _bevel : BitmapFilter = new GradientBevelFilter(4.0, 45, [0xffffff, 0x0000ff], [1.0, 1.0], [70, 255], 4.0, 4.0, 1, 2, "inner");
        
        private var _bmd : BitmapData;
        
        public function FlashTest() {
            _field = new BitmapData(465, 465, false);
            var bmp : Bitmap = new Bitmap(_field);
            addChild(bmp);
            addChild(new Stats());
            
            _firstbullet = null;
            _lastbullet = null;
            _nbullet = 0;
            _timecount = 0;
            
            var tf:TextField = new TextField();
            tf.y = 100;
            tf.textColor = 0xFFFFFF;
            tf.background = true;
            tf.backgroundColor = 0x000000;
            tf.autoSize = TextFieldAutoSize.LEFT;
            addChild(tf);
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                tf.text = "bullets:"+_nbullet;
            });
            
            _bmd = getBullet(10, 0xffffff);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e : Event) : void
        {
            _timecount++;
            var b : Bullet;
            var i : int;
            if(_timecount == INTERVAL){
                _timecount = 0;
                for(i = 0;i < 20;i++){
                    b = new Bullet();
                    b._r = 10;
                    b._x = new Point(Math.random() * 465, -20);
                    b._v = new Point(Math.random() * 3 - 1.5, Math.random() * 6 + 2.0);
                    b._a = new Point(0, 0);
                    
                    if(_lastbullet == null){
                        _firstbullet = b;
                        _lastbullet = b;
                    }else{
                        _lastbullet._next = b;
                        b._prev = _lastbullet;
                        _lastbullet = b;
                    }
                    _nbullet++;
                }
            }
            
            _field.lock();
            
            _field.fillRect(_field.rect, 0x000000);
            for(b = _firstbullet;b != null;b = b._next){
                _field.copyPixels(_bmd, _bmd.rect, new Point(b._x.x - b._r, b._x.y - b._r));
                
//                b._v.x += b._a.x; b._v.y += b._a.y;
                b._x.x += b._v.x; b._x.y += b._v.y;
                if(b._x.x < -b._r || b._x.x > 465 + b._r || b._x.y > 465 + b._r){
                   _nbullet--;
                   if(b._prev)b._prev._next = b._next;
                   if(b._next)b._next._prev = b._prev;
                   if(b == _firstbullet)_firstbullet = b._next;
                   if(b == _lastbullet)_lastbullet = b._prev;
                }
            }
            
            _field.unlock();
        }
        
        private function getBullet(r : Number, color : uint) : BitmapData
        {
            var s : Shape = new Shape();
            s.graphics.beginFill(color);
            s.graphics.drawCircle(r, r, r);
            s.graphics.endFill();
        
            var ret : BitmapData = new BitmapData(2 * r, 2 * r, true, 0x00000000);
            ret.draw(s);
            ret.applyFilter(ret, ret.rect, new Point(0, 0), _bevel);
            return ret;
        }
    }
}

import flash.geom.Point;
  
class Bullet {
    public var _r : Number;
    public var _x : Point;
    public var _v : Point;
    public var _a : Point;
    
    public var _prev : Bullet = null;
    public var _next : Bullet = null;
}