/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Au1Y
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*
    import flash.text.*;
    import flash.media.*;
    public class FlashTest extends Sprite {
        private var url:String = "rtmfp://p2p.rtmfp.net/3ea2ccfc17227d122a776d41-31e9e4d71a17/";
        
        private var gs:GroupSpecifier;//接続グループ機能制限
        private var nc:NetConnection;
        private var group:NetGroup;
        private var groupName:String;       
        
        private var txt1:TextField = new TextField();
        private var txt2:TextField = new TextField();
        public function FlashTest() {
            // write as3 code here..
            addChild(txt1);
            txt1.border = true;
            txt1.text = url;
            txt1.width = 450;
            txt1.height = 300;
            
            //addChild(txt2);
            txt2.border = true;
            txt2.width = 450;
            txt2.y = 200;
            
            init();
            doConnect();
        }
        
        private var _netConnection:NetConnection;
 
        private function doConnect():void{
        　　nc = new NetConnection();
        　　nc.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);//通信イベント
        　　nc.connect(url);
        }
 
        //通信イベント
        private function netStatusHandler(event:NetStatusEvent):void {
            var now:Date = new Date();
            txt1.appendText("\n"+now.toLocaleTimeString());
            txt1.appendText("    info.code : "+event.info.code);
            switch (event.info.code) {
                case "NetConnection.Connect.Success"://接続確立
                    txt1.appendText("\nRTMFP通信開始");
                    //onConnect();
                    groupConnect();
                    break;
                case "NetConnection.Connect.Failed":// 接続に失敗した
                    txt1.appendText("\n接続失敗");
                    break;
                case "NetConnection.Connect.Closed":// 接続が閉じられた
                    txt1.appendText("\nRTMFP通信終了");
                    break;
                case "NetGroup.Connect.Success"://グループ接続確立
                    txt1.appendText("\nグループへの接続成功");
                    txt1.appendText("\n"+groupName);
                    break;
                case "NetGroup.Neighbor.Connect"://メンバー接続
                    txt1.appendText("\nメンバー接続");
                    txt1.appendText("\nPeerID:"+event.info.peerID);
                    txt1.appendText("\nネイバー："+event.info.neighbor+"\n");
                    break;
                case "NetGroup.Neighbor.Disconnect"://メンバー切断
                    txt1.appendText("\nメンバー切断");
                    txt1.appendText("\nPeerID:"+event.info.peerID);
                    txt1.appendText("\nネイバー："+event.info.neighbor+"\n");
                    break;
            }
            txt1.scrollV = txt1.numLines;//オートスクロール
        }
        
        private function init():void{
            // グループ機能制限
            groupName = new String();
            groupName = "net.wonderfl.ozmap.test111"
            gs = new GroupSpecifier(groupName);//接続グループ名
            gs.postingEnabled = true;//ポスティング許可
            gs.ipMulticastMemberUpdatesEnabled = true;//IP情報のマルチキャスト許可
            gs.multicastEnabled = true;//NetStreamによるストリーミング許可
            gs.objectReplicationEnabled = true;//オブジェクトの複製許可
            gs.routingEnabled = true;//NetGroupでの転送メソッド許可
            gs.serverChannelEnabled = true;//メンバーへサーバーチャンネルを開く権限を付与
        }
        
        private function groupConnect():void{
            group = new NetGroup(nc, gs.groupspecWithAuthorizations());
            group.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
        }

        
        private function onConnect():void {
            txt1.appendText("\nnearID: " + nc.nearID);//クライアントID
            txt1.appendText("\nfarID:" + nc.farID);//接続先(Stratus)ID
            
        }
 
        //IDを略語に置き換える
        //
 
    }
}