/**
 * Copyright nicoptere ( http://wonderfl.net/user/nicoptere )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Ath8
 */

package  
{
	import com.bit101.components.ComboBox;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    /**
     * @author Nicolas Barradeau
     * http://en.nicoptere.net
     */
    public class JoinTheDots extends Sprite 
    {
        
        static private const NONE:String = 'none';
        static private const VERTICAL:String = 'vertical';
        static private const HORIZONTAL:String = 'horizontal';
        static private const RANDOMIZE:String = 'randomize';
        
        //raw coordinates output
        private var coords:Array = [  42.2, 54.55, 43.05, 51.7, 43.05, 48.8, 43.05, 48.8, 43.05, 42.85, 39.9, 39.35, 39.9, 39.35, 36.7, 35.75, 32.1, 35.75, 32.1, 35.75, 28.05, 35.75, 25.7, 37.75, 25.7, 37.75, 23.35, 39.65, 23.35, 41.9, 23.35, 41.9, 23.35, 43.65, 24.75, 46.15, 24.75, 46.15, 26.15, 48.7, 26.15, 50, 26.15, 50, 26.15, 51.7, 25.1, 52.85, 25.1, 52.85, 24, 54, 22.45, 54, 22.45, 54, 20.5, 54, 18.9, 52.1, 18.9, 52.1, 17.25, 50.1, 17.25, 46.65, 17.25, 46.65, 17.25, 41.35, 21.8, 37.25, 21.8, 37.25, 26.35, 33.15, 34.15, 33.15, 34.15, 33.15, 43.8, 33.15, 48.4, 38.8, 48.4, 38.8, 51.75, 42.95, 51.75, 47.95, 51.75, 47.95, 51.75, 51.35, 50.25, 55, 50.25, 55, 48.7, 58.6, 44.45, 63.45, 44.45, 63.45, 37.6, 71.15, 36.1, 74.4, 36.1, 74.4, 34.55, 77.6, 34.25, 83.2, 34.25, 83.2, 33.3, 83.2, 32.3, 83.2, 32.3, 83.2, 32.65, 77.3, 33.8, 73.45, 33.8, 73.45, 34.95, 69.55, 38.55, 62.65, 38.55, 62.65, 41.35, 57.35, 42.2, 54.55, 33.6, 99.45, 31.4, 99.45, 29.9, 97.95, 29.9, 97.95, 28.35, 96.4, 28.35, 94.25, 28.35, 94.25, 28.35, 92.05, 29.9, 90.55, 29.9, 90.55, 31.4, 89, 33.6, 89, 33.6, 89, 35.8, 89, 37.35, 90.55, 37.35, 90.55, 38.85, 92.05, 38.85, 94.25, 38.85, 94.25, 38.85, 96.4, 37.3, 97.95, 37.3, 97.95, 35.75, 99.45, 33.6, 99.45 ];
        
        //normalized coordinates
        private var normalized:Vector.<Point> = new Vector.<Point>();
        
        //upscaled points
        private var points:Vector.<Point> = new Vector.<Point>();
		private var comboBox:ComboBox;
        
        
        public function JoinTheDots() 
        {
            
            var i:int;
            var p:Point;
			
			// we'll find the bounding box of the points
            var minX:Number = Number.POSITIVE_INFINITY;
            var minY:Number = Number.POSITIVE_INFINITY;
            var maxX:Number = Number.NEGATIVE_INFINITY;
            var maxY:Number = Number.NEGATIVE_INFINITY;
            
			var tmp:Vector.<Point> = new Vector.<Point>();
            
            for( i = 0; i < coords.length; i+=6 )
            {
                
                p = new Point( coords[ i ], coords[ i + 1 ] );
                
                minX = ( p.x < minX ) ? p.x : minX;
                maxX = ( p.x > maxX ) ? p.x : maxX;
                
                minY = ( p.y < minY ) ? p.y : minY;
                maxY = ( p.y > maxY ) ? p.y : maxY;
                
                tmp.push( p );
                graphics.drawCircle( p.x, p.y, 2 );
                
            }
            
            var w:int = ( maxX - minX );
            var h:int = ( maxY - minY );
            var bbox:Rectangle = new Rectangle( minX, minY, w, h );
            
            for each( p in tmp )
            {
                
                //offset of half the bounding box (centers the content around 0 )
                p.x -= w / 2;
                p.y -= h / 2;
                
                //inlined normalization
                normalized.push( new Point( ( p.x - minX ) / (maxX - minX ), 
                                            ( p.y - minY ) / ( maxY - minY ) ) );
                
            }

            graphics.lineStyle( 0, 0x00FF00 );
            graphics.drawRect( bbox.x, bbox.y, w, h );
            graphics.lineStyle( 0, 0x00FF00 );
            drawCurves( coords );
            trace( 'bounding box: ', bbox );
            

            var ratio:Number = w / h;	//keeping track of the ratio W/H
            var scale:Number = 400;     // upscale
            var size:Number = 5;    // box size
            

            graphics.lineStyle( 0, 0 );
            
            for each( p in normalized )
            {
                p.x *= ratio * scale;
                p.y *= scale;
                
                graphics.drawRect(  stage.stageWidth / 2 + p.x - size * .5,
                                    stage.stageHeight / 2 + p.y - size * .5,
                                    size, 
                                    size );
                                    
                points.push( new Point( stage.stageWidth / 2 + p.x, stage.stageHeight / 2 + p.y ) );
                
            }
            
            //unchanged drawing order
            join( points );
            
            comboBox = new ComboBox( this, 350, 10, "sorting method" );
            comboBox.items = 	[
								{ label:'none', value:NONE }, 
								{ label:'random', value:RANDOMIZE }, 
								{ label:'vertical', value:VERTICAL }, 
								{ label:'horizontal', value:HORIZONTAL }, 
								];
								
			comboBox.addEventListener( Event.SELECT, onComboBoxChange );
			
        }
		
		private function onComboBoxChange( e:Event ):void 
		{
			
			graphics.clear();
			graphics.lineStyle( 0, 0x00FF00 );
			drawCurves( coords );
			join( points, comboBox.selectedItem.value, 0xFF0000 );
			
		}
        
        //renders the curves as vectorized from flash
        private function drawCurves( coords:Array ):void
        {
            var i:int;
            var p0:Point, p1:Point, p2:Point;
            
            for ( i = 0; i < coords.length; i += 6 ) 
            {
                p0 = new Point( coords[ i ], coords[ i + 1 ] );
                p1 = new Point( coords[ i + 2 ], coords[ i + 3 ] );
                p2 = new Point( coords[ i + 4 ], coords[ i + 5 ] );
                
                graphics.moveTo( p0.x, p0.y );
                graphics.curveTo( p1.x, p1.y, p2.x, p2.y );
                
            }
            
        }
        
        private function join( points:Vector.<Point>, sortMethod:String = NONE, color:uint = 0xFF0000 ):void 
        {
            var tmp:Vector.<Point> = points.concat();
            
            if ( sortMethod != NONE )
            {
                
                tmp.sort( this[ sortMethod ] );
                
            }
            
            graphics.lineStyle( 2, color );
            
            graphics.moveTo( tmp[ 0 ].x, tmp[ 0 ].y );
            for each( var p:Point in tmp ) 
            {
                graphics.lineTo( p.x, p.y );
            }
            graphics.lineStyle( 0 );
            for each( p in tmp ) 
            {
                graphics.drawRect( p.x - 2.5, p.y - 2.5, 5, 5 );
            }
        }
        
        private function randomize( a:Point, b:Point ):Number
        {
            return ( Math.random() > .5 ) ? -1 : 1;
        }
        
        private function vertical( a:Point, b:Point ):Number
        {
            return ( a.y < b.y ) ? -1 : 1;
        }
        
        private function horizontal( a:Point, b:Point ):Number
        {
            return ( a.x < b.x ) ? -1 : 1;
        }
        
    }

}