/**
 * Copyright inu ( http://wonderfl.net/user/inu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AtZx
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * ...
     * @author inu
     * Scroller
     * iPhoneのホーム画面のようなもの。
     * ドラッグ操作でページ推移
     */
    public class Main extends Sprite {
        
        private var pageControl:PageControl;
        
        public function Main():void {
            
            graphics.beginFill(0x888888);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();     
            
            var scroller:Scroller = new Scroller(465, 465);
            
            var pageNum:int = Math.random() * 4 + 3;
            for (var i:int = 0; i < pageNum;i++ )scroller.addPage(new Page());
            scroller.addEventListener("stop", 
                function(e:Event):void { pageControl.update(scroller.page) }
            );
            addChild(scroller);
            
            addChild(new Bar());
            addChild(pageControl=new PageControl(pageNum));
        }
    }
    
}

import flash.display.Sprite;
import flash.events.*;
import flash.geom.Rectangle;
import flash.text.*;
import flash.utils.Timer;

class Scroller extends Sprite
{
    private var pageW:int;
    private var pageH:int;
    public var page:int=0;
    
    private var pageNum:int;
    
    private var mouseX1:Number=0;
    private var mouseX2:Number=0;
    
    public function Scroller(pageW:int,pageH:int) 
    {
        this.pageW = pageW;
        this.pageH = pageH;
        addEventListener(MouseEvent.MOUSE_DOWN, down);
        addEventListener(MouseEvent.MOUSE_UP, up);
        addEventListener(MouseEvent.MOUSE_MOVE, move);
        addEventListener(MouseEvent.ROLL_OUT, out);
    }
    
    private function down(e:MouseEvent):void {
        mouseX2 = e.stageX;
        mouseX1 = e.stageX;
        startDrag(false,new Rectangle(width,0,-(pageNum+1)*width,0));
        removeEventListener(Event.ENTER_FRAME,ent);
    }
    
    private function move(e:MouseEvent):void {
        if (!e.buttonDown) return;
        mouseX2=mouseX1;
        mouseX1=e.stageX;
    }
    
    private function up(e:MouseEvent):void {
        stopDrag();
        
        if (mouseX1 - mouseX2 > 1) page--;
        else if (mouseX1 - mouseX2 < -1) page++;
        else page = -(x - pageW / 2) / pageW;
        
        if (page > pageNum-1) page = pageNum-1;
        if (page < 0) page = 0;
        dispatchEvent(new Event("stop"));
        addEventListener(Event.ENTER_FRAME, ent);
    }
    
    private function out(e:MouseEvent):void {
        if (!e.buttonDown) return;
        up(e);
    }
    
    private function ent(e:Event):void {
        x += (-page * pageW - x) / 4;
        if (Math.abs(-page * pageW - x) < 2) {
            x = -page * pageW;
            removeEventListener(Event.ENTER_FRAME, ent);
            
        }
    }
    
    public function addPage(sprite:Sprite):void {
        graphics.drawRect(pageNum*pageW, 0, pageW, pageH);
        sprite.x = pageNum*pageW;
        sprite.y = 0;
        addChild(sprite);
        pageNum++;
    }
    
}

class Bar extends TextField {
    
    public function Bar() {
        
        var format:TextFormat = new TextFormat(null,15,0xffffff,true,null,null,null,null,"center");
        defaultTextFormat = format;
        
        selectable = false;
        background = true;
        backgroundColor = 0x000000;
        height = 25;
        width = 465;
        
        text = new Date().toString();
        
        var timer:Timer = new Timer(1000, 0);
        timer.addEventListener(TimerEvent.TIMER,
            function(e:TimerEvent):void { text = new Date().toString(); }
        );
        timer.start();
        
        alpha = 0.3;
    }
}

class PageControl extends Sprite {
    private var num:int;
    
    public function PageControl(num:int) {
        this.num = num;
        x = (465 - (num+1) * 20) / 2;
        y = 425;
        
        update(0);
    }
    
    public function update(page:int):void {
        graphics.clear();
        for (var i:int = 0; i < num; i++ ) {
            if (i == page) graphics.beginFill(0xffffff);
            else graphics.beginFill(0xffffff,0.3);
            graphics.drawCircle(20*(i+1), 20, 7);
        }
    }
}

class Page extends Sprite {
    
    public function Page():void {
        graphics.beginFill(0x888888);
        graphics.drawRect(0, 0, 465, 465);
        graphics.endFill();
        
        var iconNum:int = Math.random() * 15 + 2;
        
        for (var i:int = 0; i < iconNum; i++ ) {
            graphics.lineStyle(2, 0x000000);
            graphics.beginFill(Math.random()*0xffffff);
            graphics.drawRoundRect((i % 4 + 1) * 111 - 90, (int(i / 4) + 1) * 100 - 65, 90,90,20);
        }
    }
}
