/**
 * Copyright guinetik ( http://wonderfl.net/user/guinetik )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/At7T
 */

package 
{
    
    import flash.display.Sprite;
    import flash.geom.Matrix;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]

    public class FlashTest extends Sprite
    {
        
        public function FlashTest()
        {
            
            var matr:Matrix = new Matrix();
            matr.createGradientBox(100, 100, 0, -50, -50);
            
            for (var i:int = 0; i < 30; i++) 
            {
                
                var squ:Square = new Square();
                var c:Number = Math.random() * 0xFFFFFF;
                squ.graphics.beginGradientFill("radial", [c, c+100], [1, 0], [0x00, 0xFF], matr);
                squ.graphics.drawRect(-50, -50, 100, 100);
                squ.graphics.endFill();
                
                squ.maxW = squ.width;
                squ.maxH = squ.height;
                
                squ.offsetH = squ.offsetW = 60;
                squ.growAmmount = Math.random();
                
                squ.x = Math.random() * (stage.stageWidth - squ.width/2);
                squ.y = Math.random() * (stage.stageHeight - squ.height/2);
                
                squ.easing = Math.random()/10;
                
                addChild(squ);
                
            }
            
        }
        
    }
    
}

import flash.display.Sprite;
import flash.events.Event;

class Square extends Sprite
{
    
    private var menor                :Boolean         = false;
    
    private var posx                :Number;
    private var posy                :Number;
    private var targetX                :Number;
    private var targetY                :Number;
    private var vx                    :Number;
    private var vy                    :Number;
    
    public var changeDimensions        :Boolean        = true;
    
    public var easing                :Number         = 0.01;
    
    public var offsetW                :Number            = 10;
    public var offsetH                :Number            = 10;
    
    public var offsetX                :Number            = 10;
    public var offsetY                :Number            = 10;
    
    public var maxW                    :Number;
    public var maxH                    :Number;
    
    public var growAmmount            :Number            = 0.1;
    
    public function Square() 
    {
        
        this.addEventListener(Event.ADDED_TO_STAGE, startLoop);
        this.addEventListener(Event.REMOVED_FROM_STAGE, clearLoop);
        
    }
    
    private function clearLoop(e:Event):void 
    {
        
        removeEventListener(Event.REMOVED_FROM_STAGE, clearLoop);
        this.removeEventListener(Event.ENTER_FRAME, float);
        
    }
    
    private function startLoop(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, startLoop);
        
        this.targetX                = this.x + offsetX;
        this.targetY                 = this.y + offsetY;
        this.vx                     = 0;
        this.vy                     = 0;
        
        this.addEventListener(Event.ENTER_FRAME, float);            
        
    }
    
    public function float(e:Event):void
    {
        
        var ax:Number                     = (this.targetX - this.x) * Math.random()*this.easing;
        var ay:Number                     = (this.targetY - this.y) * Math.random()*this.easing;
        
        this.vx                         += ax/2;
        this.vy                         += ay/2;
        
        this.x                             += vx;
        this.y                             += vy;
        
        
        if (changeDimensions)
        {
            
            if ((this.width <= maxW || this.height <= maxH) && menor)
            {
                
                this.width                +=growAmmount;
                this.height                +=growAmmount;
                
            } else 
            {
                
                menor                    = false;
                
                this.width                -= growAmmount;
                this.height             -= growAmmount;
                
                if (this.width <= offsetW || this.height <= offsetH) 
                {
                    menor                 = true;
                    vx = vy                = 0;
                }
                
            }
            
        }
        
    }
    
}