/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/At2L
 */

// forked from ProjectNya's forked from: soundtest8 - Trash
// forked from gaina's soundtest8 - Trash
//色って難しい
//もうわけかわらん状態
//pixelでどうにかして

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.display.PixelSnapping;
    import org.papervision3d.core.effects.BitmapColorEffect;
    import org.papervision3d.core.geom.Pixels
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.materials.BitmapColorMaterial;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    import frocessing.color.ColorHSV;

    [SWF(width=465, height=465, backgroundColor=0x000000)]

    public class Main extends BasicView
    {
        private var NUM:int = 256;
        private var rot:Number = 0;
        private var snd:Sound;
        private var sndChannel:SoundChannel;
        private var LRarr:Array = [];
        private var FFTswitcher:Boolean = false;
        private static var scale:uint = 16;
        private var matrix:Matrix;
        private var colorTrans:ColorTransform;
        private var canvas:Bitmap;
        private var bmpData:BitmapData;

        public function Main():void 
        {
            Wonderfl.capture_delay(2);
            playSound("http://dhai-haif.rhcloud.com/lxpp/music/jynhznl.mp3");
            camera.zoom = 2 ;
        }

        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10, true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, onComp);
        }

        private function onComp(e:Event):void 
        {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            sndChannel=new SoundChannel();
            sndChannel = snd.play(0, 5);
            LRarr = draw();
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.CLICK, FFTSwitch);
            bmpData = new BitmapData(Math.ceil(465/scale), 465/scale, false, 0xFF000000);
            canvas = new Bitmap(bmpData, PixelSnapping.NEVER, true);
            canvas.scaleX = canvas.scaleY = scale;
            canvas.blendMode = BlendMode.ADD;
            addChild(canvas);
            matrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
            colorTrans = new ColorTransform(2, 2, 2, 1, 0, 0, 0, 0);
        }

        private function FFTSwitch(e:MouseEvent):void 
        {
            if (FFTswitcher) { FFTswitcher = false } else { FFTswitcher = true; }
        }

        private function loop(event:Event):void 
        {
            bmpData.lock();
            bmpData.fillRect(bmpData.rect, 0xFF000000);
            bmpData.draw(viewport, matrix, colorTrans, BlendMode.ADD);
            bmpData.unlock();

            rot += 1%360;

            camera.x = 500 * Math.sin(rot * Math.PI / 180);
            camera.z = 500 * Math.cos(rot * Math.PI / 180);
            camera.y = 500 * Math.cos(rot * Math.PI / 180);
            camera.zoom += ( 50 - camera.zoom) / 10;

            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, FFTswitcher, 0);

            for (var n:int = 0; n < 2; n++)
            {
                var soundArray:Array = LRarr[n];
                for (var i:int = 0; i < 256; i++)
                {
                    var px:Pixel3D = new Pixel3D(0xFF000000);
                    px = soundArray[i];
                    var data:Number = bytes.readFloat();
                    
                    if (i == 0)
                    {
                        if (data>0.35)
                        {
                            camera.zoom = 0;
                        }
                    }
                    
                    if (10 < i <50)
                    {
                        if (data>0.3)
                        {
                            rot += 10;
                        }
                    }
                    
                    
                }
            }
        }
        
        private function draw():Array
        {
            var master_arr:Array = [];

            var _effect:BitmapEffectLayer = new BitmapEffectLayer(viewport, 465, 465);
             _effect.addEffect(new BitmapColorEffect(1, 1, 1, 0.85));
            viewport.containerSprite.addLayer(_effect);

            var pxs:Pixels = new Pixels(_effect);
            scene.addChild(pxs);

            for (var n:int = 0; n < 32; n++)
            {
                var lr_arr:Array = [];
                for (var i:int = 0; i < NUM; i++)
                {
                    var xx:Number = Math.random() * 1000 - 500;
                    var yy:Number = Math.random() * 1000 - 500;
                    var zz:Number = Math.random() * 1000 - 500;
                    
                    var color:ColorHSV = new ColorHSV(Math.random()*360, Math.random()*0.4 + 0.6);
                    var px:Pixel3D = new Pixel3D(color.value32, xx, yy, zz);
                    pxs.addPixel3D(px);
                    lr_arr.push(px);
                }
                master_arr.push(lr_arr);
            }
            return master_arr;
        }

    }

}
