/**
 * Copyright challengeyh ( http://wonderfl.net/user/challengeyh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ArAw
 */

// forked from code's 親オブジェクト自体の回転
package
{
	/*
	*appendRotationを使った親オブジェクト自体の回転
	*
	*/
	
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	public class setSpherePosition2 extends Sprite
	{
		//プロパティ
		private var paBase:Sprite;
		private var base:Sprite;

		private const RADIUS:uint = 200;
		private var itemNumber:uint;
		private var planeWidth:uint = 20;
		private var planeHeight:uint = 20;
		private const imgMargin:uint = 80;
		private var imgWidth:uint = planeWidth + imgMargin;
		private var imgHeight:uint = planeHeight + imgMargin;
		
		private var isMouseOut:Boolean = true;
		private var axisAngle:Number = Math.PI * 2 / 3;
		private var myAngle:Number = Math.PI;	
		
		
		//コンストラクタ
		public function setSpherePosition2()
		{
			//プロファイラ
			//SWFProfiler.init(stage, this);
			
			//ステージに関する情報設定
			setStage();
	
			//画像の初期配置
			setPosition();
	
			//イベントリスナー登録
			addEventListener(Event.ENTER_FRAME, loopHandler);
			stage.addEventListener(Event.RESIZE, stageResizeHandler);
			stage.addEventListener(MouseEvent.MOUSE_OUT, mouseOutHandler);
			stage.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
		//デバッグ用	
		//	stage.addEventListener(MouseEvent.CLICK, loopHandler);
		}
		
		private function setStage():void 
		{			
			//基準点をステージの中心へ
			paBase = new Sprite();
			paBase.x = stage.stageWidth/2;
			paBase.y = stage.stageHeight/2;
			paBase.graphics.clear();
			paBase.graphics.beginFill(0xffffff, 0);
			paBase.graphics.drawRect( -stage.stageWidth / 2, -stage.stageHeight / 2, stage.stageWidth, stage.stageHeight);
			paBase.graphics.endFill();
			addChild(paBase);

			//オブジェクトコンテナ
			base = new Sprite();
			base.x = 0;
			base.y = 0
			base.z = 0;
			paBase.addChild(base);	
			
			//ステージのクオリティ
			stage.quality = StageQuality.MEDIUM;
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
		}
		
		private function setPosition():void 
		{
			var unitY:int = (RADIUS * 2 * Math.PI) / 2 / imgHeight;
			var angleAlpha:Number;
			var angleBeta:Number=Math.PI/2;
			
			itemNumber = 0;
			
			for (var i:uint = 0; i < unitY; i++)
			{
				
				angleAlpha = 0;
				
				//円周上に配置できる画像数を計算
				var alphaSets:int=Math.floor((2 * RADIUS * Math.cos(angleBeta) * Math.PI) / imgWidth);
				
				for (var j:uint = 0; j < alphaSets; j++) 
				{
					var plane:Sprite = new Sprite();
					plane.graphics.clear();
					plane.graphics.beginFill(0xffffff*Math.random(), 1);
					plane.graphics.drawRect( -imgWidth / 2+imgMargin/2, -imgHeight / 2+imgMargin/2, planeWidth,planeHeight);
					plane.graphics.endFill();
					
					plane.rotationX = -angleBeta/Math.PI/2*360;
					plane.rotationY = angleAlpha/Math.PI/2*360;
					
					plane.x = RADIUS * Math.cos(angleBeta) * Math.sin(angleAlpha);
					plane.y=RADIUS * Math.sin(angleBeta);
					plane.z=RADIUS * Math.cos(angleBeta) * Math.cos(angleAlpha);
					
					angleAlpha += Math.PI * 2 / alphaSets;
					plane.name = "plane" + itemNumber.toString();
					
					base.addChild(plane);
					itemNumber++;
				}
				
				angleBeta -= Math.PI / unitY;
				
			}
		}
		

		
		//イベントリスナー定義==================================================
		private function loopHandler(e:Event):void 
		{
			//回転処理
			if (isMouseOut) {
				myAngle *= 0.97;
			}else {
				myAngle = Math.min(RADIUS, Math.max(Math.abs(mouseY - stage.stageHeight / 2), Math.abs(mouseX - stage.stageWidth / 2)))/100;	
			}
			
			var myAxis:Number = Math.PI / 2 + Math.atan2((mouseY - stage.stageHeight / 2), (mouseX - stage.stageWidth / 2));	
			var vx:Number = Math.cos(myAxis);
			var vy:Number = Math.sin(myAxis);
			var axis:Vector3D = new Vector3D(vx, vy, 0);
			
			base.transform.matrix3D.appendRotation(myAngle, axis);
			
			//深度ソート
			var sortArray:Array=[];

			for(var i:int=0; i <itemNumber; i++)
			{
				var myPlane:Sprite=base.getChildByName("plane" + i.toString())as Sprite;
				var mat:Matrix3D=myPlane.transform.getRelativeMatrix3D(this);
				sortArray.push({myplane:myPlane, z:mat.position.z});
			}
		
			sortArray.sortOn("z", Array.NUMERIC | Array.DESCENDING);
			
			for (i = 0; i < itemNumber; i++)
			{
				myPlane = sortArray[i].myplane as Sprite;
				base.setChildIndex(myPlane, i);
				
				myPlane.alpha= 1.1 - (sortArray[i].z / RADIUS );
			}	
			
				
			
		}
	
		private function stageResizeHandler(e:Event):void 
		{
			paBase.x = stage.stageWidth / 2;
			paBase.y = stage.stageHeight / 2;
			paBase.graphics.clear();
			paBase.graphics.beginFill(0xffffff, 0);
			paBase.graphics.drawRect( -stage.stageWidth / 2, -stage.stageHeight / 2, stage.stageWidth, stage.stageHeight);
			paBase.graphics.endFill();
		}
		
		private function mouseOutHandler(e:MouseEvent):void 
		{
			isMouseOut = true;
		}
				
		private function mouseOverHandler(e:MouseEvent):void 
		{
			isMouseOut = false;
		}
		
	
	}
}