/**
 * Copyright itsDcTurner ( http://wonderfl.net/user/itsDcTurner )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AqqA
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import gs.TweenLite;
    import gs.easing.*;
    
    public class FlashTest extends Sprite {
        
        private static const colourPool:Array = [0xb7b7b7, 0xb7d2c9, 0x29f2b8];
        private static const minSize:Number = 5;
        private static const maxSize:Number = 100;
        public var sizeScope:Number;
        public var stageWidth:Number;
        public var stageHeight:Number;
        
        public function FlashTest() {
            // write as3 code here..
          sizeScope = randRange(minSize, maxSize);
          stageWidth = stage.width;
          stageHeight = stage.height;
          stage.quality = "MEDIUM";
          
          var total:Number = randRange(10,400);
          for (var i:Number= total; i>0 ; i--){
           addBox();   
          }
        }
        
        public function addBox():void{
           var test:Sprite = new Sprite();
            addChild(test);
            var g:Object = test.graphics;
            g.beginFill(colourPool[Math.round(Math.random()*colourPool.length)]);
            var size:Number = randRange(minSize, maxSize);
            var xDest:Number = randRange(0, stage.stageWidth);
            var yDest:Number = randRange(0, stage.stageHeight);
            var zDest:Number = randRange(0,1000);
            g.drawRect(xDest, yDest, size, size); 
            test.z = zDest;  
            test.rotationY = spin(xDest);
            rotateBox(test);
        }
        
        private function rotateBox($target:Sprite):void{
			        	
   			var xDest:Number = $target.rotationX + Math.random()* 90-45;    	
   			var yDest:Number = $target.rotationY + Math.random()* 90-45; 
   			var zDest:Number = $target.rotationZ + Math.random()* 90-45; 
      		var time:Number  = .5 + Math.random()*8;
      		  	
        		TweenLite.to($target, time, {rotationX:xDest, rotationY:yDest, rotationZ:zDest, alpha:.1+Math.random()*.9, ease:Elastic.easeOut, onComplete:rotateBox, onCompleteParams:[$target]});
        } 	
        
        public function randRange($min:Number, $max:Number):Number{
            return $min + Math.random()*($max - $min);
        }
         
        public function spin($x:Number):Number{
            return $x;
        }
    }
}