/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AqJl
 */

package {
	import org.papervision3d.view.*;
	import org.papervision3d.lights.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.objects.primitives.*;
	
    import flash.events.Event;
    
    [SWF(backgraundColor="0x000000")]
    public class PV3DTest extends BasicView {
    	
    		private var _sphere:Sphere;
    		
        public function PV3DTest() {
        		
        		// ライトの設定
        		var light:PointLight3D =new PointLight3D(true, false);
        		scene.addChild(light);
        		
        		// マテリアル
        		var material:CompositeMaterial = new CompositeMaterial();
        		//material.addMaterial( new WireframeMaterial(0) );
        		material.addMaterial( new ColorMaterial(0x88CCCC) );
      		material.addMaterial( new FlatShadeMaterial(light, 0xFFFFFFFF, 0x000000, 50) );
      		
        		// オブジェクト
            _sphere = new Sphere(material, 200, 10, 10);
            scene.addChild(_sphere);
            
            // レンダリング開始
            startRendering();
            
            // フレームイベントの追加
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        // 毎フレームの処理
        private function onEnterFrame(e:Event):void {
        		// オブジェクトを回転
        		_sphere.rotationY += 0.5;
        }
    }
}