/**
 * Copyright heroboy ( http://wonderfl.net/user/heroboy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Aq5W
 */

package {
    import flash.text.TextField;
    import flash.display.*;
    import flash.events.*;
    import net.hires.debug.Stats;
    [SWF(frameRate = "60")]
    public class FlashTest extends Sprite 
    {
        public static const UP:int = 0;
        public static const RIGHT:int = 1;
        public static const DOWN:int = 2;
        public static const LEFT:int =3;
        public static const BLACK:uint = 0xff000000;
        public static const WHITE:uint = 0xffffffff;
        public var bitmap:BitmapData;
        public var textField:TextField;
        public var step:int = 0;
        public var currentX:int;
        public var currentY:int;
        public var currentDir:int;
        
        public function FlashTest() 
        {
            bitmap = new BitmapData(stage.stageWidth/4,stage.stageHeight/4,false,WHITE);
            var b:Bitmap = addChild(new Bitmap(bitmap)) as Bitmap;
            b.width = stage.stageWidth;
            b.height = stage.stageWidth;
            
            currentX = bitmap.width/2;
            currentY = bitmap.height/2;
            currentDir = UP;
            textField = new TextField;
            textField.x = 200;
            addChild(textField);
            addChild(new Stats());
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        
        public function onEnterFrame(e:Event):void
        {
            if (currentX>=0&&currentX<bitmap.width&&
                currentY>=0&&currentY<bitmap.height)
            {
                if (bitmap.getPixel32(currentX,currentY)==WHITE)
                {
                    bitmap.setPixel(currentX,currentY,BLACK);
                    currentDir = (currentDir + 3)%4;
                }
                else
                {
                    bitmap.setPixel(currentX,currentY,WHITE);                    
                    currentDir = (currentDir+1)%4;
                }
                if (currentDir==UP)
                    --currentY;
                else if (currentDir==DOWN)
                    ++currentY;
                else if (currentDir==LEFT)
                    --currentX;
                else if (currentDir==RIGHT)
                    ++currentX;
                ++step;
                textField.text=step.toString();
            }
        }

    }
}