/**
 * Copyright yooyke ( http://wonderfl.net/user/yooyke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Aq3f
 */

// forked from Motonobu.Shinotsuka's forked from: Matrix3D.transformVector()
// forked from umhr's Matrix3D.transformVector()
/*
Matrix3D.transformVector();
と同じ機能の関数を作ってみる。
MAC 10,0,2,54,MAC 10,0,12,36で動作確認。

処理としては
deltaTransformVectorに平行移動ぶんの変換を加えただけ。
だが、MAC 10,0,2,54では、部分的に1/20している。
相変わらず意味不明。

kokaodifj
各要素をrandomで値を入れて、transformVectdadweaddadsorし、
行列の各要素を比較して確認とした。

Matrix3D.transformVector()
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/geom/Matrix3D.html#transformVector()
*/
package {
    import flash.display.Sprite;
    import flash.geom.Matrix3D;
    import flash.geom.Orientation3D;
    import flash.text.TextField;
    import flash.geom.Vector3D;
    import flash.system.Capabilities;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var txt:String="◆同機能関数Mtrx3D.transformVector　"+Capabilities.version+"での実行結果\n\n";
            
            //確認用の値を用意
            var entity:Matrix3D=new Matrix3D(Util.random16());
            var entity1:Matrix3D=new Matrix3D();
            var entity2:Matrix3D=new Matrix3D();
            var v:Vector3D = new Vector3D(Math.random()*200-100,Math.random()*200-100,Math.random()*200-100,Math.random()*200-100);
            
            //実行
            var v1:Vector3D = entity.transformVector(v);
            var v2:Vector3D = Mtrx3D.transformVector(entity,v);
            
            //確認
            txt+="↓Matrix3D.transformVectorの結果\n"+v1+v1.w+"\n";
            txt+="\n↓同機能関数Mtrx3D.transformVectorの結果\n"+v2+v2.w+"\n\n";
            txt+=Util.hikaku2(v1,v2);
            
            //テキストフィールドを作りtxtを流し込み。
            var tf:TextField = new TextField();
            tf.width=stage.stageWidth;
            tf.height=stage.stageHeight;
            tf.wordWrap=true;
            stage.addChild(tf);
            tf.text=txt;
        }
    }
}
import flash.display.Sprite;
class Mtrx3D extends Sprite {
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    import flash.system.Capabilities;
    public static function transformVector(entity:Matrix3D,v:Vector3D):Vector3D{
        var e:Vector.<Number> = Vector.<Number>(entity.rawData);
        var scale:Vector.<Number>=new Vector.<Number>(16,true);
        
        //10.0.1.54以前なら20分の１する。
        var ver_array:Array = Capabilities.version.substr(4).split(",");
        var n:Number = (int(ver_array[2])*1000+int(ver_array[3]) > 2054)?1:1/20;
        
        var _v:Vector3D = new Vector3D();
        _v.x = (e[0]*v.x+e[4]*v.y+e[8]*v.z)*n+e[12];
        _v.y = (e[1]*v.x+e[5]*v.y+e[9]*v.z)*n+e[13];
        _v.z = (e[2]*v.x+e[6]*v.y+e[10]*v.z)*n+e[14];
        _v.w = (e[3]*v.x+e[7]*v.y+e[11]*v.z+e[15])*n;
        return _v;
    }
}
class Util {
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    public static function hikaku(v0:Vector.<Number>,v1:Vector.<Number>):String {
        var _str:String="↓二つのMatrix3Dの要素毎の差\n";
        var _n:int=v0.length;
        for (var i:int=0; i<_n; i++) {
            _str += "["+i+"]:"+(v0[i]-v1[i])+"\n";
        }
        return _str;
    }
    public static function hikaku2(v0:Vector3D,v1:Vector3D):String {
        var _str:String="↓二つのVector3Dの要素毎の差\n";
        _str += ".x:"+(v0.x-v1.x)+"\n";
        _str += ".y:"+(v0.y-v1.y)+"\n";
        _str += ".z:"+(v0.z-v1.z)+"\n";
        _str += ".w:"+(v0.w-v1.w)+"\n";
        return _str;
    }

    public static function random16():Vector.<Number> {
        var _v:Vector.<Number>=new Vector.<Number>(16,true);
        for (var i:int=0; i<16; i++) {
            _v[i]=Math.random()*200-100;
        }
        return _v;
    }
    public static function random9():Vector.<Number> {
        var _mt:Matrix3D = new Matrix3D();
        var v:Vector.<Vector3D>=new Vector.<Vector3D>  ;
        v[0]=new Vector3D(200*Math.random()-100,200*Math.random()-100,200*Math.random()-100);//平行移動、
        v[1]=new Vector3D(10*Math.random()-5,10*Math.random()-5,10*Math.random()-5);//回転
        v[2]=new Vector3D(100*Math.random(),100*Math.random(),100*Math.random());//拡大 / 縮小
        _mt.recompose(v);
        return _mt.rawData;
    }
}