/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AoGJ
 */

// forked from siouxcitizen's URLとそのパラメータ取得の練習失敗
//RSS経由？でTwitterデータを検索・取得処理の練習
//
//「Search」ボタン押下で、Twitterのデータを「#wonderfl」と「siouxcitizen」という検索条件で検索・取得して表示します
//
//↓今回の「Twitterデータの検索・取得」の実装にあたっては以下コードを参考にさせて頂きました。
//twitter APIで検索
//http://wonderfl.net/c/wn01
//Ascii Art Hanabi
//http://wonderfl.net/c/GO9L/
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;

    import flash.net.URLRequest;
    import flash.net.URLLoader;
    import flash.net.navigateToURL;
    import flash.utils.escapeMultiByte;
    public class ButtonTest extends Sprite {
        
        private var updateButton : SimpleButton;//ボタン 
        private var searchButton : SimpleButton;//ボタン 
        private var stateLabel : TextField;    //ラベル
        private var dispLabel : TextField;    //ラベル
        private var loader:URLLoader;
    
        public function ButtonTest() {
            loader = new URLLoader();
            loader.addEventListener(Event.COMPLETE, completeHandler);
            loader.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);

            stateLabel = new TextField;
            stateLabel.text = "TweetTest!";
            stateLabel.y = 1;
            addChild(stateLabel);
            
            dispLabel = new TextField;
            dispLabel.height = 500;
            dispLabel.width = 500;
            dispLabel.y = 100;
            addChild(dispLabel);

            updateButton = new CustomButton("Tweet");
            updateButton.y = 20;

            searchButton = new CustomButton("Search");
            searchButton.y = 50;

            updateButton.addEventListener(MouseEvent.MOUSE_DOWN,onUpdateBtnDown);
            updateButton.addEventListener(MouseEvent.MOUSE_UP,onUpdateBtnUp);
            searchButton.addEventListener(MouseEvent.MOUSE_DOWN,onSearchBtnDown);
            searchButton.addEventListener(MouseEvent.MOUSE_UP,onSearchBtnUp);
            addChild(updateButton);
            addChild(searchButton);
        }

        //「Tweet」ボタン押下時の処理
        private function onUpdateBtnDown(evt:MouseEvent):void {
            stateLabel.text = "Tweet!!!";
            var comment:String = "FlashからTwitterへの投稿機能のテストです ";
            var post:String = comment + " " + "http://wonderfl.net/c/AoGJ/" + " " + "#wonderfl ";
            navigateToURL(new URLRequest("http://twitter.com/home?status=" + escapeMultiByte(post)), "_blank");
        }

        //「Tweet」ボタンリリース時の処理
        private function onUpdateBtnUp(evt:MouseEvent):void {
            stateLabel.text = "TweetTest!";
        }

        //「検索」ボタン押下時の処理
        private function onSearchBtnDown(evt:MouseEvent):void {
            stateLabel.text = "Search!!!";
            loader.load(new URLRequest("http://search.twitter.com/search.atom?q=%23wonderfl%20siouxcitizen&rpp=10"));
        } 

        //「検索」ボタンリリース時の処理
        private function onSearchBtnUp(evt:MouseEvent):void {
            stateLabel.text = "TweetTest!";
        }

        //Twitterデータ検索・読み込み正常終了時の処理
        private function completeHandler(evt:Event):void {
            default xml namespace = new Namespace("http://www.w3.org/2005/Atom");
            var htmlText:XML = XML(loader.data);
            var title:XMLList = htmlText.entry.title;
            var dispString:String = "";
            for each(var c:XML in  title) {
                dispString += c.toString() + "\n\n";
            }
            dispLabel.text = dispString;
        }

        //IOエラー時の処理
        private function ioErrorHandler(evt:Event):void {
                dispLabel.text = "IO ERROR";
        }
    }
}

import flash.display.*;
import flash.system.*;
import flash.text.*;

//カスタムボタン
class CustomButton extends SimpleButton { 
        //コンストラクタ    
        public function CustomButton(label:String="") {
            //状態
            upState = makeSprite(label,0x00FFFF);
            overState = upState;
            downState = makeSprite(label,0x00FF00);
            hitTestState = upState;
        }

        //ボタン用スプライト作成
        private function makeSprite(text:String,color:uint):Sprite{
            //ボタン用ラベル作成
            var label : TextField = new TextField();
            label.text = text;
            label.autoSize = TextFieldAutoSize.CENTER;
            label.selectable = false;

            //ボタン用スプライト作成
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(color);
            sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
            sp.graphics.endFill();
            sp.alpha = 0.8;            
            sp.addChild(label);
            
            //ラベル用フォーマット設定
            var format:TextFormat=new TextFormat();
            format.font = "Courier New";
            format.bold = true;
            format.size = 13;
            label.setTextFormat(format);

            return sp;
        }    
}
