/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Ao3P
 */

// forked from abakane's Scratch スクラッチカード的なの
package
{
    import flash.geom.ColorTransform;
    import com.bit101.components.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Matrix;
    import flash.net.*;
    import flash.system.Security;
    [SWF(width=465,height=465,backgroundColor=0x0,frameRate=30)]

    public class Scratch extends Sprite
    {
        private var loader:Loader;
        private var bmp:Bitmap;
        private var bmpd:BitmapData;
        private var shape:Shape;
        private var toggleButton:PushButton;
        private var clearButton:PushButton;
        private var brushSize:Number = 80.0;
        private var brushStrength:Number = 0.5;//0.0〜1.0
        
        public function Scratch()
        {
            Security.loadPolicyFile( "http://bkmrk.abakane.com/crossdomain.xml");
            loader = new Loader();
            loader.load( new URLRequest("http://bkmrk.abakane.com/lab/lib/monalisa.jpg") );
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onComplete);//
        }
        
        private function onComplete( e:Event ):void
        {
            loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, onComplete);//
            loader.addEventListener( MouseEvent.MOUSE_DOWN, onDown);//
            loader.addEventListener( MouseEvent.MOUSE_UP, onUp);//
            addChild( loader );
            
            shape = new Shape();
            shape.graphics.beginFill( 0x0 );
            shape.graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight);
            shape.graphics.endFill();
            
            bmpd = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0x0);
            bmp = new Bitmap(bmpd);
            bmp.blendMode = BlendMode.MULTIPLY;
            addChild( bmp );
            
            clearButton = new PushButton( this, 5, 5, "CLEAR");
            clearButton.addEventListener( MouseEvent.CLICK, onClear);//
            toggleButton = new PushButton( this, clearButton.width+10, 5, "blendMode = " + bmp.blendMode);
            toggleButton.addEventListener( MouseEvent.CLICK, onSelect);//
            toggleButton.toggle = true;
        }
        
        private function onDown( e:MouseEvent):void
        {
            stage.addEventListener( MouseEvent.MOUSE_MOVE, onMove);//
            stage.addEventListener(Event.ENTER_FRAME, 
            function (e:Event):void {bmpd.colorTransform(bmpd.rect, 
            new ColorTransform(.99,.99,.99))});
        }
        private function onUp( e:MouseEvent ):void
        {
            stage.removeEventListener( MouseEvent.MOUSE_MOVE, onMove);
        }
        private function onMove( e:MouseEvent ):void
        {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox( brushSize, brushSize, 0, mouseX-brushSize*0.5, mouseY-brushSize*0.5);
            shape.graphics.clear();
            shape.graphics.beginGradientFill( GradientType.RADIAL, [0xFFFFFF, 0xFFFFFF], [brushStrength, 0], [0x80, 0xFF], matrix, SpreadMethod.PAD);
            shape.graphics.drawCircle(mouseX, mouseY, brushSize*0.5);
            shape.graphics.endFill();
            bmpd.draw( shape, null, null, null, null, true);
        }
        private function onSelect( e:MouseEvent ):void
        {
            bmp.blendMode = toggleButton.selected ? BlendMode.NORMAL : BlendMode.MULTIPLY;
            toggleButton.label = "blendMode = " + bmp.blendMode;
        }
        private function onClear( e:MouseEvent ):void
        {
            bmpd.fillRect( bmpd.rect, 0x0);
        }
    }
}